"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _dashboardHelper = _interopRequireDefault(require("../../service/dashboardHelper"));
/**
 * @api {post} /api/overview/daily-reported daily-reported
 * @apiName daily-reported
 * @apiGroup overview
 * @apiDescription list of reported mails of last 7 days
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *  {
 *      "success":true,
 *      "reportedEmails":[ 
 *          {"count":5,"date":"2023-02-14"},
 *          {"count":24,"date":"2023-02-10"}]
 * }
 *
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return (0, _dashboardHelper["default"])("RETPIR6", {
            companyId: companyId
          });
        case 4:
          result = _context.sent;
          res.status(200).json({
            success: true,
            result: result === null || result === void 0 ? void 0 : result.data
          });
          _context.next = 12;
          break;
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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