"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
/**
 * @api {post} /api/overview/recent-reported recent-reported
 * @apiName recent-reported
 * @apiGroup overview
 * @apiDescription list of 5 most recent reported mails 
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *    { 
 *      "success":true,
 *      "reportedEmails":[
 *      {"_id":"63ebd30e5463e78fb1064a09","from":"awareness@kratikal.com","subject":"Your Mail has been successfully Reported"},
 *      {"_id":"63ebd2ea5463e78fb10649ec","from":"himanshu.bisht@kratikal.com","subject":"Buddy Assign"},
 *      {"_id":"63ebce8b081d559ace566d0f","from":"mnnitsarvesh@outlook.com","subject":"Feedback Experience"},
 *      {"_id":"63ebce66081d559ace566cfb","from":"himanshu.bisht@kratikal.com","subject":"New sign - in from Zoho account"},
 *      {"_id":"63ebce44081d559ace566cd8","from":"awareness@kratikal.com","subject":"Your Mail has been successfully Reported"}]
 *    }
 *
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, condition, reportedEmails;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          _context.next = 5;
          return db.ReportedMail.find(condition).select('from subject ').sort({
            'createdAt': -1
          }).limit(5);
        case 5:
          reportedEmails = _context.sent;
          res.status(200).json({
            success: true,
            reportedEmails: reportedEmails
          });
          _context.next = 13;
          break;
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 13:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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