"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _dashboardHelper = _interopRequireDefault(require("../../service/dashboardHelper"));
/**
 * @api {post} /api/overview/top-reporters top-reporters
 * @apiName top-reporters
 * @apiGroup overview
 * @apiDescription list of 5 most top reporters  
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *     { 
 *       "success":true,
 *       "reportedEmails":[
 *          {"_id":"arpit@kdmarc.com","count":24},
 *          {"_id":"gaurav@kdmarc.com","count":3},
 *          {"_id":"vikas@kdmarc.com","count":2}],
 *       "count":29
 *     }
 *
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, condition, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          _context.next = 5;
          return (0, _dashboardHelper["default"])("RETPIR1", condition);
        case 5:
          result = _context.sent;
          res.status(200).json({
            success: true,
            result: result.data,
            count: result.count
          });
          _context.next = 13;
          break;
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 13:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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