"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _dashboardHelper = _interopRequireDefault(require("../../service/dashboardHelper"));
/**
 * @api {post} /api/overview/top-reporters top-reporters
 * @apiName top-reporters
 * @apiGroup overview
 * @apiDescription list of 5 most top reporters  
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *     { 
 *       "success":true,
 *       "reportedEmails":[
 *          {"_id":"arpit@kdmarc.com","count":24},
 *          {"_id":"gaurav@kdmarc.com","count":3},
 *          {"_id":"vikas@kdmarc.com","count":2}],
 *       "count":29
 *     }
 *
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return (0, _dashboardHelper["default"])("RETPIR5", {
            isDeletedEmail: "true",
            companyId: companyId
          });
        case 4:
          result = _context.sent;
          res.status(200).json({
            success: true,
            senders: result === null || result === void 0 ? void 0 : result.data
          });
          _context.next = 12;
          break;
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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