"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _dashboardHelper = _interopRequireDefault(require("../../service/dashboardHelper"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, condition, topUrls, topAttachments;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId
          };
          _context.next = 5;
          return (0, _dashboardHelper["default"])("RETPIR3", condition);
        case 5:
          topUrls = _context.sent;
          console.log({
            topUrls: topUrls
          });
          _context.next = 9;
          return (0, _dashboardHelper["default"])("RETPIR4", condition);
        case 9:
          topAttachments = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            success: true,
            topAttachments: topAttachments === null || topAttachments === void 0 ? void 0 : topAttachments.data,
            topUrls: topUrls === null || topUrls === void 0 ? void 0 : topUrls.data
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.log("error", _context.t0);
          next(_context.t0);
        case 17:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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