"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, domainsOfCurrentCompany, uniqueDomains, namesOfdomains, uniqueDomainNames, trashedMails, suspiciousMails, pendingMails, safeMails;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId; //HERE WE ARE SELCTING THE DOMAINS THAT ARE NOT DELETED AND FOR DOMAINTYPE = 'OUTLOOK' FOR GSUITE DOMAINTYPE STORED IN REPORTEDEMAILS SCHEMA IS 'Gsuite'
          //WE HAVE 2 OPTIONS '0FFICE365' AND 'EXCHANGE' FOR 'OFFICE365'  DOMAINTYPE = 'Outlook' and for
          //EXCHANGE IT IS 'Exchange'.
          // here two sets are for storing only unique domainType/domainType for outlook and domainId
          // cuz for two domains the domainType could be same but still they can have same domainType i.e Gsuite or Outlook 
          _context.next = 4;
          return db.Domain.find({
            companyId: companyId,
            deletedAt: null
          }).select("domainType domainTypeForOutlook");
        case 4:
          domainsOfCurrentCompany = _context.sent;
          uniqueDomains = new Set(); // for doamin id
          domainsOfCurrentCompany.map(function (currentDomain) {
            uniqueDomains.add(currentDomain._id);
          });
          namesOfdomains = [];
          domainsOfCurrentCompany.map(function (value) {
            if (value.domainType === "Gsuite") {
              namesOfdomains.push("Gsuite");
            } else {
              namesOfdomains.push("Outlook");
              namesOfdomains.push(value.domainTypeForOutlook === "EXCHANGE" ? "Exchange" : value.domainTypeForOutlook);
            }
          });
          domainsOfCurrentCompany = (0, _toConsumableArray2["default"])(uniqueDomains);
          uniqueDomainNames = new Set(); // for domainType
          namesOfdomains.map(function (value) {
            console.log(value);
            uniqueDomainNames.add(value);
          });
          namesOfdomains = (0, _toConsumableArray2["default"])(uniqueDomainNames);
          domainsOfCurrentCompany = domainsOfCurrentCompany.map(function (value) {
            return value._id;
          });
          _context.next = 16;
          return db.ReportedMail.countDocuments({
            companyId: companyId,
            isRecoveredEmail: "false",
            isTrashedEmail: "true",
            isDeletedEmail: "false",
            domainId: {
              $in: domainsOfCurrentCompany
            },
            mailType: {
              $in: namesOfdomains
            }
          });
        case 16:
          trashedMails = _context.sent;
          _context.next = 19;
          return db.ReportedMail.countDocuments({
            companyId: companyId,
            isRecoveredEmail: "false",
            isTrashedEmail: "false",
            isDeletedEmail: "true",
            domainId: {
              $in: domainsOfCurrentCompany
            },
            mailType: {
              $in: namesOfdomains
            }
          });
        case 19:
          suspiciousMails = _context.sent;
          _context.next = 22;
          return db.ReportedMail.countDocuments({
            companyId: companyId,
            isRecoveredEmail: "false",
            isTrashedEmail: "false",
            isDeletedEmail: "false",
            domainId: {
              $in: domainsOfCurrentCompany
            },
            mailType: {
              $in: namesOfdomains
            }
          });
        case 22:
          pendingMails = _context.sent;
          _context.next = 25;
          return db.ReportedMail.countDocuments({
            companyId: companyId,
            isRecoveredEmail: "true",
            isTrashedEmail: "false",
            isDeletedEmail: "false",
            domainId: {
              $in: domainsOfCurrentCompany
            },
            mailType: {
              $in: namesOfdomains
            }
          });
        case 25:
          safeMails = _context.sent;
          res.status(200).json({
            success: true,
            trashedMails: trashedMails,
            suspiciousMails: suspiciousMails,
            pendingMails: pendingMails,
            safeMails: safeMails
          });
          _context.next = 33;
          break;
        case 29:
          _context.prev = 29;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 33:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 29]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImNvbXBhbnlJZCIsInVzZXIiLCJkYiIsIkRvbWFpbiIsImZpbmQiLCJkZWxldGVkQXQiLCJzZWxlY3QiLCJkb21haW5zT2ZDdXJyZW50Q29tcGFueSIsInVuaXF1ZURvbWFpbnMiLCJTZXQiLCJtYXAiLCJjdXJyZW50RG9tYWluIiwiYWRkIiwiX2lkIiwibmFtZXNPZmRvbWFpbnMiLCJ2YWx1ZSIsImRvbWFpblR5cGUiLCJwdXNoIiwiZG9tYWluVHlwZUZvck91dGxvb2siLCJ1bmlxdWVEb21haW5OYW1lcyIsImNvbnNvbGUiLCJsb2ciLCJSZXBvcnRlZE1haWwiLCJjb3VudERvY3VtZW50cyIsImlzUmVjb3ZlcmVkRW1haWwiLCJpc1RyYXNoZWRFbWFpbCIsImlzRGVsZXRlZEVtYWlsIiwiZG9tYWluSWQiLCIkaW4iLCJtYWlsVHlwZSIsInRyYXNoZWRNYWlscyIsInN1c3BpY2lvdXNNYWlscyIsInBlbmRpbmdNYWlscyIsInNhZmVNYWlscyIsInN0YXR1cyIsImpzb24iLCJzdWNjZXNzIiwiYXBpUm91dGVyIiwiZXhwcmVzcyIsIlJvdXRlciIsInJvdXRlIiwiZ2V0Iiwic2FuaXRpemUiLCJqd3RTdHJhdGVneSJdLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9hcGkvb3ZlcnZpZXcvd2hvLWVsc2UuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGV4cHJlc3MgZnJvbSBcImV4cHJlc3NcIjtcblxuaW1wb3J0IHsgc2FuaXRpemUgfSBmcm9tIFwiLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVyXCI7XG5pbXBvcnQgeyBqd3RTdHJhdGVneSB9IGZyb20gXCIuLi8uLi9taWRkbGV3YXJlcy9zdHJhdGVneVwiO1xuXG5sZXQgY29udHJvbGxlciA9IGFzeW5jIChyZXEsIHJlcywgbmV4dCkgPT4ge1xuICB0cnkge1xuICAgIGNvbnN0IGNvbXBhbnlJZCA9IHJlcS51c2VyLmNvbXBhbnlJZDtcbiAgICAvL0hFUkUgV0UgQVJFIFNFTENUSU5HIFRIRSBET01BSU5TIFRIQVQgQVJFIE5PVCBERUxFVEVEIEFORCBGT1IgRE9NQUlOVFlQRSA9ICdPVVRMT09LJyBGT1IgR1NVSVRFIERPTUFJTlRZUEUgU1RPUkVEIElOIFJFUE9SVEVERU1BSUxTIFNDSEVNQSBJUyAnR3N1aXRlJ1xuICAgIC8vV0UgSEFWRSAyIE9QVElPTlMgJzBGRklDRTM2NScgQU5EICdFWENIQU5HRScgRk9SICdPRkZJQ0UzNjUnICBET01BSU5UWVBFID0gJ091dGxvb2snIGFuZCBmb3JcbiAgICAvL0VYQ0hBTkdFIElUIElTICdFeGNoYW5nZScuXG4gICAgIC8vIGhlcmUgdHdvIHNldHMgYXJlIGZvciBzdG9yaW5nIG9ubHkgdW5pcXVlIGRvbWFpblR5cGUvZG9tYWluVHlwZSBmb3Igb3V0bG9vayBhbmQgZG9tYWluSWRcbiAgICAvLyBjdXogZm9yIHR3byBkb21haW5zIHRoZSBkb21haW5UeXBlIGNvdWxkIGJlIHNhbWUgYnV0IHN0aWxsIHRoZXkgY2FuIGhhdmUgc2FtZSBkb21haW5UeXBlIGkuZSBHc3VpdGUgb3IgT3V0bG9vayBcblxuICAgIGxldCBkb21haW5zT2ZDdXJyZW50Q29tcGFueSA9IGF3YWl0IGRiLkRvbWFpbi5maW5kKHtcbiAgICAgIGNvbXBhbnlJZCxcbiAgICAgIGRlbGV0ZWRBdDogbnVsbCxcbiAgICB9KS5zZWxlY3QoXCJkb21haW5UeXBlIGRvbWFpblR5cGVGb3JPdXRsb29rXCIpO1xuXG4gICAgbGV0IHVuaXF1ZURvbWFpbnMgPSBuZXcgU2V0KCk7Ly8gZm9yIGRvYW1pbiBpZFxuXG4gICAgZG9tYWluc09mQ3VycmVudENvbXBhbnkubWFwKChjdXJyZW50RG9tYWluKSA9PiB7XG4gICAgICB1bmlxdWVEb21haW5zLmFkZChjdXJyZW50RG9tYWluLl9pZCk7XG4gICAgfSk7XG5cbiAgICBsZXQgbmFtZXNPZmRvbWFpbnMgPSBbXTtcblxuICAgIGRvbWFpbnNPZkN1cnJlbnRDb21wYW55Lm1hcCgodmFsdWUpID0+IHtcbiAgICAgIGlmICh2YWx1ZS5kb21haW5UeXBlID09PSBcIkdzdWl0ZVwiKSB7XG4gICAgICAgIG5hbWVzT2Zkb21haW5zLnB1c2goXCJHc3VpdGVcIik7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBuYW1lc09mZG9tYWlucy5wdXNoKFwiT3V0bG9va1wiKTtcbiAgICAgICAgbmFtZXNPZmRvbWFpbnMucHVzaChcbiAgICAgICAgICB2YWx1ZS5kb21haW5UeXBlRm9yT3V0bG9vayA9PT0gXCJFWENIQU5HRVwiXG4gICAgICAgICAgICA/IFwiRXhjaGFuZ2VcIlxuICAgICAgICAgICAgOiB2YWx1ZS5kb21haW5UeXBlRm9yT3V0bG9va1xuICAgICAgICApO1xuICAgICAgfVxuICAgIH0pO1xuXG4gICAgZG9tYWluc09mQ3VycmVudENvbXBhbnkgPSBbLi4udW5pcXVlRG9tYWluc107XG5cbiAgICBsZXQgdW5pcXVlRG9tYWluTmFtZXMgPSBuZXcgU2V0KCk7IC8vIGZvciBkb21haW5UeXBlXG5cbiAgICBuYW1lc09mZG9tYWlucy5tYXAoKHZhbHVlKSA9PiB7XG4gICAgICBjb25zb2xlLmxvZyh2YWx1ZSk7XG4gICAgICB1bmlxdWVEb21haW5OYW1lcy5hZGQodmFsdWUpO1xuICAgIH0pO1xuXG4gICAgbmFtZXNPZmRvbWFpbnMgPSBbLi4udW5pcXVlRG9tYWluTmFtZXNdO1xuXG4gICAgZG9tYWluc09mQ3VycmVudENvbXBhbnkgPSBkb21haW5zT2ZDdXJyZW50Q29tcGFueS5tYXAoKHZhbHVlKSA9PiB7XG4gICAgICByZXR1cm4gdmFsdWUuX2lkO1xuICAgIH0pO1xuICAgIFxuICAgIGNvbnN0IHRyYXNoZWRNYWlscyA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5jb3VudERvY3VtZW50cyh7XG4gICAgICBjb21wYW55SWQsXG4gICAgICBpc1JlY292ZXJlZEVtYWlsOiBcImZhbHNlXCIsXG4gICAgICBpc1RyYXNoZWRFbWFpbDogXCJ0cnVlXCIsXG4gICAgICBpc0RlbGV0ZWRFbWFpbDogXCJmYWxzZVwiLFxuICAgICAgZG9tYWluSWQ6IHsgJGluOiBkb21haW5zT2ZDdXJyZW50Q29tcGFueSB9LFxuICAgICAgbWFpbFR5cGU6IHsgJGluOiBuYW1lc09mZG9tYWlucyB9LFxuICAgIH0pO1xuICAgIGNvbnN0IHN1c3BpY2lvdXNNYWlscyA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5jb3VudERvY3VtZW50cyh7XG4gICAgICBjb21wYW55SWQsXG4gICAgICBpc1JlY292ZXJlZEVtYWlsOiBcImZhbHNlXCIsXG4gICAgICBpc1RyYXNoZWRFbWFpbDogXCJmYWxzZVwiLFxuICAgICAgaXNEZWxldGVkRW1haWw6IFwidHJ1ZVwiLFxuICAgICAgZG9tYWluSWQ6IHsgJGluOiBkb21haW5zT2ZDdXJyZW50Q29tcGFueSB9LFxuICAgICAgbWFpbFR5cGU6IHsgJGluOiBuYW1lc09mZG9tYWlucyB9LFxuICAgIH0pO1xuICAgIGNvbnN0IHBlbmRpbmdNYWlscyA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5jb3VudERvY3VtZW50cyh7XG4gICAgICBjb21wYW55SWQsXG4gICAgICBpc1JlY292ZXJlZEVtYWlsOiBcImZhbHNlXCIsXG4gICAgICBpc1RyYXNoZWRFbWFpbDogXCJmYWxzZVwiLFxuICAgICAgaXNEZWxldGVkRW1haWw6IFwiZmFsc2VcIixcbiAgICAgIGRvbWFpbklkOiB7ICRpbjogZG9tYWluc09mQ3VycmVudENvbXBhbnkgfSxcbiAgICAgIG1haWxUeXBlOiB7ICRpbjogbmFtZXNPZmRvbWFpbnMgfSxcbiAgICB9KTtcbiAgICBjb25zdCBzYWZlTWFpbHMgPSBhd2FpdCBkYi5SZXBvcnRlZE1haWwuY291bnREb2N1bWVudHMoe1xuICAgICAgY29tcGFueUlkLFxuICAgICAgaXNSZWNvdmVyZWRFbWFpbDogXCJ0cnVlXCIsXG4gICAgICBpc1RyYXNoZWRFbWFpbDogXCJmYWxzZVwiLFxuICAgICAgaXNEZWxldGVkRW1haWw6IFwiZmFsc2VcIixcbiAgICAgIGRvbWFpbklkOiB7ICRpbjogZG9tYWluc09mQ3VycmVudENvbXBhbnkgfSxcbiAgICAgIG1haWxUeXBlOiB7ICRpbjogbmFtZXNPZmRvbWFpbnMgfSxcbiAgICB9KTtcblxuICAgIHJlc1xuICAgICAgLnN0YXR1cygyMDApXG4gICAgICAuanNvbih7XG4gICAgICAgIHN1Y2Nlc3M6IHRydWUsXG4gICAgICAgIHRyYXNoZWRNYWlscyxcbiAgICAgICAgc3VzcGljaW91c01haWxzLFxuICAgICAgICBwZW5kaW5nTWFpbHMsXG4gICAgICAgIHNhZmVNYWlscyxcbiAgICAgIH0pO1xuICB9IGNhdGNoIChlcnIpIHtcbiAgICBjb25zb2xlLmxvZyhlcnIpO1xuICAgIG5leHQoZXJyKTtcbiAgfVxufTtcbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoXCIvXCIpLmdldChzYW5pdGl6ZSgpLCBqd3RTdHJhdGVneSwgY29udHJvbGxlcik7XG5leHBvcnQgZGVmYXVsdCBhcGlSb3V0ZXI7XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBQTtBQUVBO0FBQ0E7QUFFQSxJQUFJQSxVQUFVO0VBQUEseUZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUU1QkMsU0FBUyxHQUFHSCxHQUFHLENBQUNJLElBQUksQ0FBQ0QsU0FBUyxFQUNwQztVQUNBO1VBQ0E7VUFDQztVQUNEO1VBQUE7VUFBQSxPQUVvQ0UsRUFBRSxDQUFDQyxNQUFNLENBQUNDLElBQUksQ0FBQztZQUNqREosU0FBUyxFQUFUQSxTQUFTO1lBQ1RLLFNBQVMsRUFBRTtVQUNiLENBQUMsQ0FBQyxDQUFDQyxNQUFNLENBQUMsaUNBQWlDLENBQUM7UUFBQTtVQUh4Q0MsdUJBQXVCO1VBS3ZCQyxhQUFhLEdBQUcsSUFBSUMsR0FBRyxFQUFFLEVBQUM7VUFFOUJGLHVCQUF1QixDQUFDRyxHQUFHLENBQUMsVUFBQ0MsYUFBYSxFQUFLO1lBQzdDSCxhQUFhLENBQUNJLEdBQUcsQ0FBQ0QsYUFBYSxDQUFDRSxHQUFHLENBQUM7VUFDdEMsQ0FBQyxDQUFDO1VBRUVDLGNBQWMsR0FBRyxFQUFFO1VBRXZCUCx1QkFBdUIsQ0FBQ0csR0FBRyxDQUFDLFVBQUNLLEtBQUssRUFBSztZQUNyQyxJQUFJQSxLQUFLLENBQUNDLFVBQVUsS0FBSyxRQUFRLEVBQUU7Y0FDakNGLGNBQWMsQ0FBQ0csSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUMvQixDQUFDLE1BQU07Y0FDTEgsY0FBYyxDQUFDRyxJQUFJLENBQUMsU0FBUyxDQUFDO2NBQzlCSCxjQUFjLENBQUNHLElBQUksQ0FDakJGLEtBQUssQ0FBQ0csb0JBQW9CLEtBQUssVUFBVSxHQUNyQyxVQUFVLEdBQ1ZILEtBQUssQ0FBQ0csb0JBQW9CLENBQy9CO1lBQ0g7VUFDRixDQUFDLENBQUM7VUFFRlgsdUJBQXVCLHVDQUFPQyxhQUFhLENBQUM7VUFFeENXLGlCQUFpQixHQUFHLElBQUlWLEdBQUcsRUFBRSxFQUFFO1VBRW5DSyxjQUFjLENBQUNKLEdBQUcsQ0FBQyxVQUFDSyxLQUFLLEVBQUs7WUFDNUJLLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDTixLQUFLLENBQUM7WUFDbEJJLGlCQUFpQixDQUFDUCxHQUFHLENBQUNHLEtBQUssQ0FBQztVQUM5QixDQUFDLENBQUM7VUFFRkQsY0FBYyx1Q0FBT0ssaUJBQWlCLENBQUM7VUFFdkNaLHVCQUF1QixHQUFHQSx1QkFBdUIsQ0FBQ0csR0FBRyxDQUFDLFVBQUNLLEtBQUssRUFBSztZQUMvRCxPQUFPQSxLQUFLLENBQUNGLEdBQUc7VUFDbEIsQ0FBQyxDQUFDO1VBQUM7VUFBQSxPQUV3QlgsRUFBRSxDQUFDb0IsWUFBWSxDQUFDQyxjQUFjLENBQUM7WUFDeER2QixTQUFTLEVBQVRBLFNBQVM7WUFDVHdCLGdCQUFnQixFQUFFLE9BQU87WUFDekJDLGNBQWMsRUFBRSxNQUFNO1lBQ3RCQyxjQUFjLEVBQUUsT0FBTztZQUN2QkMsUUFBUSxFQUFFO2NBQUVDLEdBQUcsRUFBRXJCO1lBQXdCLENBQUM7WUFDMUNzQixRQUFRLEVBQUU7Y0FBRUQsR0FBRyxFQUFFZDtZQUFlO1VBQ2xDLENBQUMsQ0FBQztRQUFBO1VBUElnQixZQUFZO1VBQUE7VUFBQSxPQVFZNUIsRUFBRSxDQUFDb0IsWUFBWSxDQUFDQyxjQUFjLENBQUM7WUFDM0R2QixTQUFTLEVBQVRBLFNBQVM7WUFDVHdCLGdCQUFnQixFQUFFLE9BQU87WUFDekJDLGNBQWMsRUFBRSxPQUFPO1lBQ3ZCQyxjQUFjLEVBQUUsTUFBTTtZQUN0QkMsUUFBUSxFQUFFO2NBQUVDLEdBQUcsRUFBRXJCO1lBQXdCLENBQUM7WUFDMUNzQixRQUFRLEVBQUU7Y0FBRUQsR0FBRyxFQUFFZDtZQUFlO1VBQ2xDLENBQUMsQ0FBQztRQUFBO1VBUElpQixlQUFlO1VBQUE7VUFBQSxPQVFNN0IsRUFBRSxDQUFDb0IsWUFBWSxDQUFDQyxjQUFjLENBQUM7WUFDeER2QixTQUFTLEVBQVRBLFNBQVM7WUFDVHdCLGdCQUFnQixFQUFFLE9BQU87WUFDekJDLGNBQWMsRUFBRSxPQUFPO1lBQ3ZCQyxjQUFjLEVBQUUsT0FBTztZQUN2QkMsUUFBUSxFQUFFO2NBQUVDLEdBQUcsRUFBRXJCO1lBQXdCLENBQUM7WUFDMUNzQixRQUFRLEVBQUU7Y0FBRUQsR0FBRyxFQUFFZDtZQUFlO1VBQ2xDLENBQUMsQ0FBQztRQUFBO1VBUElrQixZQUFZO1VBQUE7VUFBQSxPQVFNOUIsRUFBRSxDQUFDb0IsWUFBWSxDQUFDQyxjQUFjLENBQUM7WUFDckR2QixTQUFTLEVBQVRBLFNBQVM7WUFDVHdCLGdCQUFnQixFQUFFLE1BQU07WUFDeEJDLGNBQWMsRUFBRSxPQUFPO1lBQ3ZCQyxjQUFjLEVBQUUsT0FBTztZQUN2QkMsUUFBUSxFQUFFO2NBQUVDLEdBQUcsRUFBRXJCO1lBQXdCLENBQUM7WUFDMUNzQixRQUFRLEVBQUU7Y0FBRUQsR0FBRyxFQUFFZDtZQUFlO1VBQ2xDLENBQUMsQ0FBQztRQUFBO1VBUEltQixTQUFTO1VBU2ZuQyxHQUFHLENBQ0FvQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQ1hDLElBQUksQ0FBQztZQUNKQyxPQUFPLEVBQUUsSUFBSTtZQUNiTixZQUFZLEVBQVpBLFlBQVk7WUFDWkMsZUFBZSxFQUFmQSxlQUFlO1lBQ2ZDLFlBQVksRUFBWkEsWUFBWTtZQUNaQyxTQUFTLEVBQVRBO1VBQ0YsQ0FBQyxDQUFDO1VBQUM7VUFBQTtRQUFBO1VBQUE7VUFBQTtVQUVMYixPQUFPLENBQUNDLEdBQUcsYUFBSztVQUNoQnRCLElBQUksYUFBSztRQUFDO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUViO0VBQUEsZ0JBaEdHSCxVQUFVO0lBQUE7RUFBQTtBQUFBLEdBZ0diO0FBQ0QsSUFBTXlDLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsR0FBRyxDQUFDLElBQUFDLG1CQUFRLEdBQUUsRUFBRUMscUJBQVcsRUFBRS9DLFVBQVUsQ0FBQztBQUFDLGVBQy9DeUMsU0FBUztBQUFBIn0=