"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _jsonwebtoken = _interopRequireDefault(require("jsonwebtoken"));
var _config = _interopRequireDefault(require("../../config"));
var _errors = require("../../errors");
var apiRouter = _express["default"].Router();
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var token, payload, features;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          token = req.cookies.login_token;
          if (token) {
            _context.next = 4;
            break;
          }
          throw new _errors.RequestError('Not authenticated', 401);
        case 4:
          payload = _jsonwebtoken["default"].verify(token, _config["default"].app.secret);
          features = Array.isArray(payload.AF) ? payload.AF : [];
          return _context.abrupt("return", res.status(200).json({
            success: true,
            features: features
          }));
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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