"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _packageHelper = _interopRequireDefault(require("../../service/package-helper"));
var _jsonwebtoken = _interopRequireDefault(require("jsonwebtoken"));
var _config = _interopRequireDefault(require("../../config"));
var JWTSign = function JWTSign(iss, user, date, type, sudoPassword, companyFeatures) {
  return _jsonwebtoken["default"].sign({
    iss: _config["default"].app.name + '-' + iss,
    sub: user._id,
    type: type,
    iat: date.getTime(),
    AF: companyFeatures,
    exp: new Date().setMinutes(date.getMinutes() + 600),
    sudoPassword: sudoPassword ? sudoPassword : false
  }, _config["default"].app.secret);
};
var generateToken = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(companyId, user) {
    var _companyFeatures;
    var companyFeatures, token;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return db.CompanyFeature.find({
            companyId: companyId
          }).select({
            _id: 0,
            featureCode: 1
          });
        case 2:
          companyFeatures = _context.sent;
          companyFeatures = (_companyFeatures = companyFeatures) === null || _companyFeatures === void 0 ? void 0 : _companyFeatures.map(function (feature) {
            return feature.featureCode;
          });
          token = JWTSign('USER', user, new Date(), user.type, user.sudoPassword, companyFeatures);
          return _context.abrupt("return", token);
        case 6:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function generateToken(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var companyId, company, syncPackage, token;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          companyId = req.user.companyId;
          _context2.next = 4;
          return db.Company.findById(companyId);
        case 4:
          company = _context2.sent;
          if (company) {
            _context2.next = 7;
            break;
          }
          throw new RequestError("Company not found!", 404);
        case 7:
          _context2.next = 9;
          return _packageHelper["default"].syncPackageDetails(company);
        case 9:
          syncPackage = _context2.sent;
          token = null;
          console.log({
            syncPackage: syncPackage,
            company: company,
            change: company === null || company === void 0 ? void 0 : company.packageModifiedLocally
          });
          if (!syncPackage) {
            _context2.next = 19;
            break;
          }
          console.log("Existing package modified, updating token!");
          _context2.next = 16;
          return generateToken(companyId, req.user);
        case 16:
          token = _context2.sent;
          _context2.next = 26;
          break;
        case 19:
          if (!(company !== null && company !== void 0 && company.packageModifiedLocally)) {
            _context2.next = 26;
            break;
          }
          console.log("New package assigned, updating token!");
          _context2.next = 23;
          return generateToken(companyId, req.user);
        case 23:
          token = _context2.sent;
          _context2.next = 26;
          return db.Company.updateOne({
            _id: companyId
          }, {
            $set: {
              packageModifiedLocally: false
            }
          });
        case 26:
          if (token) {
            res.cookie('login_token', token, {
              httpOnly: true,
              secure: true,
              sameSite: 'Strict',
              maxAge: 180 * 60 * 1000
            });
          }
          return _context2.abrupt("return", res.status(200).json({
            success: true
          }));
        case 30:
          _context2.prev = 30;
          _context2.t0 = _context2["catch"](0);
          next(_context2.t0);
        case 33:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 30]]);
  }));
  return function controller(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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