"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  employeeId: _joi["default"].string().hex().length(24).required(),
  policyData: _joi["default"].array().items({
    name: _joi["default"].string().required(),
    value: _joi["default"].array().items(_joi["default"].any().valid('Read', 'Write', 'Delete')).required()
  }).required()
});

/**
 * @api {post} /api/v1/policy/add Add Policy
 * @apiName add-policy
 * @apiGroup Policy
 * @apiDescription Add Policies to an IAM user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  employeeId   Required Id of the IAM emplyoee
 * @apiBody   {Array}  policyData    Required key value pair of name of the policy and value of that particular policy ('Read', 'Write', 'Delete').
 * 
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Policy updated successfully"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Policy updated successfully"
 *       }
 *  
 *  @apiError (404)  {Boolean}  success     false
 *  @apiError (404)  {Array}    messages    Employee not Found
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Employee not Found"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, policyData, employeeId, companyId, employee, i, _policyData$i, name, value, policy;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, policyData = _req$body.policyData, employeeId = _req$body.employeeId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Employee.findOne({
            _id: employeeId,
            companyId: companyId
          });
        case 5:
          employee = _context.sent;
          if (employee) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Employee not Found', 404);
        case 8:
          i = 0;
        case 9:
          if (!(i < policyData.length)) {
            _context.next = 24;
            break;
          }
          _policyData$i = policyData[i], name = _policyData$i.name, value = _policyData$i.value;
          _context.next = 13;
          return db.EmployeePolicy.findOne({
            employeeId: employeeId,
            name: name
          });
        case 13:
          policy = _context.sent;
          if (!policy) {
            _context.next = 19;
            break;
          }
          _context.next = 17;
          return db.EmployeePolicy.updateOne({
            _id: policy._id
          }, {
            value: value
          });
        case 17:
          _context.next = 21;
          break;
        case 19:
          _context.next = 21;
          return db.EmployeePolicy.create({
            employeeId: employeeId,
            name: name,
            value: value
          });
        case 21:
          i++;
          _context.next = 9;
          break;
        case 24:
          res.status(201).send({
            success: true,
            message: "Policy updated successfully"
          });
          _context.next = 31;
          break;
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('IAM', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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