"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  employeeId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {get} /api/v1/policy/employee-policy?employeeId=63bbece26781cb50f1fa68ba  Policies of an IAM user
 * @apiName employee-policy
 * @apiGroup Policy
 * @apiDescription List policies of an IAM user
 * 
 * @apiQuery   {String}  employeeId   Required Id of the IAM emplyoee
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String}  policies   list of all policies of an employee
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "policies": [
 *               {
 *                   "_id": "63d0f1d278b9830aa47b3067",
 *                   "name": "Super User",
 *                   "value": [
 *                       "Read",
 *                       "Write",
 *                       "Delete"
 *                   ],
 *                   "createdAt": "2023-01-25T09:09:38.169Z",
 *                   "updatedAt": "2023-01-25T09:09:38.169Z",
 *                   "__v": 0
 *               },
 *               {
 *                   "_id": "63d0f1d278b9830aa47b306a",
 *                   "name": "Domain",
 *                   "value": [
 *                       "Read",
 *                       "Write",
 *                       "Delete"
 *                   ],
 *                   "createdAt": "2023-01-25T09:09:38.174Z",
 *                   "updatedAt": "2023-01-25T09:09:38.174Z",
 *                   "__v": 0
 *               },
 *           ]
 *       }
 *  
 *  @apiError (404)  {Boolean}  success     false
 *  @apiError (404)  {Array}    messages    Employee not Found
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Employee not Found"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var employeeId, policies;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          employeeId = req.query.employeeId;
          _context.next = 4;
          return db.EmployeePolicy.find({
            employeeId: employeeId
          });
        case 4:
          policies = _context.sent;
          res.status(201).send({
            success: true,
            policies: policies
          });
          _context.next = 12;
          break;
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('IAM', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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