"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
/**
 * @api {get} /api/v1/policy/list list
 * @apiName list
 * @apiGroup Policy
 * @apiDescription list of all policies 
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String}  policies   list of all policies
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *   "success": true,
 *   "policies": [
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e68",
 *           "name": "Super User",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.114Z",
 *           "updatedAt": "2023-01-25T08:36:26.114Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e69",
 *           "name": "Domain",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.115Z",
 *           "updatedAt": "2023-01-25T08:36:26.115Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6a",
 *           "name": "Emails",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.115Z",
 *           "updatedAt": "2023-01-25T08:36:26.115Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6b",
 *           "name": "Users",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.116Z",
 *           "updatedAt": "2023-01-25T08:36:26.116Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6c",
 *           "name": "IAM",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.117Z",
 *           "updatedAt": "2023-01-25T08:36:26.117Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6d",
 *           "name": "AdvancedSearch",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.117Z",
 *           "updatedAt": "2023-01-25T08:36:26.117Z"
 *       }
 *   ]
 *}
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var policies;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return db.Policy.find();
        case 3:
          policies = _context.sent;
          res.status(201).send({
            success: true,
            policies: policies
          });
          _context.next = 11;
          break;
        case 7:
          _context.prev = 7;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 7]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('IAM', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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