"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _strategy = require("../../middlewares/strategy");
/**
 * @api {get} /api/v1/profile/details details
 * @apiName details
 * @apiGroup Profile
 * @apiDescription Details of the user 
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} success              true
 * @apiSuccess {Object}  user[security]       object of security configurations of the user
 * @apiSuccess {id}      _id                  id of the user
 * @apiSuccess {String}  name                 name of the user
 * @apiSuccess {Object}  company              details of the company of user
 * @apiSuccess {String}  url                  url of the logo
 * @apiSuccess {String}  isTsat               url of TSAT
 * @apiSuccess {String}  isTsat               status of sending the mail to tsat
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success": true,
 *          "user": {
 *              "security": {
 *                  "status": false,
 *                  "otpType": "MAIL",
 *                  "otp": null,
 *                  "tOtpKey": null,
 *                  "otpExpiry": null
 *              },
 *              "_id": "63d0ea61032f943fc31e4e82",
 *              "name": "sarvesh patel",
 *              "email": "sarvesh.patel@kratikal.com"
 *          },
 *          "company": {
 *              "_id": "63d0ea61032f943fc31e4e80",
 *              "name": "Kratikal Tech Pvt Limited",
 *              "logo": null,
 *              "socEmail": "sarvesh.patel@kratikal.com"
 *          },
 *          "url": "https://new-stag.threatalertbutton.com/static/logo/"
 *          "tsatUrl": "https://tsat.threatcop.com"
 *          "isTsat": false
 *      }   
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var userId, companyId, user, smtp, company, tsatUrl, isTsat, userLimitMessenger, isSmtp, timeZone;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          userId = req.user._id;
          companyId = req.user.companyId;
          user = null;
          smtp = {
            status: false,
            host: null,
            port: null,
            password: null,
            username: null
          };
          if (!(req.user.type == 'root')) {
            _context.next = 11;
            break;
          }
          _context.next = 8;
          return db.Admin.findOne({
            _id: userId
          }, 'firstName lastName email security');
        case 8:
          user = _context.sent;
          _context.next = 14;
          break;
        case 11:
          _context.next = 13;
          return db.Employee.findOne({
            _id: userId
          }, 'firstName lastName email security');
        case 13:
          user = _context.sent;
        case 14:
          _context.next = 16;
          return db.Company.findById(companyId, 'name logo socEmail licenceKey broadcastThreshold reportingMethod');
        case 16:
          company = _context.sent;
          _context.next = 19;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'tsatUrl'
          });
        case 19:
          tsatUrl = _context.sent;
          _context.next = 22;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isTsat'
          });
        case 22:
          isTsat = _context.sent;
          if (tsatUrl) {
            _context.next = 30;
            break;
          }
          _context.next = 26;
          return db.MetaData.create({
            companyId: companyId,
            name: 'tsatUrl',
            value: 'https://tsat.threatcop.com'
          });
        case 26:
          tsatUrl = _context.sent;
          _context.next = 29;
          return db.MetaData.create({
            companyId: companyId,
            name: 'isTsat',
            value: "false"
          });
        case 29:
          isTsat = _context.sent;
        case 30:
          _context.next = 32;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimitMessenger'
          });
        case 32:
          userLimitMessenger = _context.sent;
          if (userLimitMessenger) {
            _context.next = 37;
            break;
          }
          _context.next = 36;
          return db.MetaData.create({
            companyId: companyId,
            name: 'userLimitMessenger',
            value: '0'
          });
        case 36:
          userLimitMessenger = _context.sent;
        case 37:
          _context.next = 39;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'mailSmtp'
          });
        case 39:
          isSmtp = _context.sent;
          if (isSmtp) {
            _context.next = 46;
            break;
          }
          smtp.status = false;
          _context.next = 44;
          return db.MetaData.findOneAndUpdate({
            name: "mailSmtp",
            companyId: companyId
          }, {
            value: false
          }, {
            upsert: true,
            "new": true,
            setDefaultsOnInsert: true
          });
        case 44:
          _context.next = 63;
          break;
        case 46:
          if (!(isSmtp.value == 'false')) {
            _context.next = 50;
            break;
          }
          smtp.status = false;
          _context.next = 63;
          break;
        case 50:
          smtp.status = isSmtp.value;
          _context.next = 53;
          return db.MetaData.findOne({
            name: "smtpHost",
            companyId: companyId
          });
        case 53:
          smtp.host = _context.sent.value;
          _context.next = 56;
          return db.MetaData.findOne({
            name: "smtpPort",
            companyId: companyId
          });
        case 56:
          smtp.port = _context.sent.value;
          _context.next = 59;
          return db.MetaData.findOne({
            name: "smtpUsername",
            companyId: companyId
          });
        case 59:
          smtp.username = _context.sent.value;
          _context.next = 62;
          return db.MetaData.findOne({
            name: "smtpFrom",
            companyId: companyId
          });
        case 62:
          smtp.from = _context.sent.value;
        case 63:
          _context.next = 65;
          return db.MetaData.findOne({
            name: "timeZone",
            companyId: companyId
          });
        case 65:
          timeZone = _context.sent;
          if (!timeZone) timeZone = 'Asia/Kolkata';else timeZone = timeZone.value;
          return _context.abrupt("return", res.status(200).send({
            success: true,
            user: {
              firstName: user.firstName,
              lastName: user.lastName,
              email: user.email,
              is2fa: user.security.status,
              otpType: user.security.otpType
            },
            company: company,
            url: "".concat(_config["default"].app.url, "/api/static/logo/"),
            tsatUrl: tsatUrl.value,
            isTsat: isTsat.value,
            timeZone: timeZone,
            smtp: smtp
          }));
        case 70:
          _context.prev = 70;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 74:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 70]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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