"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _path = _interopRequireDefault(require("path"));
var _multer = _interopRequireDefault(require("multer"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _scanAndUploadFile = require("../../middlewares/scanAndUploadFile");
var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));
var _config = _interopRequireDefault(require("../../config"));
var profilePicturePath = _path["default"].join(_path["default"].dirname(require.main.filename), 'public', 'logo');
var storage = _multer["default"].diskStorage({
  destination: function destination(req, file, cb) {
    cb(null, profilePicturePath);
  },
  filename: function filename(req, file, cb) {
    cb(null, req.user.companyId + _path["default"].extname(file.originalname));
  }
});
var uploadAttachment = (0, _multer["default"])({
  storage: storage,
  limits: {
    fileSize: 10485760
  }
});
var validator = _joi["default"].object().keys({
  firstName: _joi["default"].string().required(),
  lastName: _joi["default"].string().required(),
  companyName: _joi["default"].string().required(),
  logo: _joi["default"].string().optional().allow(null).empty('')
});

/**
 * @api {post} /api/v1/profile/update-profile update-profile
 * @apiName update-profile
 * @apiGroup Profile
 * @apiDescription Update profile details of the user 
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody    {String}  name          Name of the user
 * @apiBody    {String}  companyName   Company name of the user
 * @apiBody    {String}  [logo]        Logo of the user
 *
 * @apiSuccess {String}   success      true
 * @apiSuccess {String}   message      Details updated successfully
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success": true,
 *          "user":    "Details updated successfully"
 *      } 
 * 
 *  @apiError (400)  {Boolean} success    false
 *  @apiError (400)  {Array}   messages   "Only PNG or JPG files are accepted
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *              "Only PNG or JPG files are accepted"
 *           ]
 *       }  
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$file, _req$body, firstName, lastName, companyName, image, company, data, updatedCompany;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, firstName = _req$body.firstName, lastName = _req$body.lastName, companyName = _req$body.companyName;
          firstName = (0, _sanitizeHtml["default"])(firstName, {
            allowedTags: [],
            allowedAttributes: {}
          });
          lastName = (0, _sanitizeHtml["default"])(lastName, {
            allowedTags: [],
            allowedAttributes: {}
          });
          companyName = (0, _sanitizeHtml["default"])(companyName, {
            allowedTags: [],
            allowedAttributes: {}
          });
          image = req.file ? req.file.filename : null;
          if (!(req.file && req.file.mimetype != 'image/png' && req.file.mimetype != 'image/jpeg' && req.file.mimetype != 'image/jpg' || (req === null || req === void 0 ? void 0 : (_req$file = req.file) === null || _req$file === void 0 ? void 0 : _req$file.size) >= 5000000)) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Only PNG or JPG files are accepted with size less than 5mb!', 406);
        case 8:
          _context.next = 10;
          return db.Company.findById(req.user.companyId);
        case 10:
          company = _context.sent;
          if (company) {
            _context.next = 13;
            break;
          }
          throw new RequestError('Company not found!', 404);
        case 13:
          if (!(req.user.type == 'root')) {
            _context.next = 18;
            break;
          }
          _context.next = 16;
          return db.Admin.findOneAndUpdate({
            _id: req.user._id
          }, {
            firstName: firstName,
            lastName: lastName
          });
        case 16:
          _context.next = 20;
          break;
        case 18:
          _context.next = 20;
          return db.Employee.findOneAndUpdate({
            _id: req.user._id
          }, {
            firstName: firstName,
            lastName: lastName
          });
        case 20:
          data = {
            name: companyName
          };
          if (image) data['logo'] = image;
          _context.next = 24;
          return db.Company.findOneAndUpdate({
            _id: req.user.companyId
          }, {
            $set: data
          }, {
            "new": true
          });
        case 24:
          updatedCompany = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'Details updated successfully',
            dataUrl: "".concat(_config["default"].app.url, "/api/static/logo/").concat(updatedCompany.logo)
          }));
        case 28:
          _context.prev = 28;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 28]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), uploadAttachment.single('logo'), _scanAndUploadFile.scanFile, (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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