"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _spamc = _interopRequireDefault(require("spamc"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _parseHeader = _interopRequireDefault(require("../../service/parse-header"));
var _validator = require("../../middlewares/validator");
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
var validator = _joi["default"].object().keys({
  mailBody: _joi["default"].string().required(),
  threadId: _joi["default"].string().required(),
  messageId: _joi["default"].string().required(),
  email: _joi["default"].string().email().required()
});

/**
 * @api {post} /api/report/check-email check-email
 * @apiName Check Email
 * @apiGroup Report
 * @apiDescription check the email of the user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} mailBody               Required mail data.
 *
 * @apiSuccess {Boolean} success             true
 * @apiSuccess {String}  headerDetails       header details of the message.
 * @apiSuccess {String}  result              spam result of the message.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success":          true,
 *          "result":           "Details updated successfully",
 *          "headerDetails"     []
 *      } 
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, mailBody, messageId, threadId, email, headerDetails;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, mailBody = _req$body.mailBody, messageId = _req$body.messageId, threadId = _req$body.threadId, email = _req$body.email;
          console.time("process-header-".concat(messageId));
          _context.next = 5;
          return _parseHeader["default"].processHeader(mailBody);
        case 5:
          headerDetails = _context.sent;
          if (!(Object.keys(headerDetails).length == 0)) {
            _context.next = 9;
            break;
          }
          console.timeEnd("process-header-".concat(messageId));
          throw new RequestError('Error parsing header details', 500);
        case 9:
          console.timeEnd("process-header-".concat(messageId));
          console.time("spamassession-".concat(messageId));
          new Promise(function (resolve, reject) {
            spamc.report(mailBody, function (err, result) {
              if (err) reject(err);else resolve(result);
            });
          }).then(function (result) {
            console.timeEnd("spamassession-".concat(messageId));
            _kue.queue.create('check-email-spam-or-not-event-gsuite', {
              email: email,
              mailBody: mailBody,
              threadId: threadId,
              messageId: messageId,
              headerDetails: headerDetails,
              mailType: 'Gsuite',
              score: result && result.spamScore ? result.spamScore : 0
            }).save().removeOnComplete(true).priority('high');
            result.spamScore = result !== null && result !== void 0 && result.spamScore ? result.spamScore : 0;
            res.status(200).json({
              success: true,
              result: result,
              headerDetails: headerDetails
            });
          })["catch"](function (err) {
            console.log(err);
            next(err);
          });
          _context.next = 18;
          break;
        case 14:
          _context.prev = 14;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 14]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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