"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _spamc = _interopRequireDefault(require("spamc"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _parseHeader = _interopRequireDefault(require("../../service/parse-header"));
var _getMailData = _interopRequireDefault(require("../../service/get-mail-data"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);

// const validator = Joi.object().keys({
//     internetMessageId: Joi.string().required(),
//     email: Joi.string().email().required(),
//     emailType: Joi.string().optional(),
// });

/**
 * @api {post} /api/report/check-email check-email
 * @apiName Check Email
 * @apiGroup Report
 * @apiDescription check the email of the user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} messageId               Required message id of the mail.
 * @apiBody {String} accessToken             Required access token of the mailbox.
 *
 * @apiSuccess {Boolean} success             true
 * @apiSuccess {String}  headerDetails       header details of the message.
 * @apiSuccess {String}  result              spam result of the message.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success":          true,
 *          "result":           "Details updated successfully",
 *          "headerDetails"     []
 *      } 
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, accessToken, messageId, email, internetMessageId, emailType, reporters, action, result, userFound, mailFound, spamScore, isSameReporter, reportedMail, condition, user, userEmailCriteria, combinedCriteria, totalMails, deletedCriteria, trashedCriteria, recoveredCriteria, pendingCriteria, deletedMails, trashedMails, recoveredMails, pendingMails, userStats;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, accessToken = _req$body.accessToken, messageId = _req$body.messageId, email = _req$body.email, internetMessageId = _req$body.internetMessageId, emailType = _req$body.emailType;
          email = email.toLowerCase();
          reporters = 0;
          action = '';
          result = 'Awaited';
          userFound = false;
          mailFound = false;
          spamScore = 0;
          isSameReporter = false;
          _context.next = 12;
          return db.ReportedMail.findOne({
            internetMessageId: internetMessageId
          });
        case 12:
          reportedMail = _context.sent;
          if (reportedMail) {
            mailFound = true;
            reporters = reportedMail.reporters ? reportedMail.reporters.length + 1 : 0;
            spamScore = reportedMail.spamScore;
            if (reportedMail.to == email.toLowerCase()) isSameReporter = true;else if (reportedMail.reporters && reportedMail.reporters.length) reportedMail.reporters.some(function (reporter) {
              return reporter.email.toLowerCase() == email.toLowerCase();
            }) ? isSameReporter = true : '';
            if (reportedMail.isRecoveredEmail == 'true') {
              result = "Recovered", action = "Decision Taken";
            }
            if (reportedMail.isTrashedEmail == 'true') {
              result = "Trashed", action = "Decision Taken";
            }
            if (reportedMail.isDeletedEmail == 'true') {
              result = "Deleted", action = "Decision Taken";
            }
            if (isSameReporter && reportedMail.isTrashedEmail == 'false' && reportedMail.isDeletedEmail == 'false' && reportedMail.isRecoveredEmail == 'false') {
              result = "Awaited", action = "Decision Pending";
            }
          }
          condition = {
            email: email,
            deletedAt: null
          };
          if (emailType) {
            condition['emailType'] = emailType;
          }
          _context.next = 18;
          return db.User.findOne(condition);
        case 18:
          user = _context.sent;
          console.log('user issss', user);
          if (!user) {
            _context.next = 45;
            break;
          }
          userFound = true;

          // Criteria: User is in the "to" field or listed as a reporter
          userEmailCriteria = {
            $or: [{
              to: email
            }, {
              reporters: {
                $elemMatch: {
                  email: email
                }
              }
            }]
          }; // const domainCriteria = { domainId: user.domainId, deletedAt: null };
          // Combining the criteria
          combinedCriteria = {
            $and: [userEmailCriteria],
            companyId: user.companyId
          };
          _context.next = 26;
          return db.ReportedMail.countDocuments(combinedCriteria);
        case 26:
          totalMails = _context.sent;
          // Criteria for deleted, trashed, recovered, and pending mails
          deletedCriteria = _objectSpread(_objectSpread({}, combinedCriteria), {}, {
            isDeletedEmail: "true",
            companyId: user.companyId
          });
          trashedCriteria = _objectSpread(_objectSpread({}, combinedCriteria), {}, {
            isTrashedEmail: "true",
            companyId: user.companyId
          });
          recoveredCriteria = _objectSpread(_objectSpread({}, combinedCriteria), {}, {
            isRecoveredEmail: "true",
            companyId: user.companyId
          });
          pendingCriteria = _objectSpread(_objectSpread({}, combinedCriteria), {}, {
            isDeletedEmail: "false",
            isTrashedEmail: "false",
            isRecoveredEmail: "false",
            companyId: user.companyId
          });
          _context.next = 33;
          return db.ReportedMail.countDocuments(deletedCriteria);
        case 33:
          deletedMails = _context.sent;
          _context.next = 36;
          return db.ReportedMail.countDocuments(trashedCriteria);
        case 36:
          trashedMails = _context.sent;
          _context.next = 39;
          return db.ReportedMail.countDocuments(recoveredCriteria);
        case 39:
          recoveredMails = _context.sent;
          _context.next = 42;
          return db.ReportedMail.countDocuments(pendingCriteria);
        case 42:
          pendingMails = _context.sent;
          userStats = {
            totalMails: totalMails,
            deletedMails: deletedMails,
            trashedMails: trashedMails,
            recoveredMails: recoveredMails,
            pendingMails: pendingMails
          };
          console.log('User stats:', userStats);
        case 45:
          return _context.abrupt("return", res.status(200).send({
            userStats: userStats,
            reporters: reporters,
            result: result,
            action: action,
            userFound: userFound,
            mailFound: mailFound,
            spamScore: spamScore,
            isSameReporter: isSameReporter
          }));
        case 48:
          _context.prev = 48;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 52:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 48]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(
// validateBody(validator), 
controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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