"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _spamc = _interopRequireDefault(require("spamc"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _parseHeader = _interopRequireDefault(require("../../service/parse-header"));
var _getMailData = _interopRequireDefault(require("../../service/get-mail-data"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
var validator = _joi["default"].object().keys({
  messageId: _joi["default"].string().required(),
  accessToken: _joi["default"].string().required(),
  email: _joi["default"].string().email().required()
});

/**
 * @api {post} /api/report/check-email check-email
 * @apiName Check Email
 * @apiGroup Report
 * @apiDescription check the email of the user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} messageId               Required message id of the mail.
 * @apiBody {String} accessToken             Required access token of the mailbox.
 *
 * @apiSuccess {Boolean} success             true
 * @apiSuccess {String}  headerDetails       header details of the message.
 * @apiSuccess {String}  result              spam result of the message.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success":          true,
 *          "result":           "Details updated successfully",
 *          "headerDetails"     []
 *      } 
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, accessToken, messageId, email, header, headerDetails;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, accessToken = _req$body.accessToken, messageId = _req$body.messageId, email = _req$body.email;
          console.time('process mail data');
          _context.next = 5;
          return _getMailData["default"].processHeader(messageId, accessToken);
        case 5:
          header = _context.sent;
          console.timeEnd('process mail data');
          console.time('process header');
          _context.next = 10;
          return _parseHeader["default"].processHeader(header);
        case 10:
          headerDetails = _context.sent;
          console.timeEnd('process header');
          console.time('spamassession');
          new Promise(function (resolve, reject) {
            spamc.headers(header, function (err, result) {
              if (err) reject(err);else resolve(result);
            });
          }).then(function (result) {
            console.timeEnd('spamassession');
            _kue.queue.create('check-email-spam-or-not-event-outlook', {
              email: email,
              header: header,
              messageId: messageId,
              headerDetails: headerDetails,
              mailType: 'Outlook',
              score: result && result.spamScore ? result.spamScore : 0
            }).save().removeOnComplete(true).priority('high');
            res.status(200).json({
              success: true,
              result: result,
              headerDetails: headerDetails
            });
          })["catch"](function (err) {
            console.log(err);
            next(err);
          });
          _context.next = 20;
          break;
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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