"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
// const validator = Joi.object().keys({
//   email: Joi.string().email().required(),
//   name: Joi.string().optional().allow(null),
//   type: Joi.any().valid('Outlook', 'Gsuite', 'Exchange').required(),
// });

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, type, name, domainFromEmail, match, domain, subDomain, company, companyRemainingTime, activeGroupsOfCompanyWithEmailAccess, user, companyId, isLicence, isLite;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, type = _req$body.type, name = _req$body.name;
          email = email.toLowerCase();
          domainFromEmail = '';
          match = email.split('@')[1];
          console.log(match);
          if (!match) {
            _context.next = 10;
            break;
          }
          domainFromEmail = match;
          _context.next = 12;
          break;
        case 10:
          console.log("No match found");
          throw new RequestError('Email Not Found!');
        case 12:
          console.log(domainFromEmail);
          _context.next = 15;
          return db.Domain.findOne({
            domainName: domainFromEmail,
            deletedAt: null
          });
        case 15:
          domain = _context.sent;
          console.log({
            domain: domain
          });
          if (domain) {
            _context.next = 21;
            break;
          }
          _context.next = 20;
          return db.SubDomainGroup.findOne({
            groupName: domainFromEmail,
            deletedAt: null
          });
        case 20:
          subDomain = _context.sent;
        case 21:
          console.log({
            subDomain: subDomain
          });
          if (!(!domain && !subDomain)) {
            _context.next = 24;
            break;
          }
          throw new RequestError('Domain does not exist', 404);
        case 24:
          if (!domain) {
            _context.next = 30;
            break;
          }
          _context.next = 27;
          return db.Company.findOne({
            _id: domain.companyId
          });
        case 27:
          _context.t0 = _context.sent;
          _context.next = 38;
          break;
        case 30:
          if (!subDomain) {
            _context.next = 36;
            break;
          }
          _context.next = 33;
          return db.Company.findOne({
            _id: subDomain.companyId
          });
        case 33:
          _context.t1 = _context.sent;
          _context.next = 37;
          break;
        case 36:
          _context.t1 = null;
        case 37:
          _context.t0 = _context.t1;
        case 38:
          company = _context.t0;
          console.log({
            company: company
          });
          if (company) {
            _context.next = 42;
            break;
          }
          throw new RequestError('company does not exists', 404);
        case 42:
          _context.next = 44;
          return db.MetaData.findOne({
            name: 'expiredAt',
            companyId: company._id
          });
        case 44:
          companyRemainingTime = _context.sent;
          if (!(new Date() > new Date(companyRemainingTime.value))) {
            _context.next = 47;
            break;
          }
          throw new RequestError('License expired', 404);
        case 47:
          _context.next = 49;
          return db.Group.find({
            companyId: company._id,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 49:
          activeGroupsOfCompanyWithEmailAccess = _context.sent;
          activeGroupsOfCompanyWithEmailAccess = activeGroupsOfCompanyWithEmailAccess.map(function (group) {
            return group._id;
          });
          _context.next = 53;
          return db.User.findOne({
            email: email,
            emailType: type,
            isActive: true,
            companyId: company._id,
            groups: {
              $in: activeGroupsOfCompanyWithEmailAccess
            },
            // Ensuring at least one active group
            deletedAt: null
          });
        case 53:
          user = _context.sent;
          if (user) {
            _context.next = 56;
            break;
          }
          throw new RequestError('user not exists', 404);
        case 56:
          companyId = user.companyId;
          if (domain) {
            _context.next = 64;
            break;
          }
          _context.next = 60;
          return db.Domain.findOne({
            _id: subDomain.domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 60:
          _context.t2 = _context.sent;
          isLicence = _context.t2 !== null;
          _context.next = 68;
          break;
        case 64:
          _context.next = 66;
          return db.Domain.findOne({
            domainName: domainFromEmail,
            companyId: companyId,
            deletedAt: null
          });
        case 66:
          _context.t3 = _context.sent;
          isLicence = _context.t3 !== null;
        case 68:
          _context.next = 70;
          return db.CompanyFeature.findOne({
            companyId: companyId,
            featureCode: 'TPIR-VRE',
            deletedAt: null
          });
        case 70:
          isLite = _context.sent;
          if (!isLite) isLite = true;else isLite = false;
          if (!subDomain) {
            _context.next = 78;
            break;
          }
          _context.next = 75;
          return db.Domain.findOne({
            _id: subDomain.domainId,
            deletedAt: null
          });
        case 75:
          domain = _context.sent;
          if (domain) {
            _context.next = 78;
            break;
          }
          throw new RequestError('Domain does not exist', 404);
        case 78:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            isLicence: isLicence,
            isLite: isLite,
            creds: domain.isCredential
          }));
        case 81:
          _context.prev = 81;
          _context.t4 = _context["catch"](0);
          console.log(_context.t4);
          next(_context.t4);
        case 85:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 81]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(),
//  validateBody(validator), 
controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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