"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _parseEmail = _interopRequireDefault(require("../../service/parse-email"));
var _spamc = _interopRequireDefault(require("spamc"));
var _validator = require("../../middlewares/validator");
var _mailer = _interopRequireDefault(require("../../mailer"));
var _config = _interopRequireDefault(require("../../config"));
var _getUrls = _interopRequireDefault(require("get-urls"));
var _decodeUriComponent = _interopRequireDefault(require("decode-uri-component"));
var _allowedFeatures = _interopRequireDefault(require("../../service/allowed-features"));
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
var validator = _joi["default"].object().keys({
  mailBody: _joi["default"].string().required(),
  threadId: _joi["default"].string().required(),
  messageId: _joi["default"].string().required(),
  email: _joi["default"].string().email().required(),
  internetMessageId: _joi["default"].string().required()
});
var checkUrlsForRid = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(urls) {
    var urlContainsRid, urlsArray, i, url, decodedUrl;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          urlContainsRid = false;
          urlsArray = Array.from(urls);
          i = 0;
        case 4:
          if (!(i < urlsArray.length)) {
            _context.next = 13;
            break;
          }
          url = urlsArray[i];
          decodedUrl = decodeURIComponent(url);
          if (!(decodedUrl.indexOf('rid=') > -1)) {
            _context.next = 10;
            break;
          }
          urlContainsRid = decodedUrl;
          return _context.abrupt("break", 13);
        case 10:
          i++;
          _context.next = 4;
          break;
        case 13:
          return _context.abrupt("return", urlContainsRid);
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", false);
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function checkUrlsForRid(_x) {
    return _ref.apply(this, arguments);
  };
}();

// const spamc = new Spamc(config.spamassession.host, config.spamassession.port, 10000);

/**
 * @api {post} /api/report/report-email report-email
 * @apiName Report Mail
 * @apiGroup Report
 * @apiDescription Report a mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} accessToken       Required accessToken of the mail.
 * @apiBody {String} messageId         Required messageId of the mail.
 * @apiBody {String} email             Required email of the mail.
 *
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String} message    'email reported successfully'
 * 
  * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success":  true,
 *          "message":  'email reported successfully'        
 *      } 
 * 
 * @apiError {Boolean}    success     false
 * @apiError {Boolean}    messages    ["user not exists"]
 * 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "user not exists"
 *           ]
 *       }
 */

var moveToTrash = function moveToTrash(companyId, email, domainId, internetMessageId) {
  return new Promise( /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(resolve, reject) {
      var isWhoElse;
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return db.WhoElse.findOne({
              internetMessageId: internetMessageId,
              to: email,
              companyId: companyId,
              domainId: domainId
            });
          case 2:
            isWhoElse = _context2.sent;
            if (!isWhoElse) {
              _context2.next = 10;
              break;
            }
            isWhoElse.isTrashed = true;
            _context2.next = 7;
            return isWhoElse.save();
          case 7:
            resolve(true);
            _context2.next = 11;
            break;
          case 10:
            resolve(false);
          case 11:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function (_x2, _x3) {
      return _ref2.apply(this, arguments);
    };
  }());
};
var controller = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(req, res, next) {
    var _req$body, mailBody, email, messageId, threadId, internetMessageId, user, companyRemainingTime, userId, domainId, companyId, domain, isReported, moveTrash, _parsedEML$attachment, parsedEML, body, header, plainHeader, attachments, tsatUrl, isTsat, isTsatMail, urlsInbody, isRidInBody;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          _req$body = req.body, mailBody = _req$body.mailBody, email = _req$body.email, messageId = _req$body.messageId, threadId = _req$body.threadId, internetMessageId = _req$body.internetMessageId;
          console.time("find-user-".concat(messageId));
          _context4.next = 5;
          return db.User.findOne({
            email: email.toLowerCase(),
            isActive: true,
            emailType: "Gsuite",
            deletedAt: null
          });
        case 5:
          user = _context4.sent;
          console.timeEnd("find-user-".concat(messageId));
          if (user) {
            _context4.next = 9;
            break;
          }
          throw new RequestError('user not exists', 404);
        case 9:
          _context4.next = 11;
          return db.MetaData.findOne({
            name: 'expiredAt',
            companyId: user.companyId
          });
        case 11:
          companyRemainingTime = _context4.sent;
          if (!(new Date() > new Date(companyRemainingTime.value))) {
            _context4.next = 14;
            break;
          }
          throw new RequestError('License expired', 404);
        case 14:
          userId = user._id;
          domainId = user.domainId;
          companyId = user.companyId;
          domain = db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
          if (domain) {
            _context4.next = 20;
            break;
          }
          throw new RequestError('domain not exists', 404);
        case 20:
          _context4.next = 22;
          return db.ReportedMail.findOne({
            internetMessageId: internetMessageId
          });
        case 22:
          isReported = _context4.sent;
          if (!isReported) {
            _context4.next = 42;
            break;
          }
          if (!(isReported.isRecoveredEmail === 'false')) {
            _context4.next = 39;
            break;
          }
          _context4.next = 27;
          return moveToTrash(companyId, email, domainId, internetMessageId);
        case 27:
          moveTrash = _context4.sent;
          if (!moveTrash) console.log('Email Not Found in Who-Else for the reported mail!');
          _context4.next = 31;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 31:
          if (!_context4.sent) {
            _context4.next = 33;
            break;
          }
          _mailer["default"].sendAlreadyReportedMail(user.name, email, companyId);
        case 33:
          isReported.reporters.push({
            email: email
          });
          _context4.next = 36;
          return isReported.save();
        case 36:
          res.status(200).json({
            success: true,
            message: 'email reported successfully',
            reporters: isReported.reporters ? isReported.reporters.length + 1 : 0,
            spamScore: isReported.spamScore
          });
          _context4.next = 40;
          break;
        case 39:
          return _context4.abrupt("return", res.status(200).json({
            success: true,
            message: 'Email already reported by someone and has been found safe!',
            moveToJunk: false
          }));
        case 40:
          _context4.next = 80;
          break;
        case 42:
          console.time("process-mail-body-".concat(messageId));
          _context4.next = 45;
          return _parseEmail["default"].parseEml(mailBody);
        case 45:
          parsedEML = _context4.sent;
          body = parsedEML.html;
          header = parsedEML;
          plainHeader = mailBody.split('Content-Type: text/plain;')[0];
          attachments = (_parsedEML$attachment = parsedEML === null || parsedEML === void 0 ? void 0 : parsedEML.attachments) !== null && _parsedEML$attachment !== void 0 ? _parsedEML$attachment : [];
          console.timeEnd("process-mail-body-".concat(messageId));
          _context4.next = 53;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'tsatUrl'
          });
        case 53:
          tsatUrl = _context4.sent;
          _context4.next = 56;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isTsat'
          });
        case 56:
          isTsat = _context4.sent;
          isTsatMail = isTsat.value === 'true';
          _context4.next = 60;
          return (0, _getUrls["default"])(body);
        case 60:
          urlsInbody = _context4.sent;
          isRidInBody = false;
          if (!(urlsInbody.size > 0)) {
            _context4.next = 66;
            break;
          }
          _context4.next = 65;
          return checkUrlsForRid(urlsInbody);
        case 65:
          isRidInBody = _context4.sent;
        case 66:
          _context4.next = 68;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-TSAT");
        case 68:
          _context4.t2 = _context4.sent;
          if (!_context4.t2) {
            _context4.next = 71;
            break;
          }
          _context4.t2 = isRidInBody != false;
        case 71:
          _context4.t1 = _context4.t2;
          if (!_context4.t1) {
            _context4.next = 74;
            break;
          }
          _context4.t1 = isTsatMail;
        case 74:
          _context4.t0 = _context4.t1;
          if (!_context4.t0) {
            _context4.next = 77;
            break;
          }
          _context4.t0 = tsatUrl.value;
        case 77:
          if (!_context4.t0) {
            _context4.next = 79;
            break;
          }
          // call to tsat for email reporting
          _kue.queue.create('route-email-tsat', {
            header: header,
            body: (0, _decodeUriComponent["default"])("".concat(body)),
            tsatUrl: tsatUrl
          }).removeOnComplete(true).priority('high').save();
        case 79:
          new Promise( /*#__PURE__*/function () {
            var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(resolve, reject) {
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    console.time('spamassession' + messageId);
                    _context3.next = 3;
                    return (0, _allowedFeatures["default"])(companyId, "TPIR-SSRE");
                  case 3:
                    if (!_context3.sent) {
                      _context3.next = 7;
                      break;
                    }
                    spamc.headers(plainHeader, function (err, result) {
                      if (err) reject(err);else resolve(result);
                    });
                    _context3.next = 8;
                    break;
                  case 7:
                    resolve(0);
                  case 8:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            return function (_x7, _x8) {
              return _ref4.apply(this, arguments);
            };
          }()).then(function (result) {
            console.log("SpamScore---->", result);
            console.timeEnd('spamassession' + messageId);
            _kue.queue.create('reported-email-gsuite', {
              email: email,
              header: header,
              plainHeader: plainHeader,
              body: body,
              userId: userId,
              userName: user ? user.name ? user.name : '' : '',
              threadId: threadId,
              companyId: companyId,
              messageId: messageId,
              internetMessageId: internetMessageId,
              attachments: attachments,
              domainId: domainId,
              spamScore: result && result.spamScore ? result.spamScore : 0,
              isCheckHeader: true,
              isTsatMail: isRidInBody != false,
              mailBody: mailBody
            }).removeOnComplete(true).priority('high').save();
            res.status(200).json({
              success: true,
              message: 'email reported successfully',
              reporters: 1,
              moveToJunk: true,
              spamScore: result && result.spamScore ? result.spamScore : 0
            });
          });
        case 80:
          _context4.next = 86;
          break;
        case 82:
          _context4.prev = 82;
          _context4.t3 = _context4["catch"](0);
          console.log('From Report-email-gsuite', _context4.t3);
          next(_context4.t3);
        case 86:
        case "end":
          return _context4.stop();
      }
    }, _callee4, null, [[0, 82]]);
  }));
  return function controller(_x4, _x5, _x6) {
    return _ref3.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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