"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _getMailData = _interopRequireDefault(require("../../service/get-mail-data"));
var _spamc = _interopRequireDefault(require("spamc"));
var _config = _interopRequireDefault(require("../../config"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _parseHeader = _interopRequireDefault(require("../../service/parse-header"));
var _parseEmail = _interopRequireDefault(require("../../service/parse-email"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _allowedFeatures = _interopRequireDefault(require("../../service/allowed-features"));
var _getIp = _interopRequireDefault(require("../../service/get-ip"));
// let validator = Joi.object().keys({
//     header: Joi.string().required(),
//     body: Joi.string().required(),
//     email: Joi.string().email().required(),
//     internetMessageId: Joi.string().required(),
// });

var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
/**
 * @api {post} /api/report/report-email report-email
 * @apiName Report Mail
 * @apiGroup Report
 * @apiDescription Report a mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} accessToken       Required accessToken of the mail.
 * @apiBody {String} messageId         Required messageId of the mail.
 * @apiBody {String} email             Required email of the mail.
 *
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String} message    'email reported successfully'
 * 
  * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success":  true,
 *          "message":  'email reported successfully'        
 *      } 
 * 
 * @apiError {Boolean}    success     false
 * @apiError {Boolean}    messages    ["user not exists"]
 * 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "user not exists"
 *           ]
 *       }
 */

var getParseHeader = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(header) {
    var status,
      investigate,
      parseEml,
      from,
      spfDomain,
      parsedDomain,
      fromDomain,
      dkimSiganture,
      search,
      filteredDkimSiganture,
      authResults,
      dkimDomain,
      _yield$getIp$processI,
      country,
      continent,
      _args = arguments;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          status = _args.length > 1 && _args[1] !== undefined ? _args[1] : true;
          _context.prev = 1;
          investigate = {};
          parseEml = header;
          if (!status) {
            _context.next = 8;
            break;
          }
          _context.next = 7;
          return _parseEmail["default"].parseHeader(header);
        case 7:
          parseEml = _context.sent;
        case 8:
          if (!parseEml) {
            _context.next = 44;
            break;
          }
          from = parseEml && parseEml.from && parseEml.from[0].address ? parseEml.from[0].address : '';
          spfDomain = parseEml.headers['return-path'] ? Array.isArray(parseEml.headers['return-path']) ? parseEml.headers['return-path'][0].split("@")[1] : parseEml.headers['return-path'].split("@")[1] : null;
          parsedDomain = from.split('@')[1];
          fromDomain = parsedDomain;
          investigate['spfAllignment'] = fromDomain == spfDomain;
          dkimSiganture = parseEml.headers['dkim-signature'];
          if (Array.isArray(dkimSiganture)) {
            search = "d=".concat(fromDomain);
            filteredDkimSiganture = dkimSiganture.filter(function (r) {
              return r.includes(search);
            });
            if (filteredDkimSiganture.length > 0) dkimSiganture = filteredDkimSiganture[0];else if (dkimSiganture > 0) dkimSiganture = dkimSiganture[0];else dkimSiganture = null;
          }
          authResults = parseEml.headers['authentication-results'];
          authResults = Array.isArray(authResults) && authResults.length > 0 ? authResults.filter(function (r) {
            return r.startsWith('amazonses.com');
          }).join(" ") : authResults;
          dkimDomain = dkimSiganture && dkimSiganture != null ? function () {
            var dIndex = dkimSiganture.search(/d=.*?;/);
            var dValue = dkimSiganture.slice(dIndex + 2, dkimSiganture.indexOf(";", dIndex + 2));
            return dValue;
          }() : null;
          if (!dkimDomain) {
            _context.next = 25;
            break;
          }
          _context.next = 22;
          return parseDomain(dkimDomain);
        case 22:
          _context.t0 = _context.sent;
          _context.next = 26;
          break;
        case 25:
          _context.t0 = null;
        case 26:
          parsedDomain = _context.t0;
          dkimDomain = parsedDomain ? "".concat(parsedDomain.domain) : dkimDomain;
          investigate['dkimAllignment'] = fromDomain == dkimDomain;
          _context.next = 31;
          return getipAddress(parseEml.headers['received']);
        case 31:
          investigate['senderIp'] = _context.sent;
          _context.next = 34;
          return _getIp["default"].processIp(investigate['senderIp']);
        case 34:
          _yield$getIp$processI = _context.sent;
          country = _yield$getIp$processI.country;
          continent = _yield$getIp$processI.continent;
          if (country && continent) {
            investigate['country'] = country;
            investigate['continent'] = continent;
          } else {
            investigate['country'] = 'NOT FOUND';
            investigate['continent'] = 'NOT FOUND';
          }
          investigate['spf'] = stringSearcher(authResults, 'spf=pass');
          investigate['dkim'] = stringSearcher(authResults, 'dkim=pass');
          investigate['dmarc'] = stringSearcher(authResults, ['dmarc=pass', 'dmarc=none']);
          return _context.abrupt("return", investigate);
        case 44:
          console.error('error from parsing header details');
          return _context.abrupt("return", {});
        case 46:
          _context.next = 52;
          break;
        case 48:
          _context.prev = 48;
          _context.t1 = _context["catch"](1);
          console.log(_context.t1);
          return _context.abrupt("return", {});
        case 52:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 48]]);
  }));
  return function getParseHeader(_x) {
    return _ref.apply(this, arguments);
  };
}();
var getipAddress = function getipAddress(receivedHeaders) {
  var ip = null;
  receivedHeaders.forEach(function (header) {
    var match = header.match(/\b(?:\d{1,3}\.){3}\d{1,3}\b/);
    if (match) {
      ip = match[0];
    }
  });
  return ip;
};
var stringSearcher = function stringSearcher(str, key) {
  var keyList = [];
  if (typeof key === 'string') keyList.push(key);else if (Array.isArray(key)) keyList = key;
  if (str && str.length > 0) {
    if (key.length == 0) return 'fail';
    var filteredList = keyList.filter(function (iKey) {
      return str.indexOf(iKey) != -1;
    });
    if (filteredList.length > 0) {
      return 'pass';
    } else return 'fail';
  } else {
    return 'fail';
  }
};
var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _req$body, messageId, email, internetMessageId, headers, body, from, subject, cc, _req$body$toName, toName, _req$body$bcc, bcc, mailRecievedTime, user, userId, domainId, companyId, domain, tsatUrl, isTsat, isReported, exchangeHeaders, i, _headers$i, _headers$i2, headerDetails, parseEml, otherTo, emailReported;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _req$body = req.body, messageId = _req$body.messageId, email = _req$body.email, internetMessageId = _req$body.internetMessageId, headers = _req$body.headers, body = _req$body.body, from = _req$body.from, subject = _req$body.subject, cc = _req$body.cc, _req$body$toName = _req$body.toName, toName = _req$body$toName === void 0 ? '' : _req$body$toName, _req$body$bcc = _req$body.bcc, bcc = _req$body$bcc === void 0 ? [] : _req$body$bcc, mailRecievedTime = _req$body.mailRecievedTime;
          _context2.next = 4;
          return db.User.findOne({
            email: email
          });
        case 4:
          user = _context2.sent;
          console.log({
            from: from
          });
          if (user) {
            _context2.next = 8;
            break;
          }
          throw new RequestError('user not exists', 404);
        case 8:
          userId = user._id;
          domainId = user.domainId;
          companyId = user.companyId;
          _context2.next = 13;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 13:
          domain = _context2.sent;
          if (domain) {
            _context2.next = 16;
            break;
          }
          throw new RequestError('domain not exists', 404);
        case 16:
          _context2.next = 18;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'tsatUrl'
          });
        case 18:
          tsatUrl = _context2.sent;
          _context2.next = 21;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isTsat'
          });
        case 21:
          isTsat = _context2.sent;
          _context2.next = 24;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-TSAT");
        case 24:
          _context2.t2 = _context2.sent;
          if (!_context2.t2) {
            _context2.next = 27;
            break;
          }
          _context2.t2 = body.indexOf('?rid=') !== -1;
        case 27:
          _context2.t1 = _context2.t2;
          if (!_context2.t1) {
            _context2.next = 30;
            break;
          }
          _context2.t1 = isTsat.value == 'true';
        case 30:
          _context2.t0 = _context2.t1;
          if (!_context2.t0) {
            _context2.next = 33;
            break;
          }
          _context2.t0 = tsatUrl.value;
        case 33:
          if (!_context2.t0) {
            _context2.next = 44;
            break;
          }
          // call to tsat for email reporting
          _kue.queue.create('route-email-tsat', {
            header: headers,
            body: body,
            tsatUrl: tsatUrl
          }).removeOnComplete(true).priority('high').save();
          _context2.next = 37;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 37:
          if (!_context2.sent) {
            _context2.next = 39;
            break;
          }
          _kue.queue.create('send-reported-mail', {
            to: email,
            userName: user ? user.name ? user.name : '' : '',
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 39:
          _context2.next = 41;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
        case 41:
          if (!_context2.sent) {
            _context2.next = 43;
            break;
          }
          _kue.queue.create('send-soc-mail', {
            to: email,
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            header: headers,
            body: body,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 43:
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            message: 'email reported successfully',
            reporters: 1,
            moveToJunk: true,
            spamScore: 0
          }));
        case 44:
          _context2.next = 46;
          return db.ReportedMail.findOne({
            internetMessageId: internetMessageId
          });
        case 46:
          isReported = _context2.sent;
          if (!isReported) {
            _context2.next = 57;
            break;
          }
          _context2.next = 50;
          return db.ReportedMail.updateOne({
            _id: isReported._id
          }, {
            $push: {
              reporters: {
                email: email
              }
            }
          });
        case 50:
          _context2.next = 52;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 52:
          if (!_context2.sent) {
            _context2.next = 54;
            break;
          }
          _mailer["default"].sendAlreadyReportedMail(user.name, email, companyId);
        case 54:
          res.status(200).json({
            success: true,
            reporters: isReported.reporters ? isReported.reporters.length + 2 : 0,
            spamScore: isReported.spamScore,
            moveToJunk: true,
            message: 'email reported successfully'
          });
          _context2.next = 84;
          break;
        case 57:
          if (domain.domainTypeForOutlook == 'EXCHANGE') {
            exchangeHeaders = '';
            for (i = 0; i < headers.length; i++) {
              exchangeHeaders = exchangeHeaders + ((_headers$i = headers[i]) === null || _headers$i === void 0 ? void 0 : _headers$i.name) + ' ' + ((_headers$i2 = headers[i]) === null || _headers$i2 === void 0 ? void 0 : _headers$i2.value) + '\n';
            }
            headers = exchangeHeaders;
          }
          headerDetails = {};
          _context2.next = 61;
          return _parseEmail["default"].parseEml(headers);
        case 61:
          parseEml = _context2.sent;
          if (!(domain.domainTypeForOutlook == "EXCHANGE")) {
            _context2.next = 68;
            break;
          }
          _context2.next = 65;
          return getParseHeader(headers);
        case 65:
          headerDetails = _context2.sent;
          _context2.next = 71;
          break;
        case 68:
          _context2.next = 70;
          return _parseHeader["default"].processHeader(parseEml, false);
        case 70:
          headerDetails = _context2.sent;
        case 71:
          otherTo = parseEml.to ? parseEml.to : [];
          _context2.next = 74;
          return db.ReportedMail.create({
            from: from.emailAddress,
            fromName: from.displayName,
            to: email,
            toName: user.name,
            subject: subject,
            mailId: messageId,
            cc: cc,
            bcc: bcc,
            otherTo: [],
            messageId: messageId,
            internetMessageId: internetMessageId,
            mailRecievedTime: mailRecievedTime,
            companyId: companyId,
            isLiteEnvReport: true,
            mailType: user.emailType,
            header: headers,
            body: body,
            userId: userId,
            headerDetails: headerDetails,
            domainId: domainId,
            parsedHeader: parseEml
          });
        case 74:
          emailReported = _context2.sent;
          _context2.next = 77;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 77:
          if (!_context2.sent) {
            _context2.next = 79;
            break;
          }
          _kue.queue.create('send-reported-mail', {
            to: email,
            userName: user ? user.name ? user.name : '' : '',
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 79:
          _context2.next = 81;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
        case 81:
          if (!_context2.sent) {
            _context2.next = 83;
            break;
          }
          _kue.queue.create('send-soc-mail', {
            to: email,
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            header: headers,
            body: body,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 83:
          res.status(200).json({
            success: true,
            message: 'email reported successfully',
            reporters: 1,
            moveToJunk: true,
            spamScore: 0
          });
        case 84:
          _context2.next = 90;
          break;
        case 86:
          _context2.prev = 86;
          _context2.t3 = _context2["catch"](0);
          console.log(_context2.t3);
          next(_context2.t3);
        case 90:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 86]]);
  }));
  return function controller(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJzcGFtYyIsIlNwYW1jIiwiY29uZmlnIiwic3BhbWFzc2Vzc2lvbiIsImhvc3QiLCJwb3J0IiwiZ2V0UGFyc2VIZWFkZXIiLCJoZWFkZXIiLCJzdGF0dXMiLCJpbnZlc3RpZ2F0ZSIsInBhcnNlRW1sIiwicGFyc2VFbWFpbCIsInBhcnNlSGVhZGVyIiwiZnJvbSIsImFkZHJlc3MiLCJzcGZEb21haW4iLCJoZWFkZXJzIiwiQXJyYXkiLCJpc0FycmF5Iiwic3BsaXQiLCJwYXJzZWREb21haW4iLCJmcm9tRG9tYWluIiwiZGtpbVNpZ2FudHVyZSIsInNlYXJjaCIsImZpbHRlcmVkRGtpbVNpZ2FudHVyZSIsImZpbHRlciIsInIiLCJpbmNsdWRlcyIsImxlbmd0aCIsImF1dGhSZXN1bHRzIiwic3RhcnRzV2l0aCIsImpvaW4iLCJka2ltRG9tYWluIiwiZEluZGV4IiwiZFZhbHVlIiwic2xpY2UiLCJpbmRleE9mIiwicGFyc2VEb21haW4iLCJkb21haW4iLCJnZXRpcEFkZHJlc3MiLCJnZXRJcCIsInByb2Nlc3NJcCIsImNvdW50cnkiLCJjb250aW5lbnQiLCJzdHJpbmdTZWFyY2hlciIsImNvbnNvbGUiLCJlcnJvciIsImxvZyIsInJlY2VpdmVkSGVhZGVycyIsImlwIiwiZm9yRWFjaCIsIm1hdGNoIiwic3RyIiwia2V5Iiwia2V5TGlzdCIsInB1c2giLCJmaWx0ZXJlZExpc3QiLCJpS2V5IiwiY29udHJvbGxlciIsInJlcSIsInJlcyIsIm5leHQiLCJib2R5IiwibWVzc2FnZUlkIiwiZW1haWwiLCJpbnRlcm5ldE1lc3NhZ2VJZCIsInN1YmplY3QiLCJjYyIsInRvTmFtZSIsImJjYyIsIm1haWxSZWNpZXZlZFRpbWUiLCJkYiIsIlVzZXIiLCJmaW5kT25lIiwidXNlciIsIlJlcXVlc3RFcnJvciIsInVzZXJJZCIsIl9pZCIsImRvbWFpbklkIiwiY29tcGFueUlkIiwiRG9tYWluIiwiZGVsZXRlZEF0IiwiTWV0YURhdGEiLCJuYW1lIiwidHNhdFVybCIsImlzVHNhdCIsImNhbkFjY2Vzc0ZlYXR1cmUiLCJ2YWx1ZSIsInF1ZXVlIiwiY3JlYXRlIiwicmVtb3ZlT25Db21wbGV0ZSIsInByaW9yaXR5Iiwic2F2ZSIsInRvIiwidXNlck5hbWUiLCJlbWFpbEFkZHJlc3MiLCJqc29uIiwic3VjY2VzcyIsIm1lc3NhZ2UiLCJyZXBvcnRlcnMiLCJtb3ZlVG9KdW5rIiwic3BhbVNjb3JlIiwiUmVwb3J0ZWRNYWlsIiwiaXNSZXBvcnRlZCIsInVwZGF0ZU9uZSIsIiRwdXNoIiwibWFpbGVyIiwic2VuZEFscmVhZHlSZXBvcnRlZE1haWwiLCJkb21haW5UeXBlRm9yT3V0bG9vayIsImV4Y2hhbmdlSGVhZGVycyIsImkiLCJoZWFkZXJEZXRhaWxzIiwicHJvY2Vzc0hlYWRlciIsIm90aGVyVG8iLCJmcm9tTmFtZSIsImRpc3BsYXlOYW1lIiwibWFpbElkIiwiaXNMaXRlRW52UmVwb3J0IiwibWFpbFR5cGUiLCJlbWFpbFR5cGUiLCJwYXJzZWRIZWFkZXIiLCJlbWFpbFJlcG9ydGVkIiwiYXBpUm91dGVyIiwiZXhwcmVzcyIsIlJvdXRlciIsInJvdXRlIiwicG9zdCJdLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9hcGkvcmVwb3J0L3JlcG9ydC1lbWFpbC1saXRlLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBKb2kgZnJvbSAnam9pJztcbmltcG9ydCBleHByZXNzIGZyb20gJ2V4cHJlc3MnO1xuXG5pbXBvcnQgeyBxdWV1ZSB9IGZyb20gJy4uLy4uL2t1ZSc7XG5pbXBvcnQgZ2V0TWFpbERhdGEgZnJvbSAnLi4vLi4vc2VydmljZS9nZXQtbWFpbC1kYXRhJztcbmltcG9ydCBTcGFtYyBmcm9tICdzcGFtYyc7XG5pbXBvcnQgY29uZmlnIGZyb20gJy4uLy4uL2NvbmZpZyc7XG5pbXBvcnQgeyBzYW5pdGl6ZSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3Nhbml0aXplcic7XG5pbXBvcnQgeyB2YWxpZGF0ZUJvZHkgfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy92YWxpZGF0b3InO1xuaW1wb3J0IHBhcnNlSGVhZGVyIGZyb20gJy4uLy4uL3NlcnZpY2UvcGFyc2UtaGVhZGVyJztcbmltcG9ydCBwYXJzZUVtYWlsIGZyb20gJy4uLy4uL3NlcnZpY2UvcGFyc2UtZW1haWwnO1xuaW1wb3J0IG1haWxlciBmcm9tICcuLi8uLi9tYWlsZXInXG5pbXBvcnQgY2FuQWNjZXNzRmVhdHVyZSBmcm9tICcuLi8uLi9zZXJ2aWNlL2FsbG93ZWQtZmVhdHVyZXMnO1xuaW1wb3J0IGdldElwIGZyb20gJy4uLy4uL3NlcnZpY2UvZ2V0LWlwJztcblxuLy8gbGV0IHZhbGlkYXRvciA9IEpvaS5vYmplY3QoKS5rZXlzKHtcbi8vICAgICBoZWFkZXI6IEpvaS5zdHJpbmcoKS5yZXF1aXJlZCgpLFxuLy8gICAgIGJvZHk6IEpvaS5zdHJpbmcoKS5yZXF1aXJlZCgpLFxuLy8gICAgIGVtYWlsOiBKb2kuc3RyaW5nKCkuZW1haWwoKS5yZXF1aXJlZCgpLFxuLy8gICAgIGludGVybmV0TWVzc2FnZUlkOiBKb2kuc3RyaW5nKCkucmVxdWlyZWQoKSxcbi8vIH0pO1xuXG5jb25zdCBzcGFtYyA9IG5ldyBTcGFtYyhjb25maWcuc3BhbWFzc2Vzc2lvbi5ob3N0LCBjb25maWcuc3BhbWFzc2Vzc2lvbi5wb3J0LCAxMDAwMCk7XG4vKipcbiAqIEBhcGkge3Bvc3R9IC9hcGkvcmVwb3J0L3JlcG9ydC1lbWFpbCByZXBvcnQtZW1haWxcbiAqIEBhcGlOYW1lIFJlcG9ydCBNYWlsXG4gKiBAYXBpR3JvdXAgUmVwb3J0XG4gKiBAYXBpRGVzY3JpcHRpb24gUmVwb3J0IGEgbWFpbFxuICogXG4gKiBAYXBpVmVyc2lvbiAxLjAuMFxuICogXG4gKiBAYXBpQm9keSB7U3RyaW5nfSBhY2Nlc3NUb2tlbiAgICAgICBSZXF1aXJlZCBhY2Nlc3NUb2tlbiBvZiB0aGUgbWFpbC5cbiAqIEBhcGlCb2R5IHtTdHJpbmd9IG1lc3NhZ2VJZCAgICAgICAgIFJlcXVpcmVkIG1lc3NhZ2VJZCBvZiB0aGUgbWFpbC5cbiAqIEBhcGlCb2R5IHtTdHJpbmd9IGVtYWlsICAgICAgICAgICAgIFJlcXVpcmVkIGVtYWlsIG9mIHRoZSBtYWlsLlxuICpcbiAqIEBhcGlTdWNjZXNzIHtCb29sZWFufSBzdWNjZXNzICAgIHRydWVcbiAqIEBhcGlTdWNjZXNzIHtTdHJpbmd9IG1lc3NhZ2UgICAgJ2VtYWlsIHJlcG9ydGVkIHN1Y2Nlc3NmdWxseSdcbiAqIFxuICAqIEBhcGlTdWNjZXNzRXhhbXBsZSBTdWNjZXNzLVJlc3BvbnNlOlxuICogICAgIEhUVFAvMS4xIDIwMCBPS1xuICogICAgICB7XG4gKiAgICAgICAgICBcInN1Y2Nlc3NcIjogIHRydWUsXG4gKiAgICAgICAgICBcIm1lc3NhZ2VcIjogICdlbWFpbCByZXBvcnRlZCBzdWNjZXNzZnVsbHknICAgICAgICBcbiAqICAgICAgfSBcbiAqIFxuICogQGFwaUVycm9yIHtCb29sZWFufSAgICBzdWNjZXNzICAgICBmYWxzZVxuICogQGFwaUVycm9yIHtCb29sZWFufSAgICBtZXNzYWdlcyAgICBbXCJ1c2VyIG5vdCBleGlzdHNcIl1cbiAqIFxuICogXG4gKiBAYXBpRXJyb3JFeGFtcGxlIEVycm9yLVJlc3BvbnNlOlxuICogICAgIEhUVFAvMS4xIDQwNCBOb3QgRm91bmRcbiAqICAgICAgIHtcbiAqICAgICAgICAgICBcInN1Y2Nlc3NcIjogZmFsc2UsXG4gKiAgICAgICAgICAgXCJtZXNzYWdlc1wiOiBbXG4gKiAgICAgICAgICAgICAgIFwidXNlciBub3QgZXhpc3RzXCJcbiAqICAgICAgICAgICBdXG4gKiAgICAgICB9XG4gKi9cblxuY29uc3QgZ2V0UGFyc2VIZWFkZXIgPSBhc3luYyAoaGVhZGVyLCBzdGF0dXMgPSB0cnVlKSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgbGV0IGludmVzdGlnYXRlID0ge307XG4gICAgICAgIGxldCBwYXJzZUVtbCA9IGhlYWRlclxuICAgICAgICBpZiAoc3RhdHVzKSBwYXJzZUVtbCA9IGF3YWl0IHBhcnNlRW1haWwucGFyc2VIZWFkZXIoaGVhZGVyKTtcbiAgICAgICAgaWYgKHBhcnNlRW1sKSB7XG4gICAgICAgICAgICBsZXQgZnJvbSA9IChwYXJzZUVtbCAmJiBwYXJzZUVtbC5mcm9tICYmIHBhcnNlRW1sLmZyb21bMF0uYWRkcmVzcykgPyBwYXJzZUVtbC5mcm9tWzBdLmFkZHJlc3MgOiAnJztcbiAgICAgICAgICAgIGxldCBzcGZEb21haW4gPSBwYXJzZUVtbC5oZWFkZXJzWydyZXR1cm4tcGF0aCddID9cbiAgICAgICAgICAgICAgICBBcnJheS5pc0FycmF5KHBhcnNlRW1sLmhlYWRlcnNbJ3JldHVybi1wYXRoJ10pID9cbiAgICAgICAgICAgICAgICAgICAgcGFyc2VFbWwuaGVhZGVyc1sncmV0dXJuLXBhdGgnXVswXS5zcGxpdChcIkBcIilbMV0gOlxuICAgICAgICAgICAgICAgICAgICBwYXJzZUVtbC5oZWFkZXJzWydyZXR1cm4tcGF0aCddLnNwbGl0KFwiQFwiKVsxXSA6XG4gICAgICAgICAgICAgICAgbnVsbDtcbiAgICAgICAgICAgIGxldCBwYXJzZWREb21haW4gPSBmcm9tLnNwbGl0KCdAJylbMV07XG4gICAgICAgICAgICBsZXQgZnJvbURvbWFpbiA9IHBhcnNlZERvbWFpbjtcbiAgICAgICAgICAgIGludmVzdGlnYXRlWydzcGZBbGxpZ25tZW50J10gPSAoZnJvbURvbWFpbiA9PSBzcGZEb21haW4pO1xuICAgICAgICAgICAgbGV0IGRraW1TaWdhbnR1cmUgPSBwYXJzZUVtbC5oZWFkZXJzWydka2ltLXNpZ25hdHVyZSddXG4gICAgICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShka2ltU2lnYW50dXJlKSkge1xuICAgICAgICAgICAgICAgIGxldCBzZWFyY2ggPSBgZD0ke2Zyb21Eb21haW59YFxuICAgICAgICAgICAgICAgIGxldCBmaWx0ZXJlZERraW1TaWdhbnR1cmUgPSBka2ltU2lnYW50dXJlLmZpbHRlcihyID0+IHIuaW5jbHVkZXMoc2VhcmNoKSlcbiAgICAgICAgICAgICAgICBpZiAoZmlsdGVyZWREa2ltU2lnYW50dXJlLmxlbmd0aCA+IDApIGRraW1TaWdhbnR1cmUgPSBmaWx0ZXJlZERraW1TaWdhbnR1cmVbMF07XG4gICAgICAgICAgICAgICAgZWxzZSBpZiAoZGtpbVNpZ2FudHVyZSA+IDApIGRraW1TaWdhbnR1cmUgPSBka2ltU2lnYW50dXJlWzBdO1xuICAgICAgICAgICAgICAgIGVsc2UgZGtpbVNpZ2FudHVyZSA9IG51bGw7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBsZXQgYXV0aFJlc3VsdHMgPSBwYXJzZUVtbC5oZWFkZXJzWydhdXRoZW50aWNhdGlvbi1yZXN1bHRzJ107XG4gICAgICAgICAgICBhdXRoUmVzdWx0cyA9ICgoQXJyYXkuaXNBcnJheShhdXRoUmVzdWx0cykgJiYgYXV0aFJlc3VsdHMubGVuZ3RoID4gMCkgPyBhdXRoUmVzdWx0cy5maWx0ZXIociA9PiByLnN0YXJ0c1dpdGgoJ2FtYXpvbnNlcy5jb20nKSkuam9pbihcIiBcIikgOiBhdXRoUmVzdWx0cyk7XG4gICAgICAgICAgICBsZXQgZGtpbURvbWFpbiA9ICgoZGtpbVNpZ2FudHVyZSAmJiBka2ltU2lnYW50dXJlICE9IG51bGwpID9cbiAgICAgICAgICAgICAgICAoZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgICAgICBsZXQgZEluZGV4ID0gZGtpbVNpZ2FudHVyZS5zZWFyY2goL2Q9Lio/Oy8pO1xuICAgICAgICAgICAgICAgICAgICBsZXQgZFZhbHVlID0gZGtpbVNpZ2FudHVyZS5zbGljZShkSW5kZXggKyAyLCBka2ltU2lnYW50dXJlLmluZGV4T2YoXCI7XCIsIGRJbmRleCArIDIpKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGRWYWx1ZTtcbiAgICAgICAgICAgICAgICB9KSgpIDogbnVsbCk7XG5cbiAgICAgICAgICAgIHBhcnNlZERvbWFpbiA9IGRraW1Eb21haW4gPyBhd2FpdCBwYXJzZURvbWFpbihka2ltRG9tYWluKSA6IG51bGw7XG4gICAgICAgICAgICBka2ltRG9tYWluID0gcGFyc2VkRG9tYWluID8gYCR7cGFyc2VkRG9tYWluLmRvbWFpbn1gIDogZGtpbURvbWFpbjtcbiAgICAgICAgICAgIGludmVzdGlnYXRlWydka2ltQWxsaWdubWVudCddID0gKGZyb21Eb21haW4gPT0gZGtpbURvbWFpbik7XG4gICAgICAgICAgICBpbnZlc3RpZ2F0ZVsnc2VuZGVySXAnXSA9IGF3YWl0IGdldGlwQWRkcmVzcyhwYXJzZUVtbC5oZWFkZXJzWydyZWNlaXZlZCddKTtcbiAgICAgICAgICAgIGxldCB7IGNvdW50cnksIGNvbnRpbmVudCB9ID0gYXdhaXQgZ2V0SXAucHJvY2Vzc0lwKGludmVzdGlnYXRlWydzZW5kZXJJcCddKTtcbiAgICAgICAgICAgIGlmIChjb3VudHJ5ICYmIGNvbnRpbmVudCkge1xuICAgICAgICAgICAgICAgIGludmVzdGlnYXRlWydjb3VudHJ5J10gPSBjb3VudHJ5O1xuICAgICAgICAgICAgICAgIGludmVzdGlnYXRlWydjb250aW5lbnQnXSA9IGNvbnRpbmVudFxuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBpbnZlc3RpZ2F0ZVsnY291bnRyeSddID0gJ05PVCBGT1VORCc7XG4gICAgICAgICAgICAgICAgaW52ZXN0aWdhdGVbJ2NvbnRpbmVudCddID0gJ05PVCBGT1VORCc7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpbnZlc3RpZ2F0ZVsnc3BmJ10gPSBzdHJpbmdTZWFyY2hlcihhdXRoUmVzdWx0cywgJ3NwZj1wYXNzJyk7XG4gICAgICAgICAgICBpbnZlc3RpZ2F0ZVsnZGtpbSddID0gc3RyaW5nU2VhcmNoZXIoYXV0aFJlc3VsdHMsICdka2ltPXBhc3MnKTtcbiAgICAgICAgICAgIGludmVzdGlnYXRlWydkbWFyYyddID0gc3RyaW5nU2VhcmNoZXIoYXV0aFJlc3VsdHMsIFsnZG1hcmM9cGFzcycsICdkbWFyYz1ub25lJ10pO1xuICAgICAgICAgICAgcmV0dXJuIGludmVzdGlnYXRlO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgY29uc29sZS5lcnJvcignZXJyb3IgZnJvbSBwYXJzaW5nIGhlYWRlciBkZXRhaWxzJyk7XG4gICAgICAgICAgICByZXR1cm4ge307XG4gICAgICAgIH1cbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgY29uc29sZS5sb2coZXJyKTtcbiAgICAgICAgcmV0dXJuIHt9O1xuICAgIH1cbn1cblxuY29uc3QgZ2V0aXBBZGRyZXNzID0gZnVuY3Rpb24gKHJlY2VpdmVkSGVhZGVycykge1xuICAgIGxldCBpcCA9IG51bGw7XG4gICAgcmVjZWl2ZWRIZWFkZXJzLlxuICAgICAgICBmb3JFYWNoKGhlYWRlciA9PiB7XG4gICAgICAgICAgICBjb25zdCBtYXRjaCA9IGhlYWRlci5tYXRjaCgvXFxiKD86XFxkezEsM31cXC4pezN9XFxkezEsM31cXGIvKTtcbiAgICAgICAgICAgIGlmIChtYXRjaCkge1xuICAgICAgICAgICAgICAgIGlwID0gbWF0Y2hbMF1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgcmV0dXJuIGlwO1xufVxuXG5jb25zdCBzdHJpbmdTZWFyY2hlciA9IGZ1bmN0aW9uIChzdHIsIGtleSkge1xuICAgIGxldCBrZXlMaXN0ID0gW107XG4gICAgaWYgKHR5cGVvZiBrZXkgPT09ICdzdHJpbmcnKSBrZXlMaXN0LnB1c2goa2V5KTtcbiAgICBlbHNlIGlmIChBcnJheS5pc0FycmF5KGtleSkpIGtleUxpc3QgPSBrZXk7XG4gICAgaWYgKHN0ciAmJiBzdHIubGVuZ3RoID4gMCkge1xuICAgICAgICBpZiAoa2V5Lmxlbmd0aCA9PSAwKSByZXR1cm4gJ2ZhaWwnO1xuICAgICAgICBsZXQgZmlsdGVyZWRMaXN0ID0ga2V5TGlzdC5maWx0ZXIoKGlLZXkpID0+IHN0ci5pbmRleE9mKGlLZXkpICE9IC0xKVxuICAgICAgICBpZiAoZmlsdGVyZWRMaXN0Lmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgIHJldHVybiAncGFzcyc7XG4gICAgICAgIH0gZWxzZSByZXR1cm4gJ2ZhaWwnO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiAnZmFpbCc7XG4gICAgfVxufVxuXG5sZXQgY29udHJvbGxlciA9IGFzeW5jIChyZXEsIHJlcywgbmV4dCkgPT4ge1xuICAgIHRyeSB7XG4gICAgICAgIGxldCB7IG1lc3NhZ2VJZCwgZW1haWwsIGludGVybmV0TWVzc2FnZUlkLCBoZWFkZXJzLCBib2R5LCBmcm9tLCBzdWJqZWN0LCBjYywgdG9OYW1lID0gJycsIGJjYyA9IFtdLCBtYWlsUmVjaWV2ZWRUaW1lIH0gPSByZXEuYm9keTtcbiAgICAgICAgY29uc3QgdXNlciA9IGF3YWl0IGRiLlVzZXIuZmluZE9uZSh7IGVtYWlsIH0pXG4gICAgICAgIGNvbnNvbGUubG9nKHtmcm9tfSk7XG4gICAgICAgIGlmKCF1c2VyKXtcbiAgICAgICAgICAgIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoJ3VzZXIgbm90IGV4aXN0cycsIDQwNCk7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgdXNlcklkID0gdXNlci5faWQ7XG4gICAgICAgIGNvbnN0IGRvbWFpbklkID0gdXNlci5kb21haW5JZDtcbiAgICAgICAgY29uc3QgY29tcGFueUlkID0gdXNlci5jb21wYW55SWQ7XG5cbiAgICAgICAgY29uc3QgZG9tYWluID0gYXdhaXQgZGIuRG9tYWluLmZpbmRPbmUoe1xuICAgICAgICAgICAgX2lkOiBkb21haW5JZCxcbiAgICAgICAgICAgIGNvbXBhbnlJZCxcbiAgICAgICAgICAgIGRlbGV0ZWRBdDogbnVsbFxuICAgICAgICB9KVxuICAgICAgICBpZighZG9tYWluKXtcbiAgICAgICAgICAgIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoJ2RvbWFpbiBub3QgZXhpc3RzJywgNDA0KTtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHRzYXRVcmwgPSBhd2FpdCBkYi5NZXRhRGF0YS5maW5kT25lKHtcbiAgICAgICAgICAgIGNvbXBhbnlJZCxcbiAgICAgICAgICAgIG5hbWU6ICd0c2F0VXJsJ1xuICAgICAgICB9KVxuICAgICAgICBjb25zdCBpc1RzYXQgPSBhd2FpdCBkYi5NZXRhRGF0YS5maW5kT25lKHtcbiAgICAgICAgICAgIGNvbXBhbnlJZCxcbiAgICAgICAgICAgIG5hbWU6ICdpc1RzYXQnXG4gICAgICAgIH0pXG5cbiAgICAgICAgICAgICAgICAgICAgXG5cbiAgICAgICAgaWYoYXdhaXQgY2FuQWNjZXNzRmVhdHVyZShjb21wYW55SWQsXCJUUElSLVRTQVRcIikgJiYgYm9keS5pbmRleE9mKCc/cmlkPScpIT09IC0xICYmIGlzVHNhdC52YWx1ZSA9PSAndHJ1ZScgJiYgdHNhdFVybC52YWx1ZSl7XG4gICAgICAgICAgICAvLyBjYWxsIHRvIHRzYXQgZm9yIGVtYWlsIHJlcG9ydGluZ1xuICAgICAgICAgICAgcXVldWUuY3JlYXRlKCdyb3V0ZS1lbWFpbC10c2F0JywgeyBoZWFkZXI6aGVhZGVycywgYm9keSwgdHNhdFVybH0pXG4gICAgICAgICAgICAucmVtb3ZlT25Db21wbGV0ZSh0cnVlKS5wcmlvcml0eSgnaGlnaCcpLnNhdmUoKTtcblxuICAgICAgICAgICAgaWYoYXdhaXQgY2FuQWNjZXNzRmVhdHVyZShjb21wYW55SWQsXCJUUElSLVJOXCIpKXtcbiAgICAgICAgICAgICAgICBxdWV1ZS5jcmVhdGUoJ3NlbmQtcmVwb3J0ZWQtbWFpbCcsIHtcbiAgICAgICAgICAgICAgICAgICAgdG86IGVtYWlsLFxuICAgICAgICAgICAgICAgICAgICB1c2VyTmFtZTogdXNlciA/IHVzZXIubmFtZSA/IHVzZXIubmFtZSA6JycgOicnLFxuICAgICAgICAgICAgICAgICAgICBmcm9tOiBmcm9tLmVtYWlsQWRkcmVzcyxcbiAgICAgICAgICAgICAgICAgICAgc3ViamVjdCxcbiAgICAgICAgICAgICAgICAgICAgbWFpbFJlY2lldmVkVGltZSxcbiAgICAgICAgICAgICAgICAgICAgY29tcGFueUlkXG4gICAgICAgICAgICAgICAgfSkucmVtb3ZlT25Db21wbGV0ZSh0cnVlKS5wcmlvcml0eSgnaGlnaCcpLnNhdmUoKVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZihhd2FpdCBjYW5BY2Nlc3NGZWF0dXJlKGNvbXBhbnlJZCxcIlRQSVItRUFTT0NcIikpe1xuICAgICAgICAgICAgcXVldWUuY3JlYXRlKCdzZW5kLXNvYy1tYWlsJywge1xuICAgICAgICAgICAgICAgIHRvOmVtYWlsLFxuICAgICAgICAgICAgICAgIGZyb206IGZyb20uZW1haWxBZGRyZXNzLFxuICAgICAgICAgICAgICAgIHN1YmplY3QsXG4gICAgICAgICAgICAgICAgbWFpbFJlY2lldmVkVGltZSxcbiAgICAgICAgICAgICAgICBoZWFkZXI6IGhlYWRlcnMsXG4gICAgICAgICAgICAgICAgYm9keSxcbiAgICAgICAgICAgICAgICBjb21wYW55SWQsXG4gICAgICAgICAgICB9KS5yZW1vdmVPbkNvbXBsZXRlKHRydWUpLnByaW9yaXR5KCdoaWdoJykuc2F2ZSgpXG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHJldHVybiByZXMuc3RhdHVzKDIwMCkuanNvbih7IHN1Y2Nlc3M6IHRydWUsIG1lc3NhZ2U6ICdlbWFpbCByZXBvcnRlZCBzdWNjZXNzZnVsbHknLCByZXBvcnRlcnM6IDEsIG1vdmVUb0p1bms6IHRydWUsIHNwYW1TY29yZTogMCB9KTsgICAgICAgIFxuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgaXNSZXBvcnRlZCA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5maW5kT25lKHsgaW50ZXJuZXRNZXNzYWdlSWQgfSlcblxuICAgICAgICBpZihpc1JlcG9ydGVkKXtcbiAgICAgICAgICAgICAgICBhd2FpdCBkYi5SZXBvcnRlZE1haWwudXBkYXRlT25lKHsgX2lkOmlzUmVwb3J0ZWQuX2lkIH0sIHsgJHB1c2g6IHsgcmVwb3J0ZXJzOiB7ZW1haWx9IH0gfSk7XG4gICAgICAgICAgICAgICAgaWYoYXdhaXQgY2FuQWNjZXNzRmVhdHVyZShjb21wYW55SWQsXCJUUElSLVJOXCIpKSBtYWlsZXIuc2VuZEFscmVhZHlSZXBvcnRlZE1haWwodXNlci5uYW1lLCBlbWFpbCwgY29tcGFueUlkKVxuICAgICAgICAgICAgICAgIHJlcy5zdGF0dXMoMjAwKS5qc29uKHsgc3VjY2VzczogdHJ1ZSwgcmVwb3J0ZXJzOiBpc1JlcG9ydGVkLnJlcG9ydGVycyA/IGlzUmVwb3J0ZWQucmVwb3J0ZXJzLmxlbmd0aCArIDIgOiAwLCBzcGFtU2NvcmU6IGlzUmVwb3J0ZWQuc3BhbVNjb3JlLG1vdmVUb0p1bms6IHRydWUsIG1lc3NhZ2U6ICdlbWFpbCByZXBvcnRlZCBzdWNjZXNzZnVsbHknICB9KTtcbiAgICAgICAgfVxuICAgICAgICBlbHNle1xuXG4gICAgICAgICAgICBpZihkb21haW4uZG9tYWluVHlwZUZvck91dGxvb2sgPT0gJ0VYQ0hBTkdFJyl7XG4gICAgICAgICAgICAgICAgbGV0IGV4Y2hhbmdlSGVhZGVycyA9ICcnXG4gICAgICAgICAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBoZWFkZXJzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgICAgICAgICAgIGV4Y2hhbmdlSGVhZGVycyA9IGV4Y2hhbmdlSGVhZGVycyArIGhlYWRlcnNbaV0/Lm5hbWUgKyAnICcgKyBoZWFkZXJzW2ldPy52YWx1ZSArICdcXG4nO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBoZWFkZXJzID0gZXhjaGFuZ2VIZWFkZXJzXG4gICAgICAgICAgICB9XG5cblxuICAgICAgICAgICAgbGV0IGhlYWRlckRldGFpbHMgPSB7fTtcbiAgICAgICAgICAgIGNvbnN0IHBhcnNlRW1sID0gYXdhaXQgcGFyc2VFbWFpbC5wYXJzZUVtbChoZWFkZXJzKVxuXG4gICAgICAgICAgICBpZihkb21haW4uZG9tYWluVHlwZUZvck91dGxvb2sgPT0gXCJFWENIQU5HRVwiKSB7IGhlYWRlckRldGFpbHMgPSBhd2FpdCBnZXRQYXJzZUhlYWRlcihoZWFkZXJzKX1cbiAgICAgICAgICAgIGVsc2UgeyBoZWFkZXJEZXRhaWxzID0gYXdhaXQgcGFyc2VIZWFkZXIucHJvY2Vzc0hlYWRlcihwYXJzZUVtbCwgZmFsc2UpfVxuICAgICAgICAgICAgbGV0IG90aGVyVG8gPSBwYXJzZUVtbC50byA/IHBhcnNlRW1sLnRvIDogW107XG4gICAgICAgICAgICBcbiAgICAgICAgICAgIGNvbnN0IGVtYWlsUmVwb3J0ZWQgPSBhd2FpdCBkYi5SZXBvcnRlZE1haWwuY3JlYXRlKHtcbiAgICAgICAgICAgICAgICBmcm9tOiBmcm9tLmVtYWlsQWRkcmVzcywgZnJvbU5hbWU6IGZyb20uZGlzcGxheU5hbWUsIHRvOiBlbWFpbCwgdG9OYW1lOnVzZXIubmFtZSwgc3ViamVjdCwgbWFpbElkOiBtZXNzYWdlSWQsIGNjLFxuICAgICAgICAgICAgICAgIGJjYywgb3RoZXJUbzpbXSwgbWVzc2FnZUlkLCBpbnRlcm5ldE1lc3NhZ2VJZCwgbWFpbFJlY2lldmVkVGltZSwgY29tcGFueUlkLCBpc0xpdGVFbnZSZXBvcnQ6IHRydWUsXG4gICAgICAgICAgICAgICAgbWFpbFR5cGU6IHVzZXIuZW1haWxUeXBlICwgaGVhZGVyOiBoZWFkZXJzLCBib2R5LCB1c2VySWQsIGhlYWRlckRldGFpbHMsIGRvbWFpbklkLCBwYXJzZWRIZWFkZXI6IHBhcnNlRW1sXG4gICAgICAgICAgICB9KVxuICAgICAgICAgICAgaWYoYXdhaXQgY2FuQWNjZXNzRmVhdHVyZShjb21wYW55SWQsXCJUUElSLVJOXCIpKXtcbiAgICAgICAgICAgIHF1ZXVlLmNyZWF0ZSgnc2VuZC1yZXBvcnRlZC1tYWlsJywge1xuICAgICAgICAgICAgICAgIHRvOiBlbWFpbCxcbiAgICAgICAgICAgICAgICB1c2VyTmFtZTogdXNlciA/IHVzZXIubmFtZSA/IHVzZXIubmFtZSA6JycgOicnLFxuICAgICAgICAgICAgICAgIGZyb206IGZyb20uZW1haWxBZGRyZXNzLFxuICAgICAgICAgICAgICAgIHN1YmplY3QsXG4gICAgICAgICAgICAgICAgbWFpbFJlY2lldmVkVGltZSxcbiAgICAgICAgICAgICAgICBjb21wYW55SWRcbiAgICAgICAgICAgIH0pLnJlbW92ZU9uQ29tcGxldGUodHJ1ZSkucHJpb3JpdHkoJ2hpZ2gnKS5zYXZlKClcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmKGF3YWl0IGNhbkFjY2Vzc0ZlYXR1cmUoY29tcGFueUlkLFwiVFBJUi1FQVNPQ1wiKSl7XG4gICAgICAgICAgICBxdWV1ZS5jcmVhdGUoJ3NlbmQtc29jLW1haWwnLCB7XG4gICAgICAgICAgICAgICAgdG86IGVtYWlsLFxuICAgICAgICAgICAgICAgIGZyb206IGZyb20uZW1haWxBZGRyZXNzLFxuICAgICAgICAgICAgICAgIHN1YmplY3QsXG4gICAgICAgICAgICAgICAgbWFpbFJlY2lldmVkVGltZSxcbiAgICAgICAgICAgICAgICBoZWFkZXI6IGhlYWRlcnMsXG4gICAgICAgICAgICAgICAgYm9keSxcbiAgICAgICAgICAgICAgICBjb21wYW55SWQsXG4gICAgICAgICAgICB9KS5yZW1vdmVPbkNvbXBsZXRlKHRydWUpLnByaW9yaXR5KCdoaWdoJykuc2F2ZSgpXG4gICAgICAgICAgICB9XG5cbiAgICAgICAgcmVzLnN0YXR1cygyMDApLmpzb24oeyBzdWNjZXNzOiB0cnVlLCBtZXNzYWdlOiAnZW1haWwgcmVwb3J0ZWQgc3VjY2Vzc2Z1bGx5JywgcmVwb3J0ZXJzOiAxLCBtb3ZlVG9KdW5rOiB0cnVlLCBzcGFtU2NvcmU6IDAgfSk7XG4gICAgICAgIFxuICAgIH1cbiAgICB9IGNhdGNoKGVycil7XG4gICAgICAgIGNvbnNvbGUubG9nKGVycik7XG4gICAgICAgIG5leHQoZXJyKTtcbiAgICB9XG59XG5jb25zdCBhcGlSb3V0ZXIgPSBleHByZXNzLlJvdXRlcigpO1xuYXBpUm91dGVyLnJvdXRlKCcvJykucG9zdChjb250cm9sbGVyKTtcbmV4cG9ydCBkZWZhdWx0IGFwaVJvdXRlcjtcblxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxJQUFNQSxLQUFLLEdBQUcsSUFBSUMsaUJBQUssQ0FBQ0Msa0JBQU0sQ0FBQ0MsYUFBYSxDQUFDQyxJQUFJLEVBQUVGLGtCQUFNLENBQUNDLGFBQWEsQ0FBQ0UsSUFBSSxFQUFFLEtBQUssQ0FBQztBQUNwRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLElBQU1DLGNBQWM7RUFBQSx5RkFBRyxpQkFBT0MsTUFBTTtJQUFBO01BQUE7TUFBQTtNQUFBO01BQUE7TUFBQTtNQUFBO01BQUE7TUFBQTtNQUFBO01BQUE7TUFBQTtNQUFBO01BQUE7TUFBQTtNQUFBO0lBQUE7TUFBQTtRQUFBO1VBQUVDLE1BQU0sMkRBQUcsSUFBSTtVQUFBO1VBRXZDQyxXQUFXLEdBQUcsQ0FBQyxDQUFDO1VBQ2hCQyxRQUFRLEdBQUdILE1BQU07VUFBQSxLQUNqQkMsTUFBTTtZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBbUJHLHNCQUFVLENBQUNDLFdBQVcsQ0FBQ0wsTUFBTSxDQUFDO1FBQUE7VUFBL0NHLFFBQVE7UUFBQTtVQUFBLEtBQ2hCQSxRQUFRO1lBQUE7WUFBQTtVQUFBO1VBQ0pHLElBQUksR0FBSUgsUUFBUSxJQUFJQSxRQUFRLENBQUNHLElBQUksSUFBSUgsUUFBUSxDQUFDRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUNDLE9BQU8sR0FBSUosUUFBUSxDQUFDRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUNDLE9BQU8sR0FBRyxFQUFFO1VBQzlGQyxTQUFTLEdBQUdMLFFBQVEsQ0FBQ00sT0FBTyxDQUFDLGFBQWEsQ0FBQyxHQUMzQ0MsS0FBSyxDQUFDQyxPQUFPLENBQUNSLFFBQVEsQ0FBQ00sT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDLEdBQzFDTixRQUFRLENBQUNNLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUNoRFQsUUFBUSxDQUFDTSxPQUFPLENBQUMsYUFBYSxDQUFDLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FDakQsSUFBSTtVQUNKQyxZQUFZLEdBQUdQLElBQUksQ0FBQ00sS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztVQUNqQ0UsVUFBVSxHQUFHRCxZQUFZO1VBQzdCWCxXQUFXLENBQUMsZUFBZSxDQUFDLEdBQUlZLFVBQVUsSUFBSU4sU0FBVTtVQUNwRE8sYUFBYSxHQUFHWixRQUFRLENBQUNNLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztVQUN0RCxJQUFJQyxLQUFLLENBQUNDLE9BQU8sQ0FBQ0ksYUFBYSxDQUFDLEVBQUU7WUFDMUJDLE1BQU0sZUFBUUYsVUFBVTtZQUN4QkcscUJBQXFCLEdBQUdGLGFBQWEsQ0FBQ0csTUFBTSxDQUFDLFVBQUFDLENBQUM7Y0FBQSxPQUFJQSxDQUFDLENBQUNDLFFBQVEsQ0FBQ0osTUFBTSxDQUFDO1lBQUEsRUFBQztZQUN6RSxJQUFJQyxxQkFBcUIsQ0FBQ0ksTUFBTSxHQUFHLENBQUMsRUFBRU4sYUFBYSxHQUFHRSxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUMxRSxJQUFJRixhQUFhLEdBQUcsQ0FBQyxFQUFFQSxhQUFhLEdBQUdBLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUN4REEsYUFBYSxHQUFHLElBQUk7VUFDN0I7VUFDSU8sV0FBVyxHQUFHbkIsUUFBUSxDQUFDTSxPQUFPLENBQUMsd0JBQXdCLENBQUM7VUFDNURhLFdBQVcsR0FBS1osS0FBSyxDQUFDQyxPQUFPLENBQUNXLFdBQVcsQ0FBQyxJQUFJQSxXQUFXLENBQUNELE1BQU0sR0FBRyxDQUFDLEdBQUlDLFdBQVcsQ0FBQ0osTUFBTSxDQUFDLFVBQUFDLENBQUM7WUFBQSxPQUFJQSxDQUFDLENBQUNJLFVBQVUsQ0FBQyxlQUFlLENBQUM7VUFBQSxFQUFDLENBQUNDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBR0YsV0FBWTtVQUNuSkcsVUFBVSxHQUFLVixhQUFhLElBQUlBLGFBQWEsSUFBSSxJQUFJLEdBQ3BELFlBQVk7WUFDVCxJQUFJVyxNQUFNLEdBQUdYLGFBQWEsQ0FBQ0MsTUFBTSxDQUFDLFFBQVEsQ0FBQztZQUMzQyxJQUFJVyxNQUFNLEdBQUdaLGFBQWEsQ0FBQ2EsS0FBSyxDQUFDRixNQUFNLEdBQUcsQ0FBQyxFQUFFWCxhQUFhLENBQUNjLE9BQU8sQ0FBQyxHQUFHLEVBQUVILE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQztZQUNwRixPQUFPQyxNQUFNO1VBQ2pCLENBQUMsRUFBRyxHQUFHLElBQUk7VUFBQSxLQUVBRixVQUFVO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUFTSyxXQUFXLENBQUNMLFVBQVUsQ0FBQztRQUFBO1VBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQSxjQUFHLElBQUk7UUFBQTtVQUFoRVosWUFBWTtVQUNaWSxVQUFVLEdBQUdaLFlBQVksYUFBTUEsWUFBWSxDQUFDa0IsTUFBTSxJQUFLTixVQUFVO1VBQ2pFdkIsV0FBVyxDQUFDLGdCQUFnQixDQUFDLEdBQUlZLFVBQVUsSUFBSVcsVUFBVztVQUFDO1VBQUEsT0FDM0JPLFlBQVksQ0FBQzdCLFFBQVEsQ0FBQ00sT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQUE7VUFBMUVQLFdBQVcsQ0FBQyxVQUFVLENBQUM7VUFBQTtVQUFBLE9BQ1krQixpQkFBSyxDQUFDQyxTQUFTLENBQUNoQyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQXJFaUMsT0FBTyx5QkFBUEEsT0FBTztVQUFFQyxTQUFTLHlCQUFUQSxTQUFTO1VBQ3hCLElBQUlELE9BQU8sSUFBSUMsU0FBUyxFQUFFO1lBQ3RCbEMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxHQUFHaUMsT0FBTztZQUNoQ2pDLFdBQVcsQ0FBQyxXQUFXLENBQUMsR0FBR2tDLFNBQVM7VUFDeEMsQ0FBQyxNQUFNO1lBQ0hsQyxXQUFXLENBQUMsU0FBUyxDQUFDLEdBQUcsV0FBVztZQUNwQ0EsV0FBVyxDQUFDLFdBQVcsQ0FBQyxHQUFHLFdBQVc7VUFDMUM7VUFDQUEsV0FBVyxDQUFDLEtBQUssQ0FBQyxHQUFHbUMsY0FBYyxDQUFDZixXQUFXLEVBQUUsVUFBVSxDQUFDO1VBQzVEcEIsV0FBVyxDQUFDLE1BQU0sQ0FBQyxHQUFHbUMsY0FBYyxDQUFDZixXQUFXLEVBQUUsV0FBVyxDQUFDO1VBQzlEcEIsV0FBVyxDQUFDLE9BQU8sQ0FBQyxHQUFHbUMsY0FBYyxDQUFDZixXQUFXLEVBQUUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7VUFBQyxpQ0FDMUVwQixXQUFXO1FBQUE7VUFFbEJvQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxtQ0FBbUMsQ0FBQztVQUFDLGlDQUM1QyxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUE7VUFHYkQsT0FBTyxDQUFDRSxHQUFHLGFBQUs7VUFBQyxpQ0FDVixDQUFDLENBQUM7UUFBQTtRQUFBO1VBQUE7TUFBQTtJQUFBO0VBQUEsQ0FFaEI7RUFBQSxnQkF4REt6QyxjQUFjO0lBQUE7RUFBQTtBQUFBLEdBd0RuQjtBQUVELElBQU1pQyxZQUFZLEdBQUcsU0FBZkEsWUFBWSxDQUFhUyxlQUFlLEVBQUU7RUFDNUMsSUFBSUMsRUFBRSxHQUFHLElBQUk7RUFDYkQsZUFBZSxDQUNYRSxPQUFPLENBQUMsVUFBQTNDLE1BQU0sRUFBSTtJQUNkLElBQU00QyxLQUFLLEdBQUc1QyxNQUFNLENBQUM0QyxLQUFLLENBQUMsNkJBQTZCLENBQUM7SUFDekQsSUFBSUEsS0FBSyxFQUFFO01BQ1BGLEVBQUUsR0FBR0UsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNqQjtFQUNKLENBQUMsQ0FBQztFQUNOLE9BQU9GLEVBQUU7QUFDYixDQUFDO0FBRUQsSUFBTUwsY0FBYyxHQUFHLFNBQWpCQSxjQUFjLENBQWFRLEdBQUcsRUFBRUMsR0FBRyxFQUFFO0VBQ3ZDLElBQUlDLE9BQU8sR0FBRyxFQUFFO0VBQ2hCLElBQUksT0FBT0QsR0FBRyxLQUFLLFFBQVEsRUFBRUMsT0FBTyxDQUFDQyxJQUFJLENBQUNGLEdBQUcsQ0FBQyxDQUFDLEtBQzFDLElBQUlwQyxLQUFLLENBQUNDLE9BQU8sQ0FBQ21DLEdBQUcsQ0FBQyxFQUFFQyxPQUFPLEdBQUdELEdBQUc7RUFDMUMsSUFBSUQsR0FBRyxJQUFJQSxHQUFHLENBQUN4QixNQUFNLEdBQUcsQ0FBQyxFQUFFO0lBQ3ZCLElBQUl5QixHQUFHLENBQUN6QixNQUFNLElBQUksQ0FBQyxFQUFFLE9BQU8sTUFBTTtJQUNsQyxJQUFJNEIsWUFBWSxHQUFHRixPQUFPLENBQUM3QixNQUFNLENBQUMsVUFBQ2dDLElBQUk7TUFBQSxPQUFLTCxHQUFHLENBQUNoQixPQUFPLENBQUNxQixJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFBQSxFQUFDO0lBQ3BFLElBQUlELFlBQVksQ0FBQzVCLE1BQU0sR0FBRyxDQUFDLEVBQUU7TUFDekIsT0FBTyxNQUFNO0lBQ2pCLENBQUMsTUFBTSxPQUFPLE1BQU07RUFDeEIsQ0FBQyxNQUFNO0lBQ0gsT0FBTyxNQUFNO0VBQ2pCO0FBQ0osQ0FBQztBQUVELElBQUk4QixVQUFVO0VBQUEsMEZBQUcsa0JBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUFBLFlBRTJGRixHQUFHLENBQUNHLElBQUksRUFBM0hDLFNBQVMsYUFBVEEsU0FBUyxFQUFFQyxLQUFLLGFBQUxBLEtBQUssRUFBRUMsaUJBQWlCLGFBQWpCQSxpQkFBaUIsRUFBRWpELE9BQU8sYUFBUEEsT0FBTyxFQUFFOEMsSUFBSSxhQUFKQSxJQUFJLEVBQUVqRCxJQUFJLGFBQUpBLElBQUksRUFBRXFELE9BQU8sYUFBUEEsT0FBTyxFQUFFQyxFQUFFLGFBQUZBLEVBQUUsK0JBQUVDLE1BQU0sRUFBTkEsTUFBTSxpQ0FBRyxFQUFFLCtDQUFFQyxHQUFHLEVBQUhBLEdBQUcsOEJBQUcsRUFBRSxrQkFBRUMsZ0JBQWdCLGFBQWhCQSxnQkFBZ0I7VUFBQTtVQUFBLE9BQ2pHQyxFQUFFLENBQUNDLElBQUksQ0FBQ0MsT0FBTyxDQUFDO1lBQUVULEtBQUssRUFBTEE7VUFBTSxDQUFDLENBQUM7UUFBQTtVQUF2Q1UsSUFBSTtVQUNWN0IsT0FBTyxDQUFDRSxHQUFHLENBQUM7WUFBQ2xDLElBQUksRUFBSkE7VUFBSSxDQUFDLENBQUM7VUFBQyxJQUNoQjZELElBQUk7WUFBQTtZQUFBO1VBQUE7VUFBQSxNQUNFLElBQUlDLFlBQVksQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUM7UUFBQTtVQUU1Q0MsTUFBTSxHQUFHRixJQUFJLENBQUNHLEdBQUc7VUFDakJDLFFBQVEsR0FBR0osSUFBSSxDQUFDSSxRQUFRO1VBQ3hCQyxTQUFTLEdBQUdMLElBQUksQ0FBQ0ssU0FBUztVQUFBO1VBQUEsT0FFWFIsRUFBRSxDQUFDUyxNQUFNLENBQUNQLE9BQU8sQ0FBQztZQUNuQ0ksR0FBRyxFQUFFQyxRQUFRO1lBQ2JDLFNBQVMsRUFBVEEsU0FBUztZQUNURSxTQUFTLEVBQUU7VUFDZixDQUFDLENBQUM7UUFBQTtVQUpJM0MsTUFBTTtVQUFBLElBS1JBLE1BQU07WUFBQTtZQUFBO1VBQUE7VUFBQSxNQUNBLElBQUlxQyxZQUFZLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDO1FBQUE7VUFBQTtVQUFBLE9BRzlCSixFQUFFLENBQUNXLFFBQVEsQ0FBQ1QsT0FBTyxDQUFDO1lBQ3RDTSxTQUFTLEVBQVRBLFNBQVM7WUFDVEksSUFBSSxFQUFFO1VBQ1YsQ0FBQyxDQUFDO1FBQUE7VUFISUMsT0FBTztVQUFBO1VBQUEsT0FJUWIsRUFBRSxDQUFDVyxRQUFRLENBQUNULE9BQU8sQ0FBQztZQUNyQ00sU0FBUyxFQUFUQSxTQUFTO1lBQ1RJLElBQUksRUFBRTtVQUNWLENBQUMsQ0FBQztRQUFBO1VBSElFLE1BQU07VUFBQTtVQUFBLE9BT0gsSUFBQUMsMkJBQWdCLEVBQUNQLFNBQVMsRUFBQyxXQUFXLENBQUM7UUFBQTtVQUFBO1VBQUE7WUFBQTtZQUFBO1VBQUE7VUFBQSxlQUFJakIsSUFBSSxDQUFDMUIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxLQUFJLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtZQUFBO1lBQUE7VUFBQTtVQUFBLGVBQUlpRCxNQUFNLENBQUNFLEtBQUssSUFBSSxNQUFNO1FBQUE7VUFBQTtVQUFBO1lBQUE7WUFBQTtVQUFBO1VBQUEsZUFBSUgsT0FBTyxDQUFDRyxLQUFLO1FBQUE7VUFBQTtZQUFBO1lBQUE7VUFBQTtVQUN0SDtVQUNBQyxVQUFLLENBQUNDLE1BQU0sQ0FBQyxrQkFBa0IsRUFBRTtZQUFFbEYsTUFBTSxFQUFDUyxPQUFPO1lBQUU4QyxJQUFJLEVBQUpBLElBQUk7WUFBRXNCLE9BQU8sRUFBUEE7VUFBTyxDQUFDLENBQUMsQ0FDakVNLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUNDLElBQUksRUFBRTtVQUFDO1VBQUEsT0FFdkMsSUFBQU4sMkJBQWdCLEVBQUNQLFNBQVMsRUFBQyxTQUFTLENBQUM7UUFBQTtVQUFBO1lBQUE7WUFBQTtVQUFBO1VBQzFDUyxVQUFLLENBQUNDLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRTtZQUMvQkksRUFBRSxFQUFFN0IsS0FBSztZQUNUOEIsUUFBUSxFQUFFcEIsSUFBSSxHQUFHQSxJQUFJLENBQUNTLElBQUksR0FBR1QsSUFBSSxDQUFDUyxJQUFJLEdBQUUsRUFBRSxHQUFFLEVBQUU7WUFDOUN0RSxJQUFJLEVBQUVBLElBQUksQ0FBQ2tGLFlBQVk7WUFDdkI3QixPQUFPLEVBQVBBLE9BQU87WUFDUEksZ0JBQWdCLEVBQWhCQSxnQkFBZ0I7WUFDaEJTLFNBQVMsRUFBVEE7VUFDSixDQUFDLENBQUMsQ0FBQ1csZ0JBQWdCLENBQUMsSUFBSSxDQUFDLENBQUNDLFFBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQ0MsSUFBSSxFQUFFO1FBQUE7VUFBQTtVQUFBLE9BRzVDLElBQUFOLDJCQUFnQixFQUFDUCxTQUFTLEVBQUMsWUFBWSxDQUFDO1FBQUE7VUFBQTtZQUFBO1lBQUE7VUFBQTtVQUNqRFMsVUFBSyxDQUFDQyxNQUFNLENBQUMsZUFBZSxFQUFFO1lBQzFCSSxFQUFFLEVBQUM3QixLQUFLO1lBQ1JuRCxJQUFJLEVBQUVBLElBQUksQ0FBQ2tGLFlBQVk7WUFDdkI3QixPQUFPLEVBQVBBLE9BQU87WUFDUEksZ0JBQWdCLEVBQWhCQSxnQkFBZ0I7WUFDaEIvRCxNQUFNLEVBQUVTLE9BQU87WUFDZjhDLElBQUksRUFBSkEsSUFBSTtZQUNKaUIsU0FBUyxFQUFUQTtVQUNKLENBQUMsQ0FBQyxDQUFDVyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsQ0FBQ0MsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDQyxJQUFJLEVBQUU7UUFBQTtVQUFBLGtDQUcxQ2hDLEdBQUcsQ0FBQ3BELE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ3dGLElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFQyxPQUFPLEVBQUUsNkJBQTZCO1lBQUVDLFNBQVMsRUFBRSxDQUFDO1lBQUVDLFVBQVUsRUFBRSxJQUFJO1lBQUVDLFNBQVMsRUFBRTtVQUFFLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUcvRzlCLEVBQUUsQ0FBQytCLFlBQVksQ0FBQzdCLE9BQU8sQ0FBQztZQUFFUixpQkFBaUIsRUFBakJBO1VBQWtCLENBQUMsQ0FBQztRQUFBO1VBQWpFc0MsVUFBVTtVQUFBLEtBRWJBLFVBQVU7WUFBQTtZQUFBO1VBQUE7VUFBQTtVQUFBLE9BQ0NoQyxFQUFFLENBQUMrQixZQUFZLENBQUNFLFNBQVMsQ0FBQztZQUFFM0IsR0FBRyxFQUFDMEIsVUFBVSxDQUFDMUI7VUFBSSxDQUFDLEVBQUU7WUFBRTRCLEtBQUssRUFBRTtjQUFFTixTQUFTLEVBQUU7Z0JBQUNuQyxLQUFLLEVBQUxBO2NBQUs7WUFBRTtVQUFFLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUNqRixJQUFBc0IsMkJBQWdCLEVBQUNQLFNBQVMsRUFBQyxTQUFTLENBQUM7UUFBQTtVQUFBO1lBQUE7WUFBQTtVQUFBO1VBQUUyQixrQkFBTSxDQUFDQyx1QkFBdUIsQ0FBQ2pDLElBQUksQ0FBQ1MsSUFBSSxFQUFFbkIsS0FBSyxFQUFFZSxTQUFTLENBQUM7UUFBQTtVQUMzR25CLEdBQUcsQ0FBQ3BELE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ3dGLElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFRSxTQUFTLEVBQUVJLFVBQVUsQ0FBQ0osU0FBUyxHQUFHSSxVQUFVLENBQUNKLFNBQVMsQ0FBQ3ZFLE1BQU0sR0FBRyxDQUFDLEdBQUcsQ0FBQztZQUFFeUUsU0FBUyxFQUFFRSxVQUFVLENBQUNGLFNBQVM7WUFBQ0QsVUFBVSxFQUFFLElBQUk7WUFBRUYsT0FBTyxFQUFFO1VBQStCLENBQUMsQ0FBQztVQUFDO1VBQUE7UUFBQTtVQUk5TSxJQUFHNUQsTUFBTSxDQUFDc0Usb0JBQW9CLElBQUksVUFBVSxFQUFDO1lBQ3JDQyxlQUFlLEdBQUcsRUFBRTtZQUN4QixLQUFTQyxDQUFDLEdBQUcsQ0FBQyxFQUFFQSxDQUFDLEdBQUc5RixPQUFPLENBQUNZLE1BQU0sRUFBRWtGLENBQUMsRUFBRSxFQUFFO2NBQ3JDRCxlQUFlLEdBQUdBLGVBQWUsa0JBQUc3RixPQUFPLENBQUM4RixDQUFDLENBQUMsK0NBQVYsV0FBWTNCLElBQUksSUFBRyxHQUFHLG1CQUFHbkUsT0FBTyxDQUFDOEYsQ0FBQyxDQUFDLGdEQUFWLFlBQVl2QixLQUFLLElBQUcsSUFBSTtZQUN6RjtZQUNBdkUsT0FBTyxHQUFHNkYsZUFBZTtVQUM3QjtVQUdJRSxhQUFhLEdBQUcsQ0FBQyxDQUFDO1VBQUE7VUFBQSxPQUNDcEcsc0JBQVUsQ0FBQ0QsUUFBUSxDQUFDTSxPQUFPLENBQUM7UUFBQTtVQUE3Q04sUUFBUTtVQUFBLE1BRVg0QixNQUFNLENBQUNzRSxvQkFBb0IsSUFBSSxVQUFVO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUEwQnRHLGNBQWMsQ0FBQ1UsT0FBTyxDQUFDO1FBQUE7VUFBN0MrRixhQUFhO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQSxPQUNoQ25HLHVCQUFXLENBQUNvRyxhQUFhLENBQUN0RyxRQUFRLEVBQUUsS0FBSyxDQUFDO1FBQUE7VUFBaEVxRyxhQUFhO1FBQUE7VUFDaEJFLE9BQU8sR0FBR3ZHLFFBQVEsQ0FBQ21GLEVBQUUsR0FBR25GLFFBQVEsQ0FBQ21GLEVBQUUsR0FBRyxFQUFFO1VBQUE7VUFBQSxPQUVoQnRCLEVBQUUsQ0FBQytCLFlBQVksQ0FBQ2IsTUFBTSxDQUFDO1lBQy9DNUUsSUFBSSxFQUFFQSxJQUFJLENBQUNrRixZQUFZO1lBQUVtQixRQUFRLEVBQUVyRyxJQUFJLENBQUNzRyxXQUFXO1lBQUV0QixFQUFFLEVBQUU3QixLQUFLO1lBQUVJLE1BQU0sRUFBQ00sSUFBSSxDQUFDUyxJQUFJO1lBQUVqQixPQUFPLEVBQVBBLE9BQU87WUFBRWtELE1BQU0sRUFBRXJELFNBQVM7WUFBRUksRUFBRSxFQUFGQSxFQUFFO1lBQ2hIRSxHQUFHLEVBQUhBLEdBQUc7WUFBRTRDLE9BQU8sRUFBQyxFQUFFO1lBQUVsRCxTQUFTLEVBQVRBLFNBQVM7WUFBRUUsaUJBQWlCLEVBQWpCQSxpQkFBaUI7WUFBRUssZ0JBQWdCLEVBQWhCQSxnQkFBZ0I7WUFBRVMsU0FBUyxFQUFUQSxTQUFTO1lBQUVzQyxlQUFlLEVBQUUsSUFBSTtZQUNqR0MsUUFBUSxFQUFFNUMsSUFBSSxDQUFDNkMsU0FBUztZQUFHaEgsTUFBTSxFQUFFUyxPQUFPO1lBQUU4QyxJQUFJLEVBQUpBLElBQUk7WUFBRWMsTUFBTSxFQUFOQSxNQUFNO1lBQUVtQyxhQUFhLEVBQWJBLGFBQWE7WUFBRWpDLFFBQVEsRUFBUkEsUUFBUTtZQUFFMEMsWUFBWSxFQUFFOUc7VUFDckcsQ0FBQyxDQUFDO1FBQUE7VUFKSStHLGFBQWE7VUFBQTtVQUFBLE9BS1YsSUFBQW5DLDJCQUFnQixFQUFDUCxTQUFTLEVBQUMsU0FBUyxDQUFDO1FBQUE7VUFBQTtZQUFBO1lBQUE7VUFBQTtVQUM5Q1MsVUFBSyxDQUFDQyxNQUFNLENBQUMsb0JBQW9CLEVBQUU7WUFDL0JJLEVBQUUsRUFBRTdCLEtBQUs7WUFDVDhCLFFBQVEsRUFBRXBCLElBQUksR0FBR0EsSUFBSSxDQUFDUyxJQUFJLEdBQUdULElBQUksQ0FBQ1MsSUFBSSxHQUFFLEVBQUUsR0FBRSxFQUFFO1lBQzlDdEUsSUFBSSxFQUFFQSxJQUFJLENBQUNrRixZQUFZO1lBQ3ZCN0IsT0FBTyxFQUFQQSxPQUFPO1lBQ1BJLGdCQUFnQixFQUFoQkEsZ0JBQWdCO1lBQ2hCUyxTQUFTLEVBQVRBO1VBQ0osQ0FBQyxDQUFDLENBQUNXLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUNDLElBQUksRUFBRTtRQUFBO1VBQUE7VUFBQSxPQUV4QyxJQUFBTiwyQkFBZ0IsRUFBQ1AsU0FBUyxFQUFDLFlBQVksQ0FBQztRQUFBO1VBQUE7WUFBQTtZQUFBO1VBQUE7VUFDakRTLFVBQUssQ0FBQ0MsTUFBTSxDQUFDLGVBQWUsRUFBRTtZQUMxQkksRUFBRSxFQUFFN0IsS0FBSztZQUNUbkQsSUFBSSxFQUFFQSxJQUFJLENBQUNrRixZQUFZO1lBQ3ZCN0IsT0FBTyxFQUFQQSxPQUFPO1lBQ1BJLGdCQUFnQixFQUFoQkEsZ0JBQWdCO1lBQ2hCL0QsTUFBTSxFQUFFUyxPQUFPO1lBQ2Y4QyxJQUFJLEVBQUpBLElBQUk7WUFDSmlCLFNBQVMsRUFBVEE7VUFDSixDQUFDLENBQUMsQ0FBQ1csZ0JBQWdCLENBQUMsSUFBSSxDQUFDLENBQUNDLFFBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQ0MsSUFBSSxFQUFFO1FBQUE7VUFHckRoQyxHQUFHLENBQUNwRCxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUN3RixJQUFJLENBQUM7WUFBRUMsT0FBTyxFQUFFLElBQUk7WUFBRUMsT0FBTyxFQUFFLDZCQUE2QjtZQUFFQyxTQUFTLEVBQUUsQ0FBQztZQUFFQyxVQUFVLEVBQUUsSUFBSTtZQUFFQyxTQUFTLEVBQUU7VUFBRSxDQUFDLENBQUM7UUFBQztVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUE7VUFJOUh4RCxPQUFPLENBQUNFLEdBQUcsY0FBSztVQUNoQmMsSUFBSSxjQUFLO1FBQUM7UUFBQTtVQUFBO01BQUE7SUFBQTtFQUFBLENBRWpCO0VBQUEsZ0JBMUhHSCxVQUFVO0lBQUE7RUFBQTtBQUFBLEdBMEhiO0FBQ0QsSUFBTWdFLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDcEUsVUFBVSxDQUFDO0FBQUMsZUFDdkJnRSxTQUFTO0FBQUEifQ==