"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _spamc = _interopRequireDefault(require("spamc"));
var _config = _interopRequireDefault(require("../../config"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _parseEmail = _interopRequireDefault(require("../../service/parse-email"));
var _parseDomains = _interopRequireDefault(require("parse-domains"));
var _getIp = _interopRequireDefault(require("../../service/get-ip"));
var _path = _interopRequireDefault(require("path"));
var _fs = _interopRequireDefault(require("fs"));
var _upload_file = _interopRequireDefault(require("../../Content/upload_file"));
var _getUrls = _interopRequireDefault(require("get-urls"));
var _decodeUriComponent = _interopRequireDefault(require("decode-uri-component"));
var _allowedFeatures = _interopRequireDefault(require("../../service/allowed-features"));
var validator = _joi["default"].object().keys({
  messageId: _joi["default"].string().required(),
  accessToken: _joi["default"].string().required(),
  email: _joi["default"].string().email().required(),
  internetMessageId: _joi["default"].string().required(),
  header: _joi["default"].required(),
  body: _joi["default"].string().required(),
  from: _joi["default"].string().required(),
  subject: _joi["default"].string().required(),
  cc: _joi["default"].string().required(),
  toName: _joi["default"].string().required(),
  bcc: _joi["default"].string().required(),
  mailRecievedTime: _joi["default"].date().required(),
  mimeContent: _joi["default"].string().required()
});
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
/**
 * @api {post} /api/report/report-email report-email
 * @apiName Report Mail
 * @apiGroup Report
 * @apiDescription Report a mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} accessToken       Required accessToken of the mail.
 * @apiBody {String} messageId         Required messageId of the mail.
 * @apiBody {String} email             Required email of the mail.
 *
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String} message    'email reported successfully'
 * 
  * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success":  true,
 *          "message":  'email reported successfully'        
 *      } 
 * 
 * @apiError {Boolean}    success     false
 * @apiError {Boolean}    messages    ["user not exists"]
 * 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "user not exists"
 *           ]
 *       }
 */

var getipAddress = function getipAddress(receivedHeaders) {
  var ip = null;
  receivedHeaders.forEach(function (header) {
    var match = header.match(/\b(?:\d{1,3}\.){3}\d{1,3}\b/);
    if (match) {
      ip = match[0];
    }
  });
  return ip;
};
var stringSearcher = function stringSearcher(str, key) {
  var keyList = [];
  if (typeof key === 'string') keyList.push(key);else if (Array.isArray(key)) keyList = key;
  if (str && str.length > 0) {
    if (key.length == 0) return 'fail';
    var filteredList = keyList.filter(function (iKey) {
      return str.indexOf(iKey) != -1;
    });
    if (filteredList.length > 0) {
      return 'pass';
    } else return 'fail';
  } else {
    return 'fail';
  }
};
var getParseHeader = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(header) {
    var status,
      investigate,
      parseEml,
      from,
      spfDomain,
      parsedDomain,
      fromDomain,
      dkimSiganture,
      search,
      filteredDkimSiganture,
      authResults,
      dkimDomain,
      _yield$getIp$processI,
      country,
      continent,
      _args = arguments;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          status = _args.length > 1 && _args[1] !== undefined ? _args[1] : true;
          _context.prev = 1;
          investigate = {};
          parseEml = header;
          if (!status) {
            _context.next = 8;
            break;
          }
          _context.next = 7;
          return _parseEmail["default"].parseHeader(header);
        case 7:
          parseEml = _context.sent;
        case 8:
          if (!parseEml) {
            _context.next = 44;
            break;
          }
          from = parseEml && parseEml.from && parseEml.from[0].address ? parseEml.from[0].address : '';
          spfDomain = parseEml.headers['return-path'] ? Array.isArray(parseEml.headers['return-path']) ? parseEml.headers['return-path'][0].split("@")[1] : parseEml.headers['return-path'].split("@")[1] : null;
          parsedDomain = from.split('@')[1];
          fromDomain = parsedDomain;
          investigate['spfAllignment'] = fromDomain == spfDomain;
          dkimSiganture = parseEml.headers['dkim-signature'];
          if (Array.isArray(dkimSiganture)) {
            search = "d=".concat(fromDomain);
            filteredDkimSiganture = dkimSiganture.filter(function (r) {
              return r.includes(search);
            });
            if (filteredDkimSiganture.length > 0) dkimSiganture = filteredDkimSiganture[0];else if (dkimSiganture > 0) dkimSiganture = dkimSiganture[0];else dkimSiganture = null;
          }
          authResults = parseEml.headers['authentication-results'];
          authResults = Array.isArray(authResults) && authResults.length > 0 ? authResults.filter(function (r) {
            return r.startsWith('amazonses.com');
          }).join(" ") : authResults;
          dkimDomain = dkimSiganture && dkimSiganture != null ? function () {
            var dIndex = dkimSiganture.search(/d=.*?;/);
            var dValue = dkimSiganture.slice(dIndex + 2, dkimSiganture.indexOf(";", dIndex + 2));
            return dValue;
          }() : null;
          if (!dkimDomain) {
            _context.next = 25;
            break;
          }
          _context.next = 22;
          return (0, _parseDomains["default"])(dkimDomain);
        case 22:
          _context.t0 = _context.sent;
          _context.next = 26;
          break;
        case 25:
          _context.t0 = null;
        case 26:
          parsedDomain = _context.t0;
          dkimDomain = parsedDomain ? "".concat(parsedDomain.domain) : dkimDomain;
          investigate['dkimAllignment'] = fromDomain == dkimDomain;
          _context.next = 31;
          return getipAddress(parseEml.headers['received']);
        case 31:
          investigate['senderIp'] = _context.sent;
          _context.next = 34;
          return _getIp["default"].processIp(investigate['senderIp']);
        case 34:
          _yield$getIp$processI = _context.sent;
          country = _yield$getIp$processI.country;
          continent = _yield$getIp$processI.continent;
          if (country && continent) {
            investigate['country'] = country;
            investigate['continent'] = continent;
          } else {
            investigate['country'] = 'NOT FOUND';
            investigate['continent'] = 'NOT FOUND';
          }
          investigate['spf'] = stringSearcher(authResults, 'spf=pass');
          investigate['dkim'] = stringSearcher(authResults, 'dkim=pass');
          investigate['dmarc'] = stringSearcher(authResults, ['dmarc=pass', 'dmarc=none']);
          return _context.abrupt("return", investigate);
        case 44:
          console.error('error from parsing header details');
          return _context.abrupt("return", {});
        case 46:
          _context.next = 52;
          break;
        case 48:
          _context.prev = 48;
          _context.t1 = _context["catch"](1);
          console.log(_context.t1);
          return _context.abrupt("return", {});
        case 52:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 48]]);
  }));
  return function getParseHeader(_x) {
    return _ref.apply(this, arguments);
  };
}();
var checkUrlsForRid = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(urls) {
    var urlContainsRid, urlsArray, i, url, decodedUrl;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          urlContainsRid = false;
          urlsArray = Array.from(urls);
          i = 0;
        case 4:
          if (!(i < urlsArray.length)) {
            _context2.next = 13;
            break;
          }
          url = urlsArray[i];
          decodedUrl = decodeURIComponent(url);
          if (!(decodedUrl.indexOf('rid=') > -1)) {
            _context2.next = 10;
            break;
          }
          urlContainsRid = decodedUrl;
          return _context2.abrupt("break", 13);
        case 10:
          i++;
          _context2.next = 4;
          break;
        case 13:
          return _context2.abrupt("return", urlContainsRid);
        case 16:
          _context2.prev = 16;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          return _context2.abrupt("return", false);
        case 20:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 16]]);
  }));
  return function checkUrlsForRid(_x2) {
    return _ref2.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res, next) {
    var _req$body, messageId, email, internetMessageId, header, body, from, subject, cc, _req$body$toName, toName, _req$body$bcc, bcc, mailRecievedTime, mimeContent, user, companyRemainingTime, userId, domainId, companyId, domain, isReported, isRecoveredEmail, isTrashedEmail, isDeletedEmail, _id, safe, threat, spam, headers, i, parseEml, tsatUrl, isTsat, _parsedEML$attachment, byteCharacters, fileContent, parsedEML, attachments, filename, urlsInbody, isRidInBody, otherTo, headerDetails, to, emailReported, isGsuite;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _req$body = req.body, messageId = _req$body.messageId, email = _req$body.email, internetMessageId = _req$body.internetMessageId, header = _req$body.header, body = _req$body.body, from = _req$body.from, subject = _req$body.subject, cc = _req$body.cc, _req$body$toName = _req$body.toName, toName = _req$body$toName === void 0 ? '' : _req$body$toName, _req$body$bcc = _req$body.bcc, bcc = _req$body$bcc === void 0 ? [] : _req$body$bcc, mailRecievedTime = _req$body.mailRecievedTime, mimeContent = _req$body.mimeContent;
          console.log({
            messageId: messageId,
            email: email,
            internetMessageId: internetMessageId,
            from: from,
            subject: subject,
            cc: cc,
            toName: toName,
            mailRecievedTime: mailRecievedTime
          });
          console.time("find-user-".concat(messageId));
          email = email.toLowerCase();
          _context3.next = 7;
          return db.User.findOne({
            email: email,
            emailType: "Exchange",
            isActive: true,
            deletedAt: null
          });
        case 7:
          user = _context3.sent;
          console.timeEnd("find-user-".concat(messageId));
          if (user) {
            _context3.next = 11;
            break;
          }
          throw new RequestError('user not exists', 404);
        case 11:
          _context3.next = 13;
          return db.MetaData.findOne({
            name: 'expiredAt',
            companyId: user.companyId
          });
        case 13:
          companyRemainingTime = _context3.sent;
          if (!(new Date() > new Date(companyRemainingTime.value))) {
            _context3.next = 16;
            break;
          }
          throw new RequestError('License expired', 404);
        case 16:
          userId = user._id;
          domainId = user.domainId;
          companyId = user.companyId;
          domain = db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
          if (domain) {
            _context3.next = 22;
            break;
          }
          throw new RequestError('domain not exists', 404);
        case 22:
          _context3.next = 24;
          return db.ReportedMail.findOne({
            internetMessageId: internetMessageId
          });
        case 24:
          isReported = _context3.sent;
          if (!isReported) {
            _context3.next = 45;
            break;
          }
          isRecoveredEmail = isReported.isRecoveredEmail, isTrashedEmail = isReported.isTrashedEmail, isDeletedEmail = isReported.isDeletedEmail, _id = isReported._id;
          safe = isRecoveredEmail === 'false';
          threat = isDeletedEmail === 'false';
          spam = isTrashedEmail === 'false';
          if (!(safe && threat && spam)) {
            _context3.next = 42;
            break;
          }
          _context3.next = 33;
          return db.WhoElse.create({
            to: email,
            from: from.emailAddress,
            subject: subject,
            whoelseMail: email,
            internetMessageId: internetMessageId,
            reportedMailId: _id,
            isTrashed: true,
            messageId: messageId,
            userId: userId,
            domainId: domainId,
            companyId: companyId
          });
        case 33:
          _context3.next = 35;
          return db.ReportedMail.updateOne({
            _id: _id
          }, {
            $push: {
              reporters: {
                email: email
              }
            }
          });
        case 35:
          _context3.next = 37;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 37:
          if (!_context3.sent) {
            _context3.next = 39;
            break;
          }
          _kue.queue.create('send-reported-mail', {
            to: email,
            userName: user ? user.name ? user.name : '' : '',
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 39:
          return _context3.abrupt("return", res.status(200).json({
            success: true,
            message: 'Mail Reported Successfully!',
            reporters: isReported.reporters ? isReported.reporters.length + 2 : 0,
            moveToJunk: true
          }));
        case 42:
          return _context3.abrupt("return", res.status(200).json({
            success: true,
            message: "Mail Already Reported By Someone and has been found ".concat(!safe ? "Safe" : !spam ? "Spam" : "Threat", "!"),
            moveToJunk: !spam || !threat
          }));
        case 43:
          _context3.next = 163;
          break;
        case 45:
          headers = '';
          for (i = 0; i < header.length; i++) {
            headers = headers + header[i].name + ' ' + header[i].value + '\n';
          }
          _context3.next = 49;
          return _parseEmail["default"].parseEml(headers);
        case 49:
          parseEml = _context3.sent;
          _context3.next = 52;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'tsatUrl'
          });
        case 52:
          tsatUrl = _context3.sent;
          _context3.next = 55;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isTsat'
          });
        case 55:
          isTsat = _context3.sent;
          if (!mimeContent) {
            _context3.next = 64;
            break;
          }
          byteCharacters = Buffer.from(mimeContent, 'base64');
          fileContent = byteCharacters.toString('binary');
          _context3.next = 61;
          return _parseEmail["default"].parseEml(fileContent);
        case 61:
          parsedEML = _context3.sent;
          attachments = (_parsedEML$attachment = parsedEML === null || parsedEML === void 0 ? void 0 : parsedEML.attachments) !== null && _parsedEML$attachment !== void 0 ? _parsedEML$attachment : [];
          filename = Date.now() + '.eml'; // var writeStream = fs.createWriteStream(filePath);
          // writeStream.write(Buffer.from(fileContent, 'binary'))
        case 64:
          _context3.next = 66;
          return (0, _getUrls["default"])(body);
        case 66:
          urlsInbody = _context3.sent;
          isRidInBody = false;
          if (!(urlsInbody.size > 0)) {
            _context3.next = 72;
            break;
          }
          _context3.next = 71;
          return checkUrlsForRid(urlsInbody);
        case 71:
          isRidInBody = _context3.sent;
        case 72:
          _context3.next = 74;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-TSAT");
        case 74:
          _context3.t2 = _context3.sent;
          if (!_context3.t2) {
            _context3.next = 77;
            break;
          }
          _context3.t2 = isRidInBody != false;
        case 77:
          _context3.t1 = _context3.t2;
          if (!_context3.t1) {
            _context3.next = 80;
            break;
          }
          _context3.t1 = isTsat.value === 'true';
        case 80:
          _context3.t0 = _context3.t1;
          if (!_context3.t0) {
            _context3.next = 83;
            break;
          }
          _context3.t0 = tsatUrl;
        case 83:
          if (!_context3.t0) {
            _context3.next = 101;
            break;
          }
          // call to tsat for email reporting

          _kue.queue.create('route-email-tsat', {
            header: JSON.stringify(header),
            body: (0, _decodeUriComponent["default"])("".concat(body)),
            tsatUrl: tsatUrl
          }).removeOnComplete(true).priority('high').save();
          _context3.next = 87;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 87:
          if (!_context3.sent) {
            _context3.next = 89;
            break;
          }
          _kue.queue.create('send-reported-mail', {
            to: email,
            userName: user ? user.name ? user.name : '' : '',
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 89:
          if (!mimeContent) {
            _context3.next = 96;
            break;
          }
          _context3.next = 92;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
        case 92:
          if (!_context3.sent) {
            _context3.next = 94;
            break;
          }
          _kue.queue.create('send-soc-mail', {
            to: email,
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            header: '',
            body: '',
            companyId: companyId,
            attachment: true,
            fileContent: fileContent
          }).removeOnComplete(true).priority('high').save();
        case 94:
          _context3.next = 100;
          break;
        case 96:
          _context3.next = 98;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
        case 98:
          if (!_context3.sent) {
            _context3.next = 100;
            break;
          }
          _kue.queue.create('send-soc-mail', {
            to: email,
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            header: headers,
            body: body,
            companyId: companyId
          }).removeOnComplete(true).priority('high').save();
        case 100:
          return _context3.abrupt("return", res.status(200).json({
            success: true,
            message: 'email reported successfully',
            moveToJunk: true
          }));
        case 101:
          otherTo = [];
          _context3.next = 104;
          return getParseHeader(headers);
        case 104:
          headerDetails = _context3.sent;
          to = email.toLowerCase();
          _context3.t3 = db.ReportedMail;
          _context3.t4 = from.emailAddress;
          _context3.t5 = from.displayName;
          _context3.t6 = to;
          _context3.t7 = user.name;
          _context3.t8 = subject;
          _context3.t9 = messageId;
          _context3.t10 = cc;
          _context3.t11 = bcc;
          _context3.t12 = otherTo;
          _context3.t13 = messageId;
          _context3.t14 = internetMessageId;
          _context3.t15 = mailRecievedTime;
          _context3.t16 = companyId;
          _context3.t17 = filename;
          _context3.t18 = userId;
          _context3.next = 124;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-SDD");
        case 124:
          if (!_context3.sent) {
            _context3.next = 128;
            break;
          }
          _context3.t19 = headerDetails;
          _context3.next = 129;
          break;
        case 128:
          _context3.t19 = null;
        case 129:
          _context3.t20 = _context3.t19;
          _context3.t21 = domainId;
          _context3.t22 = {
            from: _context3.t4,
            fromName: _context3.t5,
            to: _context3.t6,
            toName: _context3.t7,
            subject: _context3.t8,
            mailId: _context3.t9,
            cc: _context3.t10,
            bcc: _context3.t11,
            otherTo: _context3.t12,
            messageId: _context3.t13,
            internetMessageId: _context3.t14,
            mailRecievedTime: _context3.t15,
            companyId: _context3.t16,
            fileName: _context3.t17,
            mailType: "Exchange",
            header: '',
            body: '',
            userId: _context3.t18,
            headerDetails: _context3.t20,
            domainId: _context3.t21,
            parsedHeader: ''
          };
          _context3.next = 134;
          return _context3.t3.create.call(_context3.t3, _context3.t22);
        case 134:
          emailReported = _context3.sent;
          _upload_file["default"].uploadReportedMail({
            _id: emailReported._id,
            header: headers,
            body: body,
            parsedHeader: parseEml
          });
          _kue.queue.create('upload-siem-logs', {
            to: email,
            from: from.emailAddress,
            subject: subject,
            companyId: companyId,
            mailRecievedTime: mailRecievedTime,
            spf: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.spf,
            internetMessageId: internetMessageId,
            dmarc: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.dmarc,
            dkim: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.dkim,
            senderIp: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.senderIp
          }).removeOnComplete(true).priority('high').save();
          if (!mimeContent) {
            _context3.next = 144;
            break;
          }
          isGsuite = false;
          _kue.queue.create('email-reported-attachments-gsuite', {
            attachments: attachments,
            companyId: companyId,
            reportedMailId: emailReported._id
          }).removeOnComplete(true).priority('high').save();
          // queue.create('send-soc-mail', {
          //     to: email,
          //     from: from.emailAddress,
          //     subject,
          //     mailRecievedTime,
          // header: '',
          //     body: '',
          //     companyId,
          //     attachment: true,
          //     filename:fileContent,
          //     isGsuite: false
          // }).removeOnComplete(true).priority('high').save()
          _context3.next = 142;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
        case 142:
          if (!_context3.sent) {
            _context3.next = 144;
            break;
          }
          _kue.queue.create('send-soc-mail', {
            to: email,
            from: from.emailAddress ? from.emailAddress : from.displayName ? from.displayName : '',
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            header: headers,
            body: body,
            companyId: companyId,
            isGsuite: false
          }).removeOnComplete(true).priority('high').save();
        case 144:
          _kue.queue.create('email-language', {
            body: body,
            reportedMailId: emailReported._id
          }).removeOnComplete(true).priority('high').save();
          _context3.next = 147;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 147:
          if (!_context3.sent) {
            _context3.next = 149;
            break;
          }
          _kue.queue.create("send-reported-mail", {
            to: email,
            userName: user ? user.name ? user.name : "" : "",
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            companyId: companyId
          }).removeOnComplete(true).priority("high").save();
        case 149:
          _context3.next = 151;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-SSRE");
        case 151:
          if (!_context3.sent) {
            _context3.next = 153;
            break;
          }
          _kue.queue.create('report-email-score-exchange', {
            headers: headers,
            reportedMailId: emailReported._id
          }).removeOnComplete(true).priority('high').save();
        case 153:
          if (mimeContent) {
            _context3.next = 158;
            break;
          }
          _context3.next = 156;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
        case 156:
          if (!_context3.sent) {
            _context3.next = 158;
            break;
          }
          _kue.queue.create("send-soc-mail", {
            to: email,
            from: from.emailAddress,
            subject: subject,
            mailRecievedTime: mailRecievedTime,
            header: headers,
            body: body,
            companyId: companyId,
            isGsuite: false
          }).removeOnComplete(true).priority("high").save();
        case 158:
          _kue.queue.create('check-sender-domain-deceptive', {
            from: from.emailAddress,
            reportedMailId: emailReported._id
          }).removeOnComplete(true).priority('high').save();
          _kue.queue.create('email-reported-url', {
            body: body,
            companyId: companyId,
            reportedMailId: emailReported._id
          }).removeOnComplete(true).priority('high').save();
          console.log({
            headerDetails: headerDetails
          });
          if (headerDetails !== null && headerDetails !== void 0 && headerDetails.senderIp) {
            console.log("dnsbl se uparrrr");
            _kue.queue.create('process-dnsbl', {
              reportedMailId: emailReported._id,
              senderIp: headerDetails.senderIp
            }).removeOnComplete(true).save();
          }
          res.status(200).json({
            success: true,
            message: 'email reported successfully',
            reporters: 1,
            moveToJunk: true
          });
        case 163:
          _context3.next = 169;
          break;
        case 165:
          _context3.prev = 165;
          _context3.t23 = _context3["catch"](0);
          console.log(_context3.t23);
          next(_context3.t23);
        case 169:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 165]]);
  }));
  return function controller(_x3, _x4, _x5) {
    return _ref3.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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