"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _getMailData = _interopRequireDefault(require("../../service/get-mail-data"));
var _spamc = _interopRequireDefault(require("spamc"));
var _config = _interopRequireDefault(require("../../config"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _getUrls = _interopRequireDefault(require("get-urls"));
var _decodeUriComponent = _interopRequireDefault(require("decode-uri-component"));
var _allowedFeatures = _interopRequireDefault(require("../../service/allowed-features"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _mailer = _interopRequireDefault(require("../../mailer"));
// let validator = Joi.object().keys({
//     messageId: Joi.string().required(),
//     email: Joi.string().email().required(),
//     internetMessageId: Joi.string().required(), 
//     headers: Joi.string().required(), 
//     body: Joi.string().required()
// });

var checkUrlsForRid = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(urls) {
    var urlContainsRid, urlsArray, i, url, decodedUrl;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          urlContainsRid = false;
          urlsArray = Array.from(urls);
          i = 0;
        case 4:
          if (!(i < urlsArray.length)) {
            _context.next = 13;
            break;
          }
          url = urlsArray[i];
          decodedUrl = decodeURIComponent(url);
          if (!(decodedUrl.indexOf('rid=') > -1)) {
            _context.next = 10;
            break;
          }
          urlContainsRid = decodedUrl;
          return _context.abrupt("break", 13);
        case 10:
          i++;
          _context.next = 4;
          break;
        case 13:
          return _context.abrupt("return", urlContainsRid);
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", false);
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function checkUrlsForRid(_x) {
    return _ref.apply(this, arguments);
  };
}();
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
/**
 * @api {post} /api/report/report-email report-email
 * @apiName Report Mail
 * @apiGroup Report
 * @apiDescription Report a mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} accessToken       Required accessToken of the mail.
 * @apiBody {String} messageId         Required messageId of the mail.
 * @apiBody {String} email             Required email of the mail.
 *
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String} message    'email reported successfully'
 * 
  * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success":  true,
 *          "message":  'email reported successfully'        
 *      } 
 * 
 * @apiError {Boolean}    success     false
 * @apiError {Boolean}    messages    ["user not exists"]
 * 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "user not exists"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res, next) {
    var _req$body, messageId, email, internetMessageId, headers, body, user, companyRemainingTime, userId, domainId, companyId, domain, isReported, tsatUrl, isTsat, isTsatMail, urlsInbody, isRidInBody;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _req$body = req.body, messageId = _req$body.messageId, email = _req$body.email, internetMessageId = _req$body.internetMessageId, headers = _req$body.headers, body = _req$body.body;
          _context3.next = 4;
          return db.User.findOne({
            email: email.toLowerCase(),
            isActive: true,
            emailType: "Outlook",
            deletedAt: null
          });
        case 4:
          user = _context3.sent;
          if (user) {
            _context3.next = 7;
            break;
          }
          throw new RequestError('user not exists', 404);
        case 7:
          console.log(user);
          _context3.next = 10;
          return db.MetaData.findOne({
            name: 'expiredAt',
            companyId: user.companyId
          });
        case 10:
          companyRemainingTime = _context3.sent;
          console.log({
            companyRemainingTime: companyRemainingTime
          });
          if (!(new Date() > new Date(companyRemainingTime.value))) {
            _context3.next = 14;
            break;
          }
          throw new RequestError('License expired', 404);
        case 14:
          userId = user._id;
          domainId = user.domainId;
          companyId = user.companyId;
          _context3.next = 19;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 19:
          domain = _context3.sent;
          console.log(domain);
          if (domain) {
            _context3.next = 23;
            break;
          }
          throw new RequestError('domain not exists', 404);
        case 23:
          _context3.next = 25;
          return db.ReportedMail.findOne({
            internetMessageId: internetMessageId
          });
        case 25:
          isReported = _context3.sent;
          if (!isReported) {
            _context3.next = 36;
            break;
          }
          _context3.next = 29;
          return db.ReportedMail.updateOne({
            _id: isReported._id
          }, {
            $push: {
              reporters: {
                email: email
              }
            }
          });
        case 29:
          _context3.next = 31;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
        case 31:
          if (!_context3.sent) {
            _context3.next = 33;
            break;
          }
          _mailer["default"].sendAlreadyReportedMail(user.name, email, companyId);
        case 33:
          res.status(200).json({
            success: true,
            reporters: isReported.reporters ? isReported.reporters.length + 2 : 0,
            spamScore: isReported.spamScore,
            moveToJunk: true,
            message: 'email reported successfully'
          });
          _context3.next = 66;
          break;
        case 36:
          _context3.next = 38;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'tsatUrl'
          });
        case 38:
          tsatUrl = _context3.sent;
          _context3.next = 41;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isTsat'
          });
        case 41:
          isTsat = _context3.sent;
          isTsatMail = isTsat.value === 'true';
          _context3.next = 45;
          return (0, _getUrls["default"])(body);
        case 45:
          urlsInbody = _context3.sent;
          isRidInBody = false;
          if (!(urlsInbody.size > 0)) {
            _context3.next = 51;
            break;
          }
          _context3.next = 50;
          return checkUrlsForRid(urlsInbody);
        case 50:
          isRidInBody = _context3.sent;
        case 51:
          _context3.next = 53;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-TSAT");
        case 53:
          _context3.t2 = _context3.sent;
          if (!_context3.t2) {
            _context3.next = 56;
            break;
          }
          _context3.t2 = isRidInBody != false;
        case 56:
          _context3.t1 = _context3.t2;
          if (!_context3.t1) {
            _context3.next = 59;
            break;
          }
          _context3.t1 = isTsatMail;
        case 59:
          _context3.t0 = _context3.t1;
          if (!_context3.t0) {
            _context3.next = 62;
            break;
          }
          _context3.t0 = tsatUrl.value;
        case 62:
          if (!_context3.t0) {
            _context3.next = 65;
            break;
          }
          // call to tsat for email reporting
          _kue.queue.create('route-email-tsat', {
            header: headers,
            body: (0, _decodeUriComponent["default"])("".concat(body)),
            tsatUrl: tsatUrl
          }).removeOnComplete(true).priority('high').save();
          return _context3.abrupt("return", res.status(200).json({
            success: true,
            message: 'email reported successfully',
            reporters: 1,
            moveToJunk: true,
            spamScore: 5
          }));
        case 65:
          new Promise( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(resolve, reject) {
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    console.time('spamassession');
                    _context2.next = 3;
                    return (0, _allowedFeatures["default"])(companyId, "TPIR-SSRE");
                  case 3:
                    if (!_context2.sent) {
                      _context2.next = 7;
                      break;
                    }
                    spamc.headers(headers, function (err, result) {
                      if (err) reject(err);else resolve(result);
                    });
                    _context2.next = 8;
                    break;
                  case 7:
                    resolve(0);
                  case 8:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x5, _x6) {
              return _ref3.apply(this, arguments);
            };
          }()).then(function (result) {
            console.log("SpamScore---->", result);
            console.timeEnd('spamassession');
            _kue.queue.create('reported-email-outlook', {
              email: email,
              header: headers,
              body: body,
              eml: headers,
              userId: userId,
              userName: user ? user.name ? user.name : '' : '',
              domainId: domainId,
              companyId: companyId,
              messageId: messageId,
              internetMessageId: internetMessageId,
              attachments: [],
              folderId: '',
              spamScore: result && result.spamScore ? result.spamScore : 0,
              isTsatMail: isRidInBody != false
            }).removeOnComplete(true).priority('high').save();
            res.status(200).json({
              success: true,
              message: 'email reported successfully',
              reporters: 1,
              moveToJunk: true,
              spamScore: result && result.spamScore ? result.spamScore : 0
            });
          });
        case 66:
          _context3.next = 72;
          break;
        case 68:
          _context3.prev = 68;
          _context3.t3 = _context3["catch"](0);
          console.log(_context3.t3);
          next(_context3.t3);
        case 72:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 68]]);
  }));
  return function controller(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(
// validateBody(validator),
controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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