"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _getMailData = _interopRequireDefault(require("../../service/get-mail-data"));
var _spamc = _interopRequireDefault(require("spamc"));
var _config = _interopRequireDefault(require("../../config"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _getUrls = _interopRequireDefault(require("get-urls"));
var _decodeUriComponent = _interopRequireDefault(require("decode-uri-component"));
var _allowedFeatures = _interopRequireDefault(require("../../service/allowed-features"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
// let validator = Joi.object().keys({
//     messageId: Joi.string().required(),
//     accessToken: Joi.string().allow(null).required(),
//     email: Joi.string().email().required(),
//     internetMessageId: Joi.string().required(),
// });

var checkUrlsForRid = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(urls) {
    var urlContainsRid, urlsArray, i, url, decodedUrl;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          urlContainsRid = false;
          urlsArray = Array.from(urls);
          i = 0;
        case 4:
          if (!(i < urlsArray.length)) {
            _context.next = 13;
            break;
          }
          url = urlsArray[i];
          decodedUrl = decodeURIComponent(url);
          if (!(decodedUrl.indexOf('rid=') > -1)) {
            _context.next = 10;
            break;
          }
          urlContainsRid = decodedUrl;
          return _context.abrupt("break", 13);
        case 10:
          i++;
          _context.next = 4;
          break;
        case 13:
          return _context.abrupt("return", urlContainsRid);
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", false);
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function checkUrlsForRid(_x) {
    return _ref.apply(this, arguments);
  };
}();
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
/**
 * @api {post} /api/report/report-email report-email
 * @apiName Report Mail
 * @apiGroup Report
 * @apiDescription Report a mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} accessToken       Required accessToken of the mail.
 * @apiBody {String} messageId         Required messageId of the mail.
 * @apiBody {String} email             Required email of the mail.
 *
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String} message    'email reported successfully'
 * 
  * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success":  true,
 *          "message":  'email reported successfully'        
 *      } 
 * 
 * @apiError {Boolean}    success     false
 * @apiError {Boolean}    messages    ["user not exists"]
 * 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "user not exists"
 *           ]
 *       }
 */

var moveEmailToJunkWithDelay = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(messageId, accessToken, email) {
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          setTimeout( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
            return _regenerator["default"].wrap(function _callee2$(_context2) {
              while (1) switch (_context2.prev = _context2.next) {
                case 0:
                  _context2.prev = 0;
                  _context2.next = 3;
                  return _getMailData["default"].moveEmailToJunk(messageId, accessToken, email);
                case 3:
                  console.log("Email moved to Junk for ".concat(email));
                  _context2.next = 9;
                  break;
                case 6:
                  _context2.prev = 6;
                  _context2.t0 = _context2["catch"](0);
                  console.error("Error moving email:", _context2.t0);
                case 9:
                case "end":
                  return _context2.stop();
              }
            }, _callee2, null, [[0, 6]]);
          })), 8000);
        case 1:
        case "end":
          return _context3.stop();
      }
    }, _callee3);
  }));
  return function moveEmailToJunkWithDelay(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(req, res, next) {
    var _req$body, _req$body$accessToken, accessToken, messageId, email, internetMessageId, user, companyRemainingTime, userId, domainId, companyId, domain, useGraph, _yield$credentials$ge, token, folderId, isReported, header, body, attachments, eml, tsatUrl, isTsat, isTsatMail, urlsInbody, isRidInBody;
    return _regenerator["default"].wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _req$body = req.body, _req$body$accessToken = _req$body.accessToken, accessToken = _req$body$accessToken === void 0 ? null : _req$body$accessToken, messageId = _req$body.messageId, email = _req$body.email, internetMessageId = _req$body.internetMessageId;
          _context5.next = 4;
          return db.User.findOne({
            email: email.toLowerCase(),
            isActive: true,
            emailType: "Outlook",
            deletedAt: null
          });
        case 4:
          user = _context5.sent;
          if (user) {
            _context5.next = 7;
            break;
          }
          throw new RequestError('user not exists', 404);
        case 7:
          console.log(user);
          _context5.next = 10;
          return db.MetaData.findOne({
            name: 'expiredAt',
            companyId: user.companyId
          });
        case 10:
          companyRemainingTime = _context5.sent;
          console.log({
            companyRemainingTime: companyRemainingTime
          });
          if (!(new Date() > new Date(companyRemainingTime.value))) {
            _context5.next = 14;
            break;
          }
          throw new RequestError('License expired', 404);
        case 14:
          userId = user._id;
          domainId = user.domainId;
          companyId = user.companyId;
          _context5.next = 19;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 19:
          domain = _context5.sent;
          console.log(domain);
          if (domain) {
            _context5.next = 23;
            break;
          }
          throw new RequestError('domain not exists', 404);
        case 23:
          useGraph = false;
          if (accessToken) {
            _context5.next = 31;
            break;
          }
          _context5.next = 27;
          return _credentials["default"].getCredentials(companyId, domainId);
        case 27:
          _yield$credentials$ge = _context5.sent;
          token = _yield$credentials$ge.token;
          accessToken = token.access_token;
          useGraph = true;
        case 31:
          folderId = '';
          if (!useGraph) {
            _context5.next = 38;
            break;
          }
          _context5.next = 35;
          return _getMailData["default"].processFolderIdGraph(messageId, accessToken, email);
        case 35:
          folderId = _context5.sent;
          _context5.next = 41;
          break;
        case 38:
          _context5.next = 40;
          return _getMailData["default"].processFolderId(messageId, accessToken);
        case 40:
          folderId = _context5.sent;
        case 41:
          _context5.next = 43;
          return db.ReportedMail.findOne({
            internetMessageId: internetMessageId
          });
        case 43:
          isReported = _context5.sent;
          if (!isReported) {
            _context5.next = 54;
            break;
          }
          if (!(isReported.isRecoveredEmail === 'false')) {
            _context5.next = 51;
            break;
          }
          _kue.queue.create('process-trash-request-reported-email', {
            companyId: companyId,
            name: user.name,
            email: email,
            domainId: domainId,
            internetMessageId: internetMessageId,
            isReported: isReported,
            folderId: folderId
          }).delay(2500).removeOnComplete(true).priority('high').save();
          moveEmailToJunkWithDelay(messageId, accessToken, email);
          res.status(200).json({
            success: true,
            reporters: isReported.reporters ? isReported.reporters.length + 2 : 0,
            spamScore: isReported.spamScore,
            moveToJunk: true
          });
          _context5.next = 52;
          break;
        case 51:
          return _context5.abrupt("return", res.status(200).json({
            success: true,
            message: 'Email already reported by someone and has been found safe!',
            moveToJunk: false
          }));
        case 52:
          _context5.next = 113;
          break;
        case 54:
          console.time("process mail body ".concat(userId));
          if (!useGraph) {
            _context5.next = 69;
            break;
          }
          _context5.next = 58;
          return _getMailData["default"].processEmlGraph(messageId, accessToken, email);
        case 58:
          eml = _context5.sent;
          header = eml;
          _context5.next = 62;
          return _getMailData["default"].processBodyGraph(messageId, accessToken, email);
        case 62:
          body = _context5.sent;
          _context5.next = 65;
          return _getMailData["default"].processAttachmentsGraph(messageId, accessToken, email);
        case 65:
          attachments = _context5.sent;
          moveEmailToJunkWithDelay(messageId, accessToken, email);
          _context5.next = 82;
          break;
        case 69:
          _context5.next = 71;
          return _getMailData["default"].processHeader(messageId, accessToken);
        case 71:
          header = _context5.sent;
          _context5.next = 74;
          return _getMailData["default"].processBody(messageId, accessToken);
        case 74:
          body = _context5.sent;
          _context5.next = 77;
          return _getMailData["default"].processAttachments(messageId, accessToken);
        case 77:
          attachments = _context5.sent;
          _context5.next = 80;
          return _getMailData["default"].processEml(messageId, accessToken);
        case 80:
          eml = _context5.sent;
          moveEmailToJunkWithDelay(messageId, accessToken, email);
        case 82:
          console.timeEnd("process mail body ".concat(userId));
          _context5.next = 85;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'tsatUrl'
          });
        case 85:
          tsatUrl = _context5.sent;
          _context5.next = 88;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isTsat'
          });
        case 88:
          isTsat = _context5.sent;
          isTsatMail = isTsat.value === 'true';
          _context5.next = 92;
          return (0, _getUrls["default"])(body);
        case 92:
          urlsInbody = _context5.sent;
          isRidInBody = false;
          if (!(urlsInbody.size > 0)) {
            _context5.next = 98;
            break;
          }
          _context5.next = 97;
          return checkUrlsForRid(urlsInbody);
        case 97:
          isRidInBody = _context5.sent;
        case 98:
          _context5.next = 100;
          return (0, _allowedFeatures["default"])(companyId, "TPIR-TSAT");
        case 100:
          _context5.t2 = _context5.sent;
          if (!_context5.t2) {
            _context5.next = 103;
            break;
          }
          _context5.t2 = isRidInBody != false;
        case 103:
          _context5.t1 = _context5.t2;
          if (!_context5.t1) {
            _context5.next = 106;
            break;
          }
          _context5.t1 = isTsatMail;
        case 106:
          _context5.t0 = _context5.t1;
          if (!_context5.t0) {
            _context5.next = 109;
            break;
          }
          _context5.t0 = tsatUrl.value;
        case 109:
          if (!_context5.t0) {
            _context5.next = 112;
            break;
          }
          // call to tsat for email reporting
          _kue.queue.create('route-email-tsat', {
            header: header,
            body: (0, _decodeUriComponent["default"])("".concat(body)),
            tsatUrl: tsatUrl
          }).removeOnComplete(true).priority('high').save();
          return _context5.abrupt("return", res.status(200).json({
            success: true,
            message: 'email reported successfully',
            reporters: 1,
            moveToJunk: true,
            spamScore: 5
          }));
        case 112:
          new Promise( /*#__PURE__*/function () {
            var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(resolve, reject) {
              return _regenerator["default"].wrap(function _callee4$(_context4) {
                while (1) switch (_context4.prev = _context4.next) {
                  case 0:
                    console.time('spamassession');
                    _context4.next = 3;
                    return (0, _allowedFeatures["default"])(companyId, "TPIR-SSRE");
                  case 3:
                    if (!_context4.sent) {
                      _context4.next = 7;
                      break;
                    }
                    spamc.headers(header, function (err, result) {
                      if (err) reject(err);else resolve(result);
                    });
                    _context4.next = 8;
                    break;
                  case 7:
                    resolve(0);
                  case 8:
                  case "end":
                    return _context4.stop();
                }
              }, _callee4);
            }));
            return function (_x8, _x9) {
              return _ref5.apply(this, arguments);
            };
          }()).then(function (result) {
            console.log("SpamScore---->", result);
            console.timeEnd('spamassession');
            _kue.queue.create('reported-email-outlook', {
              email: email,
              header: header,
              body: body,
              eml: eml,
              userId: userId,
              userName: user ? user.name ? user.name : '' : '',
              domainId: domainId,
              companyId: companyId,
              messageId: messageId,
              internetMessageId: internetMessageId,
              attachments: attachments,
              folderId: folderId,
              spamScore: result && result.spamScore ? result.spamScore : 0,
              isTsatMail: isRidInBody != false
            }).removeOnComplete(true).priority('high').save();
            res.status(200).json({
              success: true,
              message: 'email reported successfully',
              reporters: 1,
              moveToJunk: true,
              spamScore: result && result.spamScore ? result.spamScore : 0
            });
          });
        case 113:
          _context5.next = 119;
          break;
        case 115:
          _context5.prev = 115;
          _context5.t3 = _context5["catch"](0);
          console.log(_context5.t3);
          next(_context5.t3);
        case 119:
        case "end":
          return _context5.stop();
      }
    }, _callee5, null, [[0, 115]]);
  }));
  return function controller(_x5, _x6, _x7) {
    return _ref4.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(
// validateBody(validator), 
controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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