"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _kue = require("../../kue");
var _strategy = require("../../middlewares/strategy");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object({
  reportedMailId: _joi["default"].string().hex().length(24).required()
});
var createBulkInsertMeta = function createBulkInsertMeta(domains, reportedMailId) {
  return domains.filter(function (domain) {
    return (domain.domainType === 'Outlook' || domain.domainType === 'Gsuite') && domain.domainTypeForOutlook !== 'EXCHANGE' && domain.isCredential;
  }).map(function (domain) {
    return {
      isProcessing: false,
      isCompleted: false,
      reportedMailId: reportedMailId,
      domainId: domain._id,
      companyId: domain.companyId
    };
  });
};
var queueEmailJobs = function queueEmailJobs(domains, update) {
  domains.forEach(function (domain) {
    if (domain.isCredential) {
      if (domain.domainType == 'Outlook' && domain.domainTypeForOutlook != "EXCHANGE") {
        _kue.queue.create('email-reported-similiar-emails-outlook', {
          reportedMailId: update._id,
          internetMessageId: update.internetMessageId,
          domainId: domain._id,
          companyId: update.companyId,
          subject: update.subject,
          from: update.from,
          email: update.to
        }).removeOnComplete(true).priority('high').save();
      } else if (domain.domainType == 'Gsuite') {
        _kue.queue.create('email-reported-similiar-emails-gsuite', {
          reportedMailId: update._id,
          internetMessageId: update.internetMessageId,
          domainId: domain._id,
          companyId: update.companyId,
          subject: update.subject,
          from: update.from,
          email: update.to
        }).removeOnComplete(true).priority('high').save();
      }
    }
  });
};
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var reportedMailId, companyId, reportedMail, sanitizedSubject, domains, updateFields, update, bulkInsertMeta;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          reportedMailId = req.body.reportedMailId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId
          });
        case 5:
          reportedMail = _context.sent;
          if (reportedMail) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Mail not found!');
        case 8:
          if (!(!reportedMail || !reportedMail.subject || !reportedMail.subject.length > 0)) {
            _context.next = 10;
            break;
          }
          throw new RequestError('Subject is empty!');
        case 10:
          sanitizedSubject = (0, _functions.cleanDictionaryAndSpecialChars)(reportedMail === null || reportedMail === void 0 ? void 0 : reportedMail.subject);
          if (!(sanitizedSubject.trim() === '')) {
            _context.next = 17;
            break;
          }
          _context.next = 14;
          return db.ReportedMail.updateOne({
            _id: reportedMail._id,
            companyId: companyId
          }, {
            syncEndAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailProcessing: false,
            isSimiliarEmailErrorMessage: '',
            isSimiliarEmailCompleted: true
          });
        case 14:
          _context.next = 16;
          return (0, _functions.updateReportedMailCache)(reportedMailId, {
            isSimiliarEmailProcessing: false,
            isSimiliarEmailCompleted: true,
            syncStartAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailErrorMessage: ''
          });
        case 16:
          return _context.abrupt("return", res.status(200).json({
            success: true
          }));
        case 17:
          if (!reportedMail.isSimiliarEmailProcessing) {
            _context.next = 19;
            break;
          }
          throw new RequestError('Similiar Email search already in progress!');
        case 19:
          _context.next = 21;
          return db.Domain.find({
            companyId: companyId,
            isCredential: true,
            deletedAt: null
          });
        case 21:
          domains = _context.sent;
          if (domains) {
            _context.next = 24;
            break;
          }
          throw new RequestError('Domain not found!');
        case 24:
          updateFields = {
            isSimiliarEmailProcessing: true,
            syncStartAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailErrorMessage: ''
          };
          _context.next = 27;
          return db.ReportedMail.findOneAndUpdate({
            _id: reportedMailId
          }, {
            $set: updateFields
          }, {
            "new": true
          });
        case 27:
          update = _context.sent;
          _context.next = 30;
          return (0, _functions.updateReportedMailCache)(reportedMailId, {
            isSimiliarEmailProcessing: true,
            syncStartAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailErrorMessage: ''
          });
        case 30:
          bulkInsertMeta = createBulkInsertMeta(domains, reportedMailId);
          if (!(bulkInsertMeta.length > 0)) {
            _context.next = 41;
            break;
          }
          _context.prev = 32;
          _context.next = 35;
          return db.SimiliarEmailMetdata.insertMany(bulkInsertMeta);
        case 35:
          console.log('Metadata created successfully');
          _context.next = 41;
          break;
        case 38:
          _context.prev = 38;
          _context.t0 = _context["catch"](32);
          console.error('Error creating metadata for similar emails', _context.t0);
        case 41:
          queueEmailJobs(domains, update);
          res.status(200).json({
            success: true
          });
          _context.next = 52;
          break;
        case 45:
          _context.prev = 45;
          _context.t1 = _context["catch"](0);
          console.error(_context.t1);
          if (!(_context.t1 instanceof RequestError)) {
            _context.next = 51;
            break;
          }
          _context.next = 51;
          return db.ReportedMail.updateOne({
            _id: req.body.reportedMailId,
            companyId: req.user.companyId
          }, {
            syncEndAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailProcessing: false,
            isSimiliarEmailErrorMessage: '',
            isSimiliarEmailCompleted: true
          });
        case 51:
          next(_context.t1);
        case 52:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 45], [32, 38]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _featureBlocker["default"])("TPIR-FSEI"), (0, _permission.permission)("Emails", "Write"), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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