"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _kue = require("../../kue");
var _outlookWebhookEmailServices = require("../../service/outlook-webhook-email-services");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _iterator, _step, _loop;
    return _regenerator["default"].wrap(function _callee$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          if (!req.query.validationToken) {
            _context2.next = 4;
            break;
          }
          console.log("Received validation request:", req.query.validationToken);
          return _context2.abrupt("return", res.status(200).send(req.query.validationToken));
        case 4:
          _iterator = _createForOfIteratorHelper(req.body.value);
          _context2.prev = 5;
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var event, subscriptionId, clientState, resource, resourceData, companyId, domainId, webhookRetrievalEmail, _clientState$split, _clientState$split2, messageId, credential, from, user;
            return _regenerator["default"].wrap(function _loop$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  event = _step.value;
                  subscriptionId = event.subscriptionId, clientState = event.clientState, resource = event.resource, resourceData = event.resourceData;
                  _context.prev = 2;
                  _clientState$split = clientState.split('-');
                  _clientState$split2 = (0, _slicedToArray2["default"])(_clientState$split, 3);
                  companyId = _clientState$split2[0];
                  domainId = _clientState$split2[1];
                  webhookRetrievalEmail = _clientState$split2[2];
                  if (!(!companyId || !domainId || !webhookRetrievalEmail)) {
                    _context.next = 10;
                    break;
                  }
                  throw new Error("Invalid clientState format");
                case 10:
                  _context.next = 16;
                  break;
                case 12:
                  _context.prev = 12;
                  _context.t0 = _context["catch"](2);
                  console.error("Error parsing clientState:", _context.t0.message, clientState);
                  throw new RequestError("Error parsing clientState:", _context.t0.message, clientState);
                case 16:
                  console.log("\uD83D\uDD39 Webhook for Company: ".concat(companyId, ", Domain: ").concat(domainId, ", Email: ").concat(webhookRetrievalEmail));
                  console.log("\uD83D\uDD39 Subscription ID: ".concat(subscriptionId, ", Resource: ").concat(resource));
                  messageId = resourceData === null || resourceData === void 0 ? void 0 : resourceData.id;
                  if (messageId) {
                    _context.next = 22;
                    break;
                  }
                  console.warn("No message ID found in webhook data. Skipping.");
                  throw new RequestError("No message ID found in webhook data. Skipping");
                case 22:
                  _context.next = 24;
                  return _credentials["default"].getCredentials(companyId, domainId);
                case 24:
                  credential = _context.sent;
                  if (credential) {
                    _context.next = 28;
                    break;
                  }
                  console.error("Failed to retrieve access token.");
                  throw new RequestError("Failed to retrieve access token.");
                case 28:
                  _context.next = 30;
                  return (0, _outlookWebhookEmailServices.getSenderEmail)(webhookRetrievalEmail, messageId, credential.token.access_token);
                case 30:
                  from = _context.sent;
                  if (from) {
                    _context.next = 34;
                    break;
                  }
                  console.warn("No sender email found for message ".concat(messageId, ". Skipping."));
                  throw new RequestError("No sender email found for message ".concat(messageId, ". Skipping."));
                case 34:
                  _context.next = 36;
                  return db.User.findOne({
                    email: from.toLowerCase(),
                    isActive: true,
                    companyId: companyId,
                    domainId: domainId,
                    emailType: "Outlook",
                    deletedAt: null
                  });
                case 36:
                  user = _context.sent;
                  if (user) {
                    _context.next = 40;
                    break;
                  }
                  console.warn("User not found for email: ".concat(from));
                  throw new RequestError("User not found for email: ".concat(from));
                case 40:
                  _kue.queue.create('webhook-reported-email-outlook-collector', {
                    messageId: messageId,
                    companyId: companyId,
                    domainId: domainId,
                    token: credential.token.access_token,
                    webhookRetrievalEmail: webhookRetrievalEmail,
                    from: user.email,
                    user: user
                  }).priority('high').removeOnComplete(true).save(function (err) {
                    if (err) console.error("Failed to enqueue reported-email-collector:", err);else console.log("Enqueued reported-email-collector for message: ".concat(messageId));
                  });
                case 41:
                case "end":
                  return _context.stop();
              }
            }, _loop, null, [[2, 12]]);
          });
          _iterator.s();
        case 8:
          if ((_step = _iterator.n()).done) {
            _context2.next = 12;
            break;
          }
          return _context2.delegateYield(_loop(), "t0", 10);
        case 10:
          _context2.next = 8;
          break;
        case 12:
          _context2.next = 17;
          break;
        case 14:
          _context2.prev = 14;
          _context2.t1 = _context2["catch"](5);
          _iterator.e(_context2.t1);
        case 17:
          _context2.prev = 17;
          _iterator.f();
          return _context2.finish(17);
        case 20:
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            message: 'Email reported successfully'
          }));
        case 23:
          _context2.prev = 23;
          _context2.t2 = _context2["catch"](0);
          console.error("Error processing webhook:", _context2.t2.message);
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            message: 'Received but failed internally'
          }));
        case 27:
        case "end":
          return _context2.stop();
      }
    }, _callee, null, [[0, 23], [5, 14, 17, 20]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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