"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _kue = require("../../kue");
var _strategy = require("../../middlewares/strategy");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object().keys({
  reportedMailId: _joi["default"].string().hex().length(24).required(),
  mailAction: _joi["default"].string().allow(null).optional()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _updateFields, _updateReportedMailCa, mailAction, updateFields, reportedMail, domains, update, updated, bulkInsertMeta, i, domain, updateWhoElseMetaData, metadatas, _i, _domain;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          mailAction = req.body.mailAction;
          updateFields = (_updateFields = {
            isWhoElseProcessing: true,
            syncStartAt: new Date(),
            isWhoElseError: false
          }, (0, _defineProperty2["default"])(_updateFields, "isWhoElseProcessing", true), (0, _defineProperty2["default"])(_updateFields, "isWhoElseErrorMessage", ""), _updateFields);
          if (mailAction !== null) updateFields.isMailActionProcessing = mailAction;
          _context.next = 6;
          return db.ReportedMail.findOne({
            _id: req.body.reportedMailId
          });
        case 6:
          reportedMail = _context.sent;
          if (reportedMail) {
            _context.next = 9;
            break;
          }
          throw new RequestError("Mail not found!");
        case 9:
          if (!reportedMail.isWhoElseProcessing) {
            _context.next = 11;
            break;
          }
          throw new RequestError('Who-Else search already in progress!');
        case 11:
          _context.next = 13;
          return db.Domain.find({
            companyId: req.user.companyId,
            isCredential: true,
            deletedAt: null
          });
        case 13:
          domains = _context.sent;
          console.log({
            domains: domains
          });
          if (!(!domains || !domains.length)) {
            _context.next = 17;
            break;
          }
          throw new RequestError("Domain not found or credentials not uploaded!");
        case 17:
          _context.next = 19;
          return db.ReportedMail.findOneAndUpdate({
            _id: req.body.reportedMailId
          }, {
            $set: updateFields
          }, {
            "new": true
          });
        case 19:
          update = _context.sent;
          console.log({
            updated: updated
          });
          _context.next = 23;
          return (0, _functions.updateReportedMailCache)(req.body.reportedMailId, (_updateReportedMailCa = {
            isWhoElseProcessing: true,
            syncStartAt: new Date(),
            isWhoElseError: false
          }, (0, _defineProperty2["default"])(_updateReportedMailCa, "isWhoElseProcessing", true), (0, _defineProperty2["default"])(_updateReportedMailCa, "isWhoElseErrorMessage", ""), _updateReportedMailCa));
        case 23:
          updated = _context.sent;
          bulkInsertMeta = [];
          for (i = 0; i < domains.length; i++) {
            domain = domains[i];
            if ((domain.domainType == 'Outlook' || domain.domainType == 'Gsuite') && domain.domainTypeForOutlook != "EXCHANGE" && domain.isCredential) {
              bulkInsertMeta.push({
                isProcessing: false,
                isCompleted: false,
                reportedMailId: req.body.reportedMailId,
                domainId: domain._id,
                companyId: domain.companyId
              });
            }
          }
          _context.next = 28;
          return db.WhoElseMetaData.insertMany(bulkInsertMeta);
        case 28:
          updateWhoElseMetaData = _context.sent;
          _context.next = 31;
          return db.WhoElseMetaData.findOne({
            reportedMailId: req.body.reportedMailId
          });
        case 31:
          metadatas = _context.sent;
          for (_i = 0; _i < domains.length; _i++) {
            _domain = domains[_i];
            if (_domain.domainType == 'Outlook' && _domain.domainTypeForOutlook != "EXCHANGE" && _domain.isCredential) {
              _kue.queue.create('email-reported-who-else-outlook', {
                reportedMailId: update._id,
                internetMessageId: update.internetMessageId,
                domainId: _domain._id,
                companyId: update.companyId,
                subject: update.subject,
                from: update.from,
                email: update.to,
                mailAction: mailAction
              }).removeOnComplete(true).priority('high').save();
            } else if (_domain.domainType == 'Gsuite' && _domain.isCredential) {
              _kue.queue.create('email-reported-who-else-gsuite', {
                reportedMailId: update._id,
                internetMessageId: update.internetMessageId,
                domainId: _domain._id,
                companyId: update.companyId,
                subject: update.subject,
                from: update.from,
                email: update.to,
                mailAction: mailAction
              }).removeOnComplete(true).priority('high').save();
            }
          }

          // if(update.mailType=='Outlook'){
          //   queue.create('email-reported-who-else-outlook', {
          //                   reportedMailId: update._id,
          //                   internetMessageId: update.internetMessageId, domainId: update.domainId, companyId: update.companyId, 
          //                   subject: update.subject, from: update.from, email:update.to, mailAction
          //               }).removeOnComplete(true).priority('high').save();

          // }
          // else{
          //   queue.create('email-reported-who-else-gsuite', {
          //                   reportedMailId: update._id,
          //                   internetMessageId:update.internetMessageId, domainId:update.domainId, companyId: update.companyId, 
          //                   subject: update.subject, from: update.from, email: update.to, mailAction
          //   }).removeOnComplete(true).priority('high').save();

          // }

          res.status(200).json({
            success: true
          });
          _context.next = 44;
          break;
        case 36:
          _context.prev = 36;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          _context.next = 41;
          return db.ReportedMail.updateOne({
            _id: reportedMail._id,
            companyId: reportedMail.companyId
          }, {
            syncEndAt: new Date(),
            isWhoElseError: false,
            isWhoElseProcessing: false,
            isWhoElseErrorMessage: JSON.stringify(_context.t0),
            isWhoElseCompleted: false
          });
        case 41:
          _context.next = 43;
          return db.WhoElseMetaData.deleteMany({
            reportedMailId: reportedMail._id,
            companyId: reportedMail.companyId
          });
        case 43:
          next(_context.t0);
        case 44:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 36]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WE"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Emails', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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