"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/reported-email/attachments?reportedMailId=63b676c744ed3b8a72386597 attachments
 * @apiName attachments
 * @apiGroup reported-email
 * @apiDescription Attachments of the reported mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String} reportedMailId      Required Reported mail id of the reported mail
 * 
 * @apiSuccess {String} success             true
 * @apiSuccess {Array}  attachments         list of all attachments of the mail
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      "success":  true,
 *      "attachments" :[
 *           {
 *               "_id": "63d0f16c78b9830aa47b3026",
 *               "attachmentId": "AAMkADg4N2I3ODU1LTg5MzgtNGJlOS05MDdmLTdkODQzY2UxODJlMABGAAAAAAAEeu5jAGlBSIzFYD0Uf00rBwDYeUh9annVS4gyZQy0RznfAAAAAAEMAADYeUh9annVS4gyZQy0RznfAABhlITtAAABEgAQAKQoNrvlMNBCmmja5uXbIAQ=",
 *               "fileName": "1674637676776.png",
 *               "originalName": "Screenshot 2023-01-13 at 5.44.25 PM.png",
 *               "mimeType": "png",
 *               "attachmentType": "image/png",
 *               "status": "NOT SCANNED",
 *               "result": null,
 *               "details": null,
 *               "reportedMailId": "63d0f16c78b9830aa47b3024",
 *               "__v": 0,
 *               "createdAt": "2023-01-25T09:07:56.783Z",
 *               "updatedAt": "2023-01-25T09:07:56.783Z"
 *           }
 *       ]
 * 
 * @apiError {Boolean} success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var reportedMailId, attachments;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          reportedMailId = req.query.reportedMailId;
          _context.next = 4;
          return db.Attachment.find({
            reportedMailId: reportedMailId
          });
        case 4:
          attachments = _context.sent;
          res.status(200).json({
            success: true,
            attachments: attachments
          });
          _context.next = 12;
          break;
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-VAUIR"), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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