"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _csvParser = _interopRequireDefault(require("csv-parser"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _permission = require("../../middlewares/permission");
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function _asyncIterator(iterable) { var method, async, sync, retry = 2; for ("undefined" != typeof Symbol && (async = Symbol.asyncIterator, sync = Symbol.iterator); retry--;) { if (async && null != (method = iterable[async])) return method.call(iterable); if (sync && null != (method = iterable[sync])) return new AsyncFromSyncIterator(method.call(iterable)); async = "@@asyncIterator", sync = "@@iterator"; } throw new TypeError("Object is not async iterable"); }
function AsyncFromSyncIterator(s) { function AsyncFromSyncIteratorContinuation(r) { if (Object(r) !== r) return Promise.reject(new TypeError(r + " is not an object.")); var done = r.done; return Promise.resolve(r.value).then(function (value) { return { value: value, done: done }; }); } return AsyncFromSyncIterator = function AsyncFromSyncIterator(s) { this.s = s, this.n = s.next; }, AsyncFromSyncIterator.prototype = { s: null, n: null, next: function next() { return AsyncFromSyncIteratorContinuation(this.n.apply(this.s, arguments)); }, "return": function _return(value) { var ret = this.s["return"]; return void 0 === ret ? Promise.resolve({ value: value, done: !0 }) : AsyncFromSyncIteratorContinuation(ret.apply(this.s, arguments)); }, "throw": function _throw(value) { var thr = this.s["return"]; return void 0 === thr ? Promise.reject(value) : AsyncFromSyncIteratorContinuation(thr.apply(this.s, arguments)); } }, new AsyncFromSyncIterator(s); }
var validator = _joi["default"].object().keys({
  filter: _joi["default"].object().keys({
    domainId: _joi["default"].string().optional(),
    search: _joi["default"].string().optional().allow(null).empty(''),
    isTrashedEmail: _joi["default"].required(),
    isRecoveredEmail: _joi["default"].required(),
    isDeletedEmail: _joi["default"].required(),
    last15: _joi["default"].required(),
    last30: _joi["default"].required(),
    none: _joi["default"].required(),
    custom: _joi["default"]["boolean"]().required(),
    toDate: _joi["default"].date().required(),
    fromDate: _joi["default"].date().required(),
    type: _joi["default"].string().required()
  })
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query$filter, last15, last30, custom, none, _req$query$filter$sea, search, fromDate, toDate, type, isRecoveredEmail, isTrashedEmail, isDeletedEmail, domainId, query, domainsOfCurrentCompany, uniqueDomains, domainOfOutlookOrGsuite, domainOfExchange, idOfOutlookOrGsuite, idOfExchange, uniqueDomainOfOutlookOrGsuite, uniqueDomainOfExchange, regex, projection, tempFilePath, writeStream, cursor, _iteratorAbruptCompletion, _didIteratorError, _iteratorError, _iterator, _step, doc, rowData, str;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query$filter = req.query.filter, last15 = _req$query$filter.last15, last30 = _req$query$filter.last30, custom = _req$query$filter.custom, none = _req$query$filter.none, _req$query$filter$sea = _req$query$filter.search, search = _req$query$filter$sea === void 0 ? '' : _req$query$filter$sea, fromDate = _req$query$filter.fromDate, toDate = _req$query$filter.toDate, type = _req$query$filter.type, isRecoveredEmail = _req$query$filter.isRecoveredEmail, isTrashedEmail = _req$query$filter.isTrashedEmail, isDeletedEmail = _req$query$filter.isDeletedEmail, domainId = _req$query$filter.domainId;
          query = {};
          _context.next = 5;
          return db.Domain.find({
            companyId: req.user.companyId,
            deletedAt: null
          }).select("domainType domainTypeForOutlook");
        case 5:
          domainsOfCurrentCompany = _context.sent;
          console.log({
            domainsOfCurrentCompany: domainsOfCurrentCompany
          });
          uniqueDomains = new Set(); // for doamin id
          domainsOfCurrentCompany.map(function (currentDomain) {
            uniqueDomains.add(currentDomain._id);
          });
          domainOfOutlookOrGsuite = [];
          domainOfExchange = [];
          idOfOutlookOrGsuite = [];
          idOfExchange = [];
          domainsOfCurrentCompany.map(function (value) {
            if (value.domainType === "Gsuite") {
              domainOfOutlookOrGsuite.push("Gsuite");
              idOfOutlookOrGsuite.push(value._id);
            } else if (value.domainType === "Outlook") {
              if (value.domainTypeForOutlook === "EXCHANGE") {
                domainOfExchange.push("Exchange");
                idOfExchange.push(value._id);
              } else {
                domainOfOutlookOrGsuite.push("Outlook");
                idOfOutlookOrGsuite.push(value._id);
              }
            }
          });
          domainsOfCurrentCompany = (0, _toConsumableArray2["default"])(uniqueDomains);
          uniqueDomainOfOutlookOrGsuite = new Set();
          uniqueDomainOfExchange = new Set();
          domainOfOutlookOrGsuite.map(function (value) {
            uniqueDomainOfOutlookOrGsuite.add(value);
          });
          domainOfExchange.map(function (value) {
            uniqueDomainOfExchange.add(value);
          });
          domainOfOutlookOrGsuite = (0, _toConsumableArray2["default"])(uniqueDomainOfOutlookOrGsuite);
          domainOfExchange = (0, _toConsumableArray2["default"])(uniqueDomainOfExchange);
          domainsOfCurrentCompany = domainsOfCurrentCompany.map(function (value) {
            return value._id;
          });
          query['companyId'] = req.user.companyId;
          query['isRecoveredEmail'] = isRecoveredEmail;
          query['isTrashedEmail'] = isTrashedEmail;
          query['isDeletedEmail'] = isDeletedEmail;
          if (domainId !== '-1') query['domainId'] = domainId;else {
            if (type == "outlookOrGsuite") query["domainId"] = {
              $in: idOfOutlookOrGsuite
            };else query["domainId"] = {
              $in: idOfExchange
            };
          }
          if (last15 !== 'false') {
            query['createdAt'] = {
              $gte: last15
            };
          }
          if (last30 !== 'false') {
            query['createdAt'] = {
              $gte: last30
            };
          }
          if (custom !== 'false') {
            query['createdAt'] = {
              $gte: fromDate,
              $lte: toDate
            };
          }
          if (type == 'outlookOrGsuite') {
            // query["mailType"] = { $in: ['Outlook', 'Gsuite' ] }
            query["mailtype"] = {
              $in: domainOfOutlookOrGsuite
            };
          }
          if (type == 'Exchange') {
            // query["mailType"] = { $in: ['Exchange'] }
            query["mailType"] = {
              $in: domainOfExchange
            };
          }
          if (search && search.length) {
            regex = new RegExp(search, "i");
            query['$or'] = [{
              to: regex
            }, {
              from: regex
            }, {
              subject: regex
            }];
          }
          projection = {
            from: 1,
            to: 1,
            subject: 1,
            mailType: 1,
            mailRecievedTime: 1,
            createdAt: 1
          };
          console.log({
            query: query
          });
          res.setHeader('Content-Type', 'text/csv');
          res.setHeader('Content-Disposition', 'attachment; filename=reported_mails.csv');

          // Create a temporary file path
          tempFilePath = _path["default"].join(__dirname, "reported_mails.csv".concat(domainId)); // Create a write stream to the temporary file
          writeStream = _fs["default"].createWriteStream(tempFilePath);
          writeStream.write("from,to,subject,mailType,ReportedTime \n");

          // Fetch documents using the cursor and write to CSV
          cursor = db.ReportedMail.find(query, projection).cursor(); // Wait for the 'finish' event to indicate that the write stream is ready
          writeStream.on('finish', function () {
            res.download(tempFilePath, function () {
              console.log({
                tempFilePath: tempFilePath
              });
              _fs["default"].unlinkSync(tempFilePath); // Remove the temporary file
            });
          });
          _iteratorAbruptCompletion = false;
          _didIteratorError = false;
          _context.prev = 44;
          _iterator = _asyncIterator(cursor);
        case 46:
          _context.next = 48;
          return _iterator.next();
        case 48:
          if (!(_iteratorAbruptCompletion = !(_step = _context.sent).done)) {
            _context.next = 56;
            break;
          }
          doc = _step.value;
          rowData = {
            from: doc.from,
            to: doc.to,
            subject: doc.subject,
            mailType: doc.mailType,
            ReportedTime: doc.createdAt
          };
          str = "".concat(doc.from, ",").concat(doc.to, ",").concat(doc.subject, ",").concat(doc.mailType, ",").concat(doc.createdAt.toLocaleString('en-IN', {
            timeZone: 'Asia/Kolkata'
          }), " \n");
          writeStream.write(str);
        case 53:
          _iteratorAbruptCompletion = false;
          _context.next = 46;
          break;
        case 56:
          _context.next = 62;
          break;
        case 58:
          _context.prev = 58;
          _context.t0 = _context["catch"](44);
          _didIteratorError = true;
          _iteratorError = _context.t0;
        case 62:
          _context.prev = 62;
          _context.prev = 63;
          if (!(_iteratorAbruptCompletion && _iterator["return"] != null)) {
            _context.next = 67;
            break;
          }
          _context.next = 67;
          return _iterator["return"]();
        case 67:
          _context.prev = 67;
          if (!_didIteratorError) {
            _context.next = 70;
            break;
          }
          throw _iteratorError;
        case 70:
          return _context.finish(67);
        case 71:
          return _context.finish(62);
        case 72:
          writeStream.end(); // Signal the end of writing to the CSV
          _context.next = 80;
          break;
        case 75:
          _context.prev = 75;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          _fs["default"].unlinkSync(tempFilePath); // Remove the temporary file
          next(_context.t1);
        case 80:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 75], [44, 58, 62, 72], [63,, 67, 71]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _validator.validateBody)(validator), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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