"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  search: _joi["default"].string().optional().allow(null).empty('')
});

/**
 * @api {get} /api/v1/reported-email/events?page=1&limit=100 events
 * @apiName events
 * @apiGroup reported-email
 * @apiDescription Get Events of the user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}   page          (Pagination) Required page of the events records
 * @apiQuery   {String}   limit         (Pagination) Required limit of event records to be returned
 * @apiQuery   {String}   [search]      Search for a particulat event
 * 
 * @apiSuccess {String}   success             true
 * @apiSuccess {Array}    results             record of events
 * @apiSuccess {Number}   count               count of events returned
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      {
 *          "success": true,
 *          "results": [
 *              {
 *                  "_id": "63d0f7dcf111d4088dd477cd",
 *                  "from": "mnnitsarvesh@outlook.com",
 *                  "fromName": "Sarvesh Patel",
 *                  "to": "arpit@kdmarc.com",
 *                  "toName": "",
 *                  "subject": "New Content Out For Registration",
 *                  "score": 3.2,
 *                  "mailRecievedTime": "2023-01-24T08:57:41.000Z",
 *                  "mailType": "Outlook",
 *                  "createdAt": "2023-01-25T09:35:24.278Z"
 *              }
 *          ],
 *          "count": 1
 *      }
 * 
 * @apiError {Boolean} success             false
 * @apiError {Array}   messages            "\"page\" is required"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 404 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"page\" is required"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$query, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, condition, regex, count, results;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _req$query = req.query, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search;
          condition = {
            companyId: companyId
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              to: regex
            }, {
              from: regex
            }, {
              subject: regex
            }];
          }
          _context.next = 7;
          return db.CheckEmailScoreEvent.countDocuments(condition);
        case 7:
          count = _context.sent;
          _context.next = 10;
          return db.CheckEmailScoreEvent.find(condition).select('from fromName to toName othersTo subject score mailRecievedTime mailType createdAt').sort({
            'createdAt': -1
          }).skip((page - 1) * limit).limit(limit);
        case 10:
          results = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: true,
            results: results,
            count: count
          }));
        case 14:
          _context.prev = 14;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 14]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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