"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _upload_file = _interopRequireDefault(require("../../Content/upload_file"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  reportedMailId: _joi["default"].string().hex().length(24).optional()
});

/**
 * @api {get} /api/v1/reported-email/get?reportedMailId=63b676c744ed3b8a72386597 get
 * @apiName get
 * @apiGroup reported-email
 * @apiDescription Get all details of reported mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}   reportedMailId      Id of the reported mail
 * 
 * @apiSuccess {String}   success             true
 * @apiSuccess {Object}   reportedEmail       Details of the reported mail
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *   {
 *     "success":true,
 *     "reportedEmail":
 *      {"_id":"63d0f16c78b9830aa47b3024",
 *      "from":"sarvesh.patel@kratikal.com",
 *      "fromName":"Sarvesh Patel",
 *      "to":"arpit@kdmarc.com",
 *      "toName":"",
 *      "otherTo":[{"address":"arpit@kdmarc.com","name":""}]}] .....,
 *      "countReportedEmails": 1
 *
 *  }
 * 
 * @apiError {Boolean} success             false
 * @apiError {Array}   messages            ["\"reportedMailId\" is not allowed to be empty"]
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 404 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "\"reportedMailId\" is not allowed to be empty"
 *       |
 * 
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var reportedMailId, companyId, _yield$Promise$all, _yield$Promise$all2, company, companyFeatures, featureCodes, reportedMail, MailAlreadySent, reportedEmail, reportedEmailFeaturesObject, _i, _Object$entries, _Object$entries$_i, attribute, featureCode;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          reportedMailId = req.query.reportedMailId;
          companyId = req.user.companyId;
          _context.prev = 2;
          _context.next = 5;
          return Promise.all([db.Company.findById(companyId).lean(),
          // Use `lean` to avoid Mongoose overhead
          db.CompanyFeature.find({
            companyId: companyId
          }).select('featureCode -_id').lean()]);
        case 5:
          _yield$Promise$all = _context.sent;
          _yield$Promise$all2 = (0, _slicedToArray2["default"])(_yield$Promise$all, 2);
          company = _yield$Promise$all2[0];
          companyFeatures = _yield$Promise$all2[1];
          if (company) {
            _context.next = 11;
            break;
          }
          throw new RequestError('Company not found!', 404);
        case 11:
          featureCodes = new Set(companyFeatures.map(function (feature) {
            return feature.featureCode;
          }));
          _context.next = 14;
          return (0, _functions.getReportedMailFromCache)(reportedMailId);
        case 14:
          reportedMail = _context.sent;
          if (!reportedMail) {
            _context.next = 20;
            break;
          }
          _context.next = 18;
          return db.ReportedMail.findById(reportedMailId).select('isBroadcastMail -_id').lean();
        case 18:
          MailAlreadySent = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            isAlreadyBroadcasted: MailAlreadySent.isBroadcastMail,
            success: true,
            reportedEmail: reportedMail,
            isBroadcast: company.broadcastThreshold > 0
          }));
        case 20:
          _context.next = 22;
          return _upload_file["default"].fetchReportedMail(reportedMailId);
        case 22:
          reportedEmail = _context.sent;
          reportedEmailFeaturesObject = {
            body: "TPIR-VREB",
            parsedHeader: "TPIR-HA",
            headerDetails: "TPIR-SDD",
            senderDomainDeceptive: "TPIR-SDRC",
            dnsbl: "TPIR-DBL",
            spamScore: "TPIR-SSRE"
          };
          for (_i = 0, _Object$entries = Object.entries(reportedEmailFeaturesObject); _i < _Object$entries.length; _i++) {
            _Object$entries$_i = (0, _slicedToArray2["default"])(_Object$entries[_i], 2), attribute = _Object$entries$_i[0], featureCode = _Object$entries$_i[1];
            if (!featureCodes.has(featureCode)) reportedEmail[attribute] = '';
          }
          _kue.queue.create('cache-reported-mail', {
            reportedEmail: reportedEmail
          }).removeOnComplete(true).priority('high').save();
          res.status(200).json({
            success: true,
            reportedEmail: reportedEmail,
            isBroadcast: company.broadcastThreshold > 0
          });
          _context.next = 33;
          break;
        case 29:
          _context.prev = 29;
          _context.t0 = _context["catch"](2);
          // Handle errors gracefully
          console.error(_context.t0);
          res.status(500).json({
            success: false,
            message: _context.t0.message
          });
        case 33:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[2, 29]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])('TPIR-VRE'), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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