"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _awsSdk = require("aws-sdk");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domainId: _joi["default"].string().hex().length(24).optional(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  isTrashedEmail: _joi["default"]["boolean"]().required(),
  isRecoveredEmail: _joi["default"]["boolean"]().required(),
  isDeletedEmail: _joi["default"]["boolean"]().required(),
  last15: _joi["default"].required(),
  last30: _joi["default"].required(),
  custom: _joi["default"]["boolean"]().required(),
  toDate: _joi["default"].date().required(),
  fromDate: _joi["default"].date().required(),
  mailType: _joi["default"].string().optional().allow(null).empty('')
});

/**
 * @api {post} /api/reported-email/list list
 * @apiName list
 * @apiGroup Report
 * @apiDescription list of all reported mails of a particular domain or all domains
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean}    success                 true
 * @apiSuccess {Object}     reportedEmails          Object of all reported mails
 * @apiSuccess {Number}     countReportedEmails     count of reported mails returned
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *   {
 *     "success":true,
 *     "reportedEmail":
 *      {"_id":"63d0f16c78b9830aa47b3024",
 *      "from":"sarvesh.patel@kratikal.com",
 *      "fromName":"Sarvesh Patel",
 *      "to":"arpit@kdmarc.com",
 *      "toName":"",
 *      "otherTo":[{"address":"arpit@kdmarc.com","name":""}]} .....
 *  }

 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, domainId, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, _req$query$isRecovere, isRecoveredEmail, _req$query$isTrashedE, isTrashedEmail, _req$query$isDeletedE, isDeletedEmail, mailType, last15, last30, custom, toDate, fromDate, companyId, company, conditionForDomain, domainsOfCurrentCompany, uniqueDomains, condition, regex, countReportedEmails, reportedEmails, i, emailCount;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, domainId = _req$query.domainId, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search, _req$query$isRecovere = _req$query.isRecoveredEmail, isRecoveredEmail = _req$query$isRecovere === void 0 ? false : _req$query$isRecovere, _req$query$isTrashedE = _req$query.isTrashedEmail, isTrashedEmail = _req$query$isTrashedE === void 0 ? false : _req$query$isTrashedE, _req$query$isDeletedE = _req$query.isDeletedEmail, isDeletedEmail = _req$query$isDeletedE === void 0 ? false : _req$query$isDeletedE, mailType = _req$query.mailType, last15 = _req$query.last15, last30 = _req$query.last30, custom = _req$query.custom, toDate = _req$query.toDate, fromDate = _req$query.fromDate;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Company.findById(companyId);
        case 5:
          company = _context.sent;
          if (company) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Company not found!', 404);
        case 8:
          conditionForDomain = {
            companyId: companyId,
            deletedAt: null
          };
          if (mailType == 'Exchange') {
            conditionForDomain['domainTypeForOutlook'] = 'EXCHANGE';
          } else {
            conditionForDomain['domainTypeForOutlook'] = {
              $ne: 'EXCHANGE'
            };
          }
          _context.next = 12;
          return db.Domain.find(conditionForDomain).select('domainName');
        case 12:
          domainsOfCurrentCompany = _context.sent;
          uniqueDomains = new Set();
          domainsOfCurrentCompany.map(function (currentDomain) {
            uniqueDomains.add(currentDomain);
          });
          domainsOfCurrentCompany = (0, _toConsumableArray2["default"])(uniqueDomains);
          domainsOfCurrentCompany = domainsOfCurrentCompany.map(function (value) {
            return value._id;
          });
          condition = {
            companyId: companyId,
            isRecoveredEmail: isRecoveredEmail,
            isTrashedEmail: isTrashedEmail,
            isDeletedEmail: isDeletedEmail,
            mailType: {
              $in: ['Outlook', 'Gsuite']
            },
            domainId: {
              $in: domainsOfCurrentCompany
            },
            deletedAt: null
          };
          if (domainId) {
            condition['domainId'] = domainId;
          }
          if (mailType) {
            condition['mailType'] = mailType;
          }
          if (last15 !== 'false') {
            condition['createdAt'] = {
              $gte: new Date(+last15)
            };
          }
          if (last30 !== 'false') {
            condition['createdAt'] = {
              $gte: new Date(+last30)
            };
          }
          if (custom !== 'false') {
            condition['createdAt'] = {
              $gte: new Date(fromDate),
              $lte: new Date(toDate)
            };
          }
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              to: regex
            }, {
              from: regex
            }, {
              subject: regex
            }];
          }
          console.log(condition);
          _context.next = 27;
          return db.ReportedMail.countDocuments(condition);
        case 27:
          countReportedEmails = _context.sent;
          _context.next = 30;
          return db.ReportedMail.find(condition).select('-header -body -messageId -mailId').sort({
            'createdAt': -1
          }).skip((page - 1) * limit).limit(limit);
        case 30:
          reportedEmails = _context.sent;
          i = 0;
        case 32:
          if (!(i < reportedEmails.length)) {
            _context.next = 40;
            break;
          }
          _context.next = 35;
          return db.WhoElse.countDocuments({
            reportedMailId: reportedEmails[i]._doc._id
          });
        case 35:
          emailCount = _context.sent;
          reportedEmails[i] = _objectSpread(_objectSpread({}, reportedEmails[i]._doc), {}, {
            emailCount: emailCount
          });
        case 37:
          i++;
          _context.next = 32;
          break;
        case 40:
          res.status(200).json({
            success: true,
            reportedEmails: reportedEmails,
            countReportedEmails: countReportedEmails,
            isBroadcast: company.broadcastThreshold > 0
          });
          _context.next = 47;
          break;
        case 43:
          _context.prev = 43;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 47:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 43]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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