"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {get} /api/v1/reported-email/who-else?reportedMailId=63b676c744ed3b8a72386597&page=1&limit=100 who-else
 * @apiName events
 * @apiGroup reported-email
 * @apiDescription Get Events of the user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}   page              (Pagination) Required page of the events records
 * @apiQuery   {String}   limit             (Pagination) Required limit of event records to be returned
 * @apiQuery   {String}   reportedMailId    Required reportedMailId of the mail
 * @apiQuery   {String}   [search]          Search for a particulat who-else record
 * 
 * @apiSuccess {String}   success             true
 * @apiSuccess {Array}    whoElse             who else mails found
 * @apiSuccess {Number}   count               count of who else mails returned
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 *           
 *       {
 *              "success": true,
 *              "whoElse": [{
 *              "_id": "63d0f7f9f111d4088dd477fd",
 *              "to": "pavan@kdmarc.com",
 *              "from": "mnnitsarvesh@outlook.com",
 *              "subject": "New Content Out For Registration",
 *              "whoelseMail": "pavan@kdmarc.com",
 *              "messageId": "AAMkADdlZGQ1MWVkLWQzZTQtNDkzOS1hOGZlLTE2MzI2Y2NiZDMwMABGAAAAAABh1Ro9ZHOaQat_DQuLkrpXBwBQ5-_l0X-MSIhbub19I377AAAAAAEMAABQ5-_l0X-MSIhbub19I377AAOc0ER_AAA=",
 *              "threadId": null,
 *              "isTrashed": false,
 *              "isDeleted": true,
 *              "isErrorWhileMoving": {
 *                  "isError": false,
 *                  "message": ""
 *              },
 *              "userId": "63d0efab032f943fc31e4edb",
 *              "domainId": "63d0eaaa032f943fc31e4ea2",
 *              "companyId": "63d0ea61032f943fc31e4e80",
 *              "reportedMailId": "63d0f7f3f111d4088dd477e0",
 *              "deletedAt": null,
 *              "createdAt": "2023-01-25T09:35:53.541Z",
 *              "updatedAt": "2023-01-25T09:36:47.357Z",
 *              "__v": 0
 *          }],
 *          "count": 1
 *      }
 * 
 * @apiError {Boolean} success         false
 * @apiError {Array}   messages        "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 *   "messages" : "\"page\" is required"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, reportedMailId, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, condition, invalidPattern, regex, reportedMail, count, similiarEmail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, reportedMailId = _req$query.reportedMailId, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search;
          condition = {
            reportedMailId: reportedMailId
          };
          if (search && search.length) {
            invalidPattern = /[^a-zA-Z0-9@._-]/;
            if (!invalidPattern.test(search)) {
              regex = new RegExp(search, "i");
              condition['$or'] = [{
                to: regex
              }];
            } else {
              condition['$or'] = [{
                to: /^$/
              }];
            }
          }
          _context.next = 6;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: req.user.companyId
          });
        case 6:
          reportedMail = _context.sent;
          if (!reportedMail.isSimiliarEmailProcessing) {
            _context.next = 9;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            similiarEmail: [],
            count: 0
          }));
        case 9:
          _context.next = 11;
          return db.SimiliarEmail.countDocuments(condition);
        case 11:
          count = _context.sent;
          _context.next = 14;
          return db.SimiliarEmail.find(condition).skip((page - 1) * limit).limit(limit);
        case 14:
          similiarEmail = _context.sent;
          res.status(200).json({
            success: true,
            similiarEmail: similiarEmail,
            count: count
          });
          _context.next = 22;
          break;
        case 18:
          _context.prev = 18;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 22:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 18]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-FSEI"), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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