"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/reported-email/urls?reportedMailId=63b676c744ed3b8a72386597 urls
 * @apiName  urls
 * @apiGroup reported-email
 * @apiDescription Urls of the reported mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String} reportedMailId      Required Reported mail id of the reported mail
 * 
 * @apiSuccess {String} success             true
 * @apiSuccess {Array}  urls                list of all urls of the mail
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      "success":  true,
 *      "urls" :[
 *           {
 *               "_id": "63d0f16d78b9830aa47b302c",
 *               "url": "https://mixpanel.com/project/2327671",
 *               "deceptiveStatus": "false",
 *               "status": "NOT SCANNED",
 *               "domain": {
 *                   "tld": "com",
 *                   "domain": "mixpanel.com",
 *                   "subdomain": "",
 *                   "siteName": "mixpanel",
 *                   "href": "https://mixpanel.com/project/2327671",
 *                   "hostname": "mixpanel.com",
 *                   "protocol": "https:"
 *               },
 *               "result": null,
 *               "details": null,
 *               "scanId": [],
 *               "reportedMailId": "63d0f16c78b9830aa47b3024",
 *               "__v": 0,
 *               "createdAt": "2023-01-25T09:07:57.489Z",
 *               "updatedAt": "2023-01-25T09:07:57.489Z"
 *           },
 *
 *       ]
 *       
 * 
 * @apiError {Boolean} success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var reportedMailId, urls;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          reportedMailId = req.query.reportedMailId;
          _context.next = 4;
          return db.Url.find({
            reportedMailId: reportedMailId
          });
        case 4:
          urls = _context.sent;
          res.status(200).json({
            success: true,
            urls: urls
          });
          _context.next = 12;
          break;
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-VAUIR"), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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