"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  employeeId: _joi["default"].string().hex().length(24).required(),
  roleIds: _joi["default"].array().items(_joi["default"].string())
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, employeeId, roleIds, companyId, employee, EmployeeRole, filteredRoleIds, _iterator, _step, roleId, Role;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, employeeId = _req$body.employeeId, roleIds = _req$body.roleIds;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Employee.findOne({
            companyId: companyId,
            _id: employeeId
          });
        case 5:
          employee = _context.sent;
          if (employee) {
            _context.next = 8;
            break;
          }
          throw new RequestError("User does not exist");
        case 8:
          _context.next = 10;
          return db.EmployeeRole.findOne({
            employeeId: employeeId
          });
        case 10:
          EmployeeRole = _context.sent;
          if (!(roleIds.length === 0)) {
            _context.next = 20;
            break;
          }
          if (!EmployeeRole) {
            _context.next = 17;
            break;
          }
          _context.next = 15;
          return db.EmployeeRole.updateOne({
            _id: EmployeeRole._id
          }, {
            $set: {
              roleIds: []
            }
          });
        case 15:
          _context.next = 19;
          break;
        case 17:
          _context.next = 19;
          return db.EmployeeRole.create({
            employeeId: employeeId,
            roleIds: [],
            companyId: companyId
          });
        case 19:
          return _context.abrupt("return", res.status(201).send({
            success: true,
            message: "Role assigned successfully",
            roleIds: []
          }));
        case 20:
          filteredRoleIds = [];
          _iterator = _createForOfIteratorHelper(roleIds);
          _context.prev = 22;
          _iterator.s();
        case 24:
          if ((_step = _iterator.n()).done) {
            _context.next = 35;
            break;
          }
          roleId = _step.value;
          _context.next = 28;
          return db.Role.findOne({
            _id: roleId
          });
        case 28:
          Role = _context.sent;
          if (Role) {
            _context.next = 32;
            break;
          }
          console.log("Role not found for id", roleId);
          return _context.abrupt("continue", 33);
        case 32:
          filteredRoleIds.push(roleId);
        case 33:
          _context.next = 24;
          break;
        case 35:
          _context.next = 40;
          break;
        case 37:
          _context.prev = 37;
          _context.t0 = _context["catch"](22);
          _iterator.e(_context.t0);
        case 40:
          _context.prev = 40;
          _iterator.f();
          return _context.finish(40);
        case 43:
          if (!EmployeeRole) {
            _context.next = 48;
            break;
          }
          _context.next = 46;
          return db.EmployeeRole.updateOne({
            _id: EmployeeRole._id
          }, {
            $set: {
              roleIds: filteredRoleIds
            }
          });
        case 46:
          _context.next = 51;
          break;
        case 48:
          _context.next = 50;
          return db.EmployeeRole.create({
            employeeId: employeeId,
            roleIds: filteredRoleIds,
            companyId: companyId
          });
        case 50:
          EmployeeRole = _context.sent;
        case 51:
          res.status(201).send({
            success: true,
            message: "Role assigned successfully",
            roleIds: filteredRoleIds
          });
          _context.next = 58;
          break;
        case 54:
          _context.prev = 54;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 58:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 54], [22, 37, 40, 43]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)("IAM", "Write"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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