"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  policyData: _joi["default"].array().items(_joi["default"].string()).required(),
  roleName: _joi["default"].string().required(),
  description: _joi["default"].string()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, policyData, roleName, description, companyId, isExistingRole, policyIdArr, i, name, Policy, Role;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, policyData = _req$body.policyData, roleName = _req$body.roleName, description = _req$body.description;
          roleName = roleName.toLowerCase();
          companyId = req.user.companyId;
          if (!(roleName == "admin" || roleName == "viewer" || roleName == "member")) {
            _context.next = 6;
            break;
          }
          throw new RequestError("Role with same name already exists");
        case 6:
          _context.next = 8;
          return db.Role.findOne({
            roleName: roleName.toLowerCase(),
            companyId: companyId
          });
        case 8:
          isExistingRole = _context.sent;
          if (!isExistingRole) {
            _context.next = 11;
            break;
          }
          throw new RequestError("Role with same name already exists");
        case 11:
          policyIdArr = [];
          i = 0;
        case 13:
          if (!(i < policyData.length)) {
            _context.next = 22;
            break;
          }
          name = policyData[i];
          _context.next = 17;
          return db.Policy.findOne({
            name: name
          });
        case 17:
          Policy = _context.sent;
          if (Policy && Policy._id) policyIdArr.push(Policy._id);
        case 19:
          i++;
          _context.next = 13;
          break;
        case 22:
          _context.next = 24;
          return db.Role.create({
            roleName: roleName.toLowerCase(),
            policyIds: policyIdArr,
            description: description,
            companyId: companyId
          });
        case 24:
          Role = _context.sent;
          res.status(201).send({
            success: true,
            message: "Role created successfully",
            Role: Role
          });
          _context.next = 32;
          break;
        case 28:
          _context.prev = 28;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 28]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)("IAM", "Write"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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