"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  roleId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var roleId, companyId, Role, employeeRoles, _iterator, _step, employeeRole, newValueArr;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          roleId = req.body.roleId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Role.findOne({
            _id: roleId
          });
        case 5:
          Role = _context.sent;
          if (Role) {
            _context.next = 8;
            break;
          }
          throw new RequestError("Role does not exists");
        case 8:
          ;
          if (!(Role.roleType == 'Default')) {
            _context.next = 11;
            break;
          }
          throw new RequestError("Default Roles cannot be deleted!", 403);
        case 11:
          _context.next = 13;
          return db.EmployeeRole.find({
            companyId: companyId
          });
        case 13:
          employeeRoles = _context.sent;
          _iterator = _createForOfIteratorHelper(employeeRoles);
          _context.prev = 15;
          _iterator.s();
        case 17:
          if ((_step = _iterator.n()).done) {
            _context.next = 25;
            break;
          }
          employeeRole = _step.value;
          if (!(employeeRole && employeeRole.roleIds && employeeRole.roleIds.length)) {
            _context.next = 23;
            break;
          }
          newValueArr = employeeRole.roleIds.filter(function (val) {
            return val !== Role._id;
          });
          _context.next = 23;
          return db.EmployeeRole.updateOne({
            _id: employeeRole._id
          }, {
            $set: {
              roleIds: newValueArr
            }
          });
        case 23:
          _context.next = 17;
          break;
        case 25:
          _context.next = 30;
          break;
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](15);
          _iterator.e(_context.t0);
        case 30:
          _context.prev = 30;
          _iterator.f();
          return _context.finish(30);
        case 33:
          _context.next = 35;
          return db.Role.deleteOne({
            _id: Role._id
          });
        case 35:
          res.status(201).send({
            success: true,
            message: "Role deleted successfully",
            Role: Role
          });
          _context.next = 42;
          break;
        case 38:
          _context.prev = 38;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 42:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 38], [15, 27, 30, 33]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, (0, _permission.permission)("IAM", "Write"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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