"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  roleName: _joi["default"].string().required(),
  roleType: _joi["default"].string().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, roleName, roleType, companyId, role, transformedRole;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, roleName = _req$body.roleName, roleType = _req$body.roleType;
          companyId = req.user.companyId;
          if (!(roleType == "Default")) {
            _context.next = 9;
            break;
          }
          _context.next = 6;
          return db.Role.findOne({
            roleName: roleName
          }).select('roleName description roleType').populate({
            path: 'policyIds',
            select: 'name'
          });
        case 6:
          role = _context.sent;
          _context.next = 12;
          break;
        case 9:
          _context.next = 11;
          return db.Role.findOne({
            companyId: companyId,
            roleName: roleName
          }).select('roleName description roleType').populate({
            path: 'policyIds',
            select: 'name'
          });
        case 11:
          role = _context.sent;
        case 12:
          transformedRole = {
            roleId: role._id,
            roleName: role.roleName,
            description: role.description,
            policies: role.policyIds.map(function (policy) {
              return policy.name;
            }),
            roleType: role.roleType
          };
          res.status(201).send({
            success: true,
            message: "Role fetched successfully",
            role: transformedRole
          });
          _context.next = 20;
          break;
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _validator.validateBody)(validator), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)("IAM", "Read"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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