"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
// let validator = Joi.object().keys({
//   companyId: Joi.string().hex().length(24).required(),

// });

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, roles, defaultRoles;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Role.find({
            companyId: companyId
          }).select('roleName roleType description');
        case 4:
          roles = _context.sent;
          _context.next = 7;
          return db.Role.find({
            roleType: "Default"
          });
        case 7:
          defaultRoles = _context.sent;
          roles = [].concat((0, _toConsumableArray2["default"])(roles), (0, _toConsumableArray2["default"])(defaultRoles));
          res.status(201).send({
            success: true,
            message: "Role fetched successfully",
            roles: roles
          });
          _context.next = 16;
          break;
        case 12:
          _context.prev = 12;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 12]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)("IAM", "Read"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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