"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var adminPolicyIds, adminDescription, memberPolicies, memberDescription, viewerPolicies, viewerDescription, Policies;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          adminPolicyIds = [];
          adminDescription = "An admin has full access to all functionalities, including creating, editing, and deleting content, managing user roles, and accessing all settings and configurations.";
          memberPolicies = [];
          memberDescription = "A member can view, create, and edit content but cannot manage user roles or access sensitive settings. Members have the ability to contribute to and modify existing resources.";
          viewerPolicies = [];
          viewerDescription = "A viewer has read-only access, allowing them to view content without the ability to make any changes or edits. Viewers cannot create, edit, or delete content.";
          _context.next = 9;
          return db.Policy.find({});
        case 9:
          Policies = _context.sent;
          if (Policies) {
            _context.next = 12;
            break;
          }
          throw "Policies Not found";
        case 12:
          Policies.forEach(function (policy) {
            var suffix = policy.name.split('-')[1];
            var prefix = policy.name.split('-')[0];
            if (suffix == 'Read') {
              adminPolicyIds.push(policy._id.toHexString());
              memberPolicies.push(policy._id.toHexString());
              viewerPolicies.push(policy._id.toHexString());
            }
            if (suffix == 'Write') {
              if (['Domain', 'Emails', 'AdvancedSearch', 'Settings'].includes(prefix)) {
                memberPolicies.push(policy._id.toHexString());
              }
              adminPolicyIds.push(policy._id.toHexString());
            }
            if (suffix == 'Delete') {
              adminPolicyIds.push(policy._id.toHexString());
            }
          });

          // let companies = await db.Company.find({});
          // for (const company of companies) {
          _context.next = 15;
          return db.Role.create({
            roleName: "admin",
            policyIds: adminPolicyIds,
            companyId: null,
            description: adminDescription,
            roleType: "Default"
          });
        case 15:
          _context.next = 17;
          return db.Role.create({
            roleName: "member",
            policyIds: memberPolicies,
            companyId: null,
            description: memberDescription,
            roleType: "Default"
          });
        case 17:
          _context.next = 19;
          return db.Role.create({
            roleName: "viewer",
            policyIds: viewerPolicies,
            companyId: null,
            description: viewerDescription,
            roleType: "Default"
          });
        case 19:
          res.status(201).send({
            success: true
          });
          _context.next = 26;
          break;
        case 22:
          _context.prev = 22;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 26:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 22]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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