"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var ROLE_NAMES = ["admin", "viewer", "member"];
var ERRORS = {
  ROLE_EXISTS: "Role with the same name already exists",
  ROLE_NOT_FOUND: "Role does not exist",
  MODIFY_DEFAULT: "Cannot modify default roles"
};
var validator = _joi["default"].object().keys({
  policyData: _joi["default"].array().items(_joi["default"].string()).required(),
  roleName: _joi["default"].string().required(),
  roleId: _joi["default"].string().hex().length(24).required(),
  description: _joi["default"].string()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, policyData, roleName, roleId, _req$body$description, description, companyId, Role, existingRole, policies, policyIdArr, updateData;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, policyData = _req$body.policyData, roleName = _req$body.roleName, roleId = _req$body.roleId, _req$body$description = _req$body.description, description = _req$body$description === void 0 ? '' : _req$body$description;
          companyId = req.user.companyId;
          roleName = roleName.toLowerCase();
          if (!ROLE_NAMES.includes(roleName)) {
            _context.next = 6;
            break;
          }
          throw new RequestError(ERRORS.ROLE_EXISTS);
        case 6:
          _context.next = 8;
          return db.Role.findOne({
            _id: roleId,
            companyId: companyId
          });
        case 8:
          Role = _context.sent;
          if (Role) {
            _context.next = 11;
            break;
          }
          throw new RequestError(ERRORS.ROLE_NOT_FOUND);
        case 11:
          if (!(Role.roleType === "Default")) {
            _context.next = 13;
            break;
          }
          throw new RequestError(ERRORS.MODIFY_DEFAULT);
        case 13:
          _context.next = 15;
          return db.Role.findOne({
            roleName: roleName,
            companyId: companyId
          });
        case 15:
          existingRole = _context.sent;
          if (!(existingRole && existingRole._id.toString() !== roleId)) {
            _context.next = 18;
            break;
          }
          throw new RequestError(ERRORS.ROLE_EXISTS);
        case 18:
          _context.next = 20;
          return db.Policy.find({
            name: {
              $in: policyData
            }
          });
        case 20:
          policies = _context.sent;
          policyIdArr = policies.map(function (policy) {
            return policy._id;
          });
          updateData = {
            policyIds: policyIdArr
          };
          if (description.length > 0) {
            updateData.roleName = roleName;
            updateData.description = description;
          }
          _context.next = 26;
          return db.Role.updateOne({
            _id: Role._id
          }, updateData);
        case 26:
          res.status(201).send({
            success: true,
            message: "Role updated successfully"
          });
          _context.next = 33;
          break;
        case 29:
          _context.prev = 29;
          _context.t0 = _context["catch"](0);
          console.error(_context.t0);
          next(_context.t0);
        case 33:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 29]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)("IAM", "Write"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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