"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _joi = _interopRequireDefault(require("joi"));
var _path = _interopRequireDefault(require("path"));
var _express = _interopRequireDefault(require("express"));
var _formData = _interopRequireDefault(require("form-data"));
var _sanitizer = require("../../middlewares/sanitizer");
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _getVirusTotalkey = _interopRequireDefault(require("../../service/get-virus-totalkey"));
var _validator = require("../../middlewares/validator");
var _scanAttachments = _interopRequireDefault(require("../../service/scan-attachments"));
var _upload_file = _interopRequireDefault(require("../../Content/upload_file"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  attachmentIds: _joi["default"].array().items(_joi["default"].string().hex().length(24).required()).required(),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/scan/scan-attachment scan-attachment
 * @apiName scan-attachment
 * @apiGroup scan
 * @apiDescription Scan a attachment
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}   attachmentId        AttchmentId of the reported mail
 * @apiBody   {String}   reportedMailId      Id of the reported mail
 * 
 * @apiSuccess {Boolean} Success             true
 * @apiSuccess {String}  Message             Scan now in processing, Result Will be Updated Soon!
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "Message": "Scan now in processing, Result Will be Updated Soon!"
 * }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, reportedMailId, attachmentIds, companyId, apikey, _iterator, _step, attachmentId, attachment, file, formData;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, reportedMailId = _req$body.reportedMailId, attachmentIds = _req$body.attachmentIds;
          companyId = req.user.companyId;
          _context.next = 5;
          return _getVirusTotalkey["default"].getApiKey(companyId);
        case 5:
          apikey = _context.sent;
          _iterator = _createForOfIteratorHelper(attachmentIds);
          _context.prev = 7;
          _iterator.s();
        case 9:
          if ((_step = _iterator.n()).done) {
            _context.next = 30;
            break;
          }
          attachmentId = _step.value;
          _context.next = 13;
          return db.Attachment.findOne({
            _id: attachmentId,
            reportedMailId: reportedMailId
          });
        case 13:
          attachment = _context.sent;
          if (attachment) {
            _context.next = 16;
            break;
          }
          throw new RequestError('Invalid attachmentId');
        case 16:
          _context.next = 18;
          return _upload_file["default"].fetchReportedMailAttachments(reportedMailId, attachment.fileName, apikey);
        case 18:
          file = _context.sent;
          if (file) {
            _context.next = 21;
            break;
          }
          throw new RequestError('File does not exist');
        case 21:
          formData = new _formData["default"]();
          formData.append('apikey', apikey);
          formData.append('file', file, {
            filename: attachment.fileName
          });
          _scanAttachments["default"].processScanAttachment(formData, attachmentId, companyId);
          attachment.status = 'IN PROGRESS';
          _context.next = 28;
          return attachment.save();
        case 28:
          _context.next = 9;
          break;
        case 30:
          _context.next = 35;
          break;
        case 32:
          _context.prev = 32;
          _context.t0 = _context["catch"](7);
          _iterator.e(_context.t0);
        case 35:
          _context.prev = 35;
          _iterator.f();
          return _context.finish(35);
        case 38:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Scans are now in processing, results will be updated soon!"
          }));
        case 41:
          _context.prev = 41;
          _context.t1 = _context["catch"](0);
          console.log("Main Catch", _context.t1);
          next(_context.t1);
        case 45:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 41], [7, 32, 35, 38]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-AALP"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Emails', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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