"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _formData = _interopRequireDefault(require("form-data"));
var _scanUrl = _interopRequireDefault(require("../../service/scan-url"));
var _permission = require("../../middlewares/permission");
var _getVirusTotalkey = _interopRequireDefault(require("../../service/get-virus-totalkey"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  urlIds: _joi["default"].array().items(_joi["default"].string().hex().length(24).required()).required(),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/scan/scan-url scan-url
 * @apiName scan-url
 * @apiGroup scan
 * @apiDescription Scan a url
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}   urlId        		 urlId of the reported mail
 * @apiBody   {String}   reportedMailId      Id of the reported mail
 * 
 * @apiSuccess {Boolean} Success             true
 * @apiSuccess {String}  Message             Scan now in processing, Result Will be Updated Soon!
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "Message": "Scan now in processing, Result Will be Updated Soon!"
 * }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, reportedMailId, urlIds, companyId, apikey, _iterator, _step, urlId, url, formData;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, reportedMailId = _req$body.reportedMailId, urlIds = _req$body.urlIds;
          companyId = req.user.companyId;
          _context.next = 5;
          return _getVirusTotalkey["default"].getApiKey(companyId);
        case 5:
          apikey = _context.sent;
          _iterator = _createForOfIteratorHelper(urlIds);
          _context.prev = 7;
          _iterator.s();
        case 9:
          if ((_step = _iterator.n()).done) {
            _context.next = 25;
            break;
          }
          urlId = _step.value;
          _context.next = 13;
          return db.Url.findOne({
            _id: urlId,
            reportedMailId: reportedMailId
          });
        case 13:
          url = _context.sent;
          if (url) {
            _context.next = 16;
            break;
          }
          throw new RequestError('Invalid urlId');
        case 16:
          formData = new _formData["default"]();
          formData.append('url', url.url);
          formData.append('apikey', apikey);
          _scanUrl["default"].processScanURL(formData, urlId, companyId);
          url.status = 'IN PROGRESS';
          _context.next = 23;
          return url.save();
        case 23:
          _context.next = 9;
          break;
        case 25:
          _context.next = 30;
          break;
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](7);
          _iterator.e(_context.t0);
        case 30:
          _context.prev = 30;
          _iterator.f();
          return _context.finish(30);
        case 33:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            Message: "Scans are now in processing, results will be updated soon!"
          }));
        case 36:
          _context.prev = 36;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 40:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 36], [7, 27, 30, 33]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-AALP"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Emails', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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