"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _formData = _interopRequireDefault(require("form-data"));
var _scanUrl = _interopRequireDefault(require("../../service/scan-url"));
var _permission = require("../../middlewares/permission");
var _getVirusTotalkey = _interopRequireDefault(require("../../service/get-virus-totalkey"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  urlIds: _joi["default"].array().items(_joi["default"].string().hex().length(24).required()).required(),
  whatsappMessageId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/scan/scan-url scan-url
 * @apiName scan-url
 * @apiGroup scan
 * @apiDescription Scan a url
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}   urlId        		 urlId of the reported mail
 * @apiBody   {String}   reportedMailId      Id of the reported mail
 * 
 * @apiSuccess {Boolean} Success             true
 * @apiSuccess {String}  Message             Scan now in processing, Result Will be Updated Soon!
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "Message": "Scan now in processing, Result Will be Updated Soon!"
 * }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, whatsappMessageId, urlIds, companyId, apikey, _iterator, _step, urlId, url, formData;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, whatsappMessageId = _req$body.whatsappMessageId, urlIds = _req$body.urlIds;
          companyId = req.user.companyId;
          _context.next = 5;
          return _getVirusTotalkey["default"].getApiKey(companyId);
        case 5:
          apikey = _context.sent;
          _iterator = _createForOfIteratorHelper(urlIds);
          _context.prev = 7;
          _iterator.s();
        case 9:
          if ((_step = _iterator.n()).done) {
            _context.next = 25;
            break;
          }
          urlId = _step.value;
          _context.next = 13;
          return db.Url.findOne({
            _id: urlId,
            whatsappMessageId: whatsappMessageId
          });
        case 13:
          url = _context.sent;
          if (url) {
            _context.next = 16;
            break;
          }
          throw new RequestError('Invalid urlId');
        case 16:
          formData = new _formData["default"]();
          formData.append('url', url.url);
          formData.append('apikey', apikey);
          _scanUrl["default"].processScanWaURL(formData, urlId, companyId);
          url.status = 'IN PROGRESS';
          _context.next = 23;
          return url.save();
        case 23:
          _context.next = 9;
          break;
        case 25:
          _context.next = 30;
          break;
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](7);
          _iterator.e(_context.t0);
        case 30:
          _context.prev = 30;
          _iterator.f();
          return _context.finish(30);
        case 33:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            Message: "Scans are now in processing, results will be updated soon!"
          }));
        case 36:
          _context.prev = 36;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 40:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 36], [7, 27, 30, 33]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-AALP"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Emails', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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