"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _getVirusTotalkey = _interopRequireDefault(require("../../service/get-virus-totalkey"));
var _validator = require("../../middlewares/validator");
var _resultAttachmentTotalvirus = _interopRequireDefault(require("../../service/result-attachment-totalvirus"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  attachmentId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/report/reported-emails Request User information
 * @apiName Email Report
 * @apiGroup Report
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {String} success    status of the request.
 * @apiSuccess {String} message    success message.
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _attachment$details, attachmentId, companyId, attachment, scan_id, apikey;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          attachmentId = req.query.attachmentId;
          companyId = req.user.companyId;
          _context2.next = 5;
          return db.Attachment.findById(attachmentId);
        case 5:
          attachment = _context2.sent;
          if (attachment) {
            _context2.next = 8;
            break;
          }
          throw new RequestError('Invalid attachemntId recieved');
        case 8:
          if (attachment !== null && attachment !== void 0 && (_attachment$details = attachment.details) !== null && _attachment$details !== void 0 && _attachment$details.scan_id) {
            _context2.next = 10;
            break;
          }
          throw new RequestError('first scan the attachment file');
        case 10:
          scan_id = attachment.details.scan_id;
          _context2.next = 13;
          return _getVirusTotalkey["default"].getApiKey(companyId);
        case 13:
          apikey = _context2.sent;
          _resultAttachmentTotalvirus["default"].processScanResult({
            apikey: apikey,
            scan_id: scan_id
          }).then( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(data) {
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return db.Attachment.updateOne({
                      _id: attachmentId
                    }, {
                      status: 'COMPLETED',
                      result: data
                    });
                  case 2:
                    if (!(data.response_code == -2 || data.response_code == 0 || data.verbose_msg)) {
                      _context.next = 6;
                      break;
                    }
                    return _context.abrupt("return", [data.verbose_msg, false]);
                  case 6:
                    return _context.abrupt("return", ['scan result fetch successfully', true]);
                  case 7:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }()).then(function (_ref3) {
            var _ref4 = (0, _slicedToArray2["default"])(_ref3, 2),
              message = _ref4[0],
              isRefresh = _ref4[1];
            res.status(200).json({
              success: true,
              isRefresh: isRefresh,
              message: message
            });
          })["catch"](function (err) {
            console.log(err);
            db.Attachment.updateOne({
              _id: attachmentId
            }, {
              status: 'FAILED',
              details: err
            });
            next(err);
          });
          _context2.next = 21;
          break;
        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          next(_context2.t0);
        case 21:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-AALP"), _strategy.checkCompanyValidityStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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