"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _getVirusTotalkey = _interopRequireDefault(require("../../service/get-virus-totalkey"));
var _validator = require("../../middlewares/validator");
var _resultUrlTotalvirus = _interopRequireDefault(require("../../service/result-url-totalvirus"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  urlId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/report/reported-emails Request User information
 * @apiName Email Report
 * @apiGroup Report
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {String} success    status of the request.
 * @apiSuccess {String} message    success message.
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _attachment$result, urlId, companyId, attachment, scan_id, apikey;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          urlId = req.query.urlId;
          companyId = req.user.companyId;
          _context2.next = 5;
          return db.Url.findById(urlId);
        case 5:
          attachment = _context2.sent;
          if (attachment) {
            _context2.next = 8;
            break;
          }
          throw new RequestError('Invalid urlId recieved');
        case 8:
          if (attachment !== null && attachment !== void 0 && (_attachment$result = attachment.result) !== null && _attachment$result !== void 0 && _attachment$result.scan_id) {
            _context2.next = 10;
            break;
          }
          throw new RequestError('first scan the attachment file');
        case 10:
          scan_id = attachment.result.scan_id.scan_id;
          _context2.next = 13;
          return _getVirusTotalkey["default"].getApiKey(companyId);
        case 13:
          apikey = _context2.sent;
          _resultUrlTotalvirus["default"].processScanResult({
            apikey: apikey,
            scan_id: scan_id
          }).then( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(data) {
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return db.Url.updateOne({
                      _id: urlId
                    }, {
                      status: 'COMPLETED',
                      result: data
                    });
                  case 2:
                    if (!(data.response_code == -2 || data.verbose_msg)) {
                      _context.next = 6;
                      break;
                    }
                    return _context.abrupt("return", [data.verbose_msg, false]);
                  case 6:
                    return _context.abrupt("return", ['scan result fetch successfully', true]);
                  case 7:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }()).then(function (_ref3) {
            var _ref4 = (0, _slicedToArray2["default"])(_ref3, 2),
              message = _ref4[0],
              isRefresh = _ref4[1];
            res.status(200).json({
              success: true,
              isRefresh: isRefresh,
              message: message
            });
          })["catch"](function (err) {
            console.log(err);
            db.Url.updateOne({
              _id: urlId
            }, {
              status: 'FAILED',
              details: err
            });
            next(err);
          });
          _context2.next = 21;
          break;
        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          next(_context2.t0);
        case 21:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-AALP"), _strategy.checkCompanyValidityStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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