"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _mailer = _interopRequireDefault(require("../../mailer"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  smtpHost: _joi["default"].string().required(),
  smtpPort: _joi["default"].string().required(),
  smtpPassword: _joi["default"].string().required(),
  smtpUsername: _joi["default"].string().required(),
  smtpFrom: _joi["default"].string().required(),
  testMail: _joi["default"].string().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, smtpHost, smtpPort, smtpPassword, smtpUsername, smtpFrom, testMail, userName, companyId;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, smtpHost = _req$body.smtpHost, smtpPort = _req$body.smtpPort, smtpPassword = _req$body.smtpPassword, smtpUsername = _req$body.smtpUsername, smtpFrom = _req$body.smtpFrom, testMail = _req$body.testMail;
          userName = req.user.firstName;
          companyId = req.user.companyId;
          console.log(req.body);
          _context.next = 7;
          return _mailer["default"].sendTestMail(userName, smtpHost, smtpPort, smtpPassword, smtpUsername, smtpFrom, testMail, companyId);
        case 7:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Succesfully sent a test mail!"
          }));
        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(new RequestError('Unable to send test mail! Kindly check credentials.'));
        case 14:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 10]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwic210cEhvc3QiLCJzdHJpbmciLCJyZXF1aXJlZCIsInNtdHBQb3J0Iiwic210cFBhc3N3b3JkIiwic210cFVzZXJuYW1lIiwic210cEZyb20iLCJ0ZXN0TWFpbCIsImNvbnRyb2xsZXIiLCJyZXEiLCJyZXMiLCJuZXh0IiwiYm9keSIsInVzZXJOYW1lIiwidXNlciIsImZpcnN0TmFtZSIsImNvbXBhbnlJZCIsImNvbnNvbGUiLCJsb2ciLCJtYWlsZXIiLCJzZW5kVGVzdE1haWwiLCJzdGF0dXMiLCJzZW5kIiwic3VjY2VzcyIsIm1lc3NhZ2UiLCJSZXF1ZXN0RXJyb3IiLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJwb3N0IiwiaHRtbHNhbml0aXplIiwiand0U3RyYXRlZ3kiLCJwZXJtaXNzaW9uIiwidmFsaWRhdGVCb2R5Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9zZXR0aW5ncy90ZXN0LW1haWwuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEpvaSBmcm9tICdqb2knO1xuaW1wb3J0IGV4cHJlc3MgZnJvbSAnZXhwcmVzcyc7XG5cbmltcG9ydCB7IHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVyJztcbmltcG9ydCB7IGp3dFN0cmF0ZWd5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc3RyYXRlZ3knO1xuaW1wb3J0IHsgdmFsaWRhdGVCb2R5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvdmFsaWRhdG9yJztcbmltcG9ydCB7IHBlcm1pc3Npb24gfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9wZXJtaXNzaW9uJztcbmltcG9ydCBtYWlsZXIgZnJvbSAnLi4vLi4vbWFpbGVyJ1xuaW1wb3J0IHsgaHRtbHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVIdG1sJztcblxuY29uc3QgdmFsaWRhdG9yID0gSm9pLm9iamVjdCgpLmtleXMoe1xuICAgIHNtdHBIb3N0OiBKb2kuc3RyaW5nKCkucmVxdWlyZWQoKSxcbiAgICBzbXRwUG9ydDogSm9pLnN0cmluZygpLnJlcXVpcmVkKCksXG4gICAgc210cFBhc3N3b3JkOiBKb2kuc3RyaW5nKCkucmVxdWlyZWQoKSxcbiAgICBzbXRwVXNlcm5hbWU6IEpvaS5zdHJpbmcoKS5yZXF1aXJlZCgpLFxuICAgIHNtdHBGcm9tOiBKb2kuc3RyaW5nKCkucmVxdWlyZWQoKSxcbiAgICB0ZXN0TWFpbDogSm9pLnN0cmluZygpLnJlcXVpcmVkKCksXG59KTtcblxuY29uc3QgY29udHJvbGxlciA9IGFzeW5jIChyZXEsIHJlcywgbmV4dCkgPT4ge1xuICAgIHRyeSB7XG4gICAgICAgIGNvbnN0IHsgc210cEhvc3QsIHNtdHBQb3J0LCBzbXRwUGFzc3dvcmQsIHNtdHBVc2VybmFtZSwgc210cEZyb20sIHRlc3RNYWlsIH0gPSByZXEuYm9keTtcbiAgICAgICAgY29uc3QgdXNlck5hbWUgPSByZXEudXNlci5maXJzdE5hbWU7XG4gICAgICAgIGNvbnN0IGNvbXBhbnlJZCA9IHJlcS51c2VyLmNvbXBhbnlJZDtcbiAgICAgICAgY29uc29sZS5sb2cocmVxLmJvZHkpXG4gICAgICAgIGF3YWl0IG1haWxlci5zZW5kVGVzdE1haWwodXNlck5hbWUsIHNtdHBIb3N0LCBzbXRwUG9ydCwgc210cFBhc3N3b3JkLCBzbXRwVXNlcm5hbWUsIHNtdHBGcm9tICwgdGVzdE1haWwsIGNvbXBhbnlJZClcbiAgICAgICAgcmV0dXJuIHJlcy5zdGF0dXMoMjAwKS5zZW5kKHsgc3VjY2VzczogdHJ1ZSwgbWVzc2FnZTogXCJTdWNjZXNmdWxseSBzZW50IGEgdGVzdCBtYWlsIVwifSlcblxuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgIGNvbnNvbGUubG9nKCdlcnJvcicsIGVycm9yKTtcbiAgICAgICAgbmV4dChuZXcgUmVxdWVzdEVycm9yKCdVbmFibGUgdG8gc2VuZCB0ZXN0IG1haWwhIEtpbmRseSBjaGVjayBjcmVkZW50aWFscy4nKSlcbiAgICB9XG59XG5cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5wb3N0KGh0bWxzYW5pdGl6ZSgpLCBqd3RTdHJhdGVneSwgcGVybWlzc2lvbignU2V0dGluZ3MnLCdXcml0ZScpLHZhbGlkYXRlQm9keSh2YWxpZGF0b3IpLGNvbnRyb2xsZXIpO1xuZXhwb3J0IGRlZmF1bHQgYXBpUm91dGVyOyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBLElBQU1BLFNBQVMsR0FBR0MsZUFBRyxDQUFDQyxNQUFNLEVBQUUsQ0FBQ0MsSUFBSSxDQUFDO0VBQ2hDQyxRQUFRLEVBQUVILGVBQUcsQ0FBQ0ksTUFBTSxFQUFFLENBQUNDLFFBQVEsRUFBRTtFQUNqQ0MsUUFBUSxFQUFFTixlQUFHLENBQUNJLE1BQU0sRUFBRSxDQUFDQyxRQUFRLEVBQUU7RUFDakNFLFlBQVksRUFBRVAsZUFBRyxDQUFDSSxNQUFNLEVBQUUsQ0FBQ0MsUUFBUSxFQUFFO0VBQ3JDRyxZQUFZLEVBQUVSLGVBQUcsQ0FBQ0ksTUFBTSxFQUFFLENBQUNDLFFBQVEsRUFBRTtFQUNyQ0ksUUFBUSxFQUFFVCxlQUFHLENBQUNJLE1BQU0sRUFBRSxDQUFDQyxRQUFRLEVBQUU7RUFDakNLLFFBQVEsRUFBRVYsZUFBRyxDQUFDSSxNQUFNLEVBQUUsQ0FBQ0MsUUFBUTtBQUNuQyxDQUFDLENBQUM7QUFFRixJQUFNTSxVQUFVO0VBQUEseUZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUFBLFlBRStDRixHQUFHLENBQUNHLElBQUksRUFBL0VaLFFBQVEsYUFBUkEsUUFBUSxFQUFFRyxRQUFRLGFBQVJBLFFBQVEsRUFBRUMsWUFBWSxhQUFaQSxZQUFZLEVBQUVDLFlBQVksYUFBWkEsWUFBWSxFQUFFQyxRQUFRLGFBQVJBLFFBQVEsRUFBRUMsUUFBUSxhQUFSQSxRQUFRO1VBQ3BFTSxRQUFRLEdBQUdKLEdBQUcsQ0FBQ0ssSUFBSSxDQUFDQyxTQUFTO1VBQzdCQyxTQUFTLEdBQUdQLEdBQUcsQ0FBQ0ssSUFBSSxDQUFDRSxTQUFTO1VBQ3BDQyxPQUFPLENBQUNDLEdBQUcsQ0FBQ1QsR0FBRyxDQUFDRyxJQUFJLENBQUM7VUFBQTtVQUFBLE9BQ2ZPLGtCQUFNLENBQUNDLFlBQVksQ0FBQ1AsUUFBUSxFQUFFYixRQUFRLEVBQUVHLFFBQVEsRUFBRUMsWUFBWSxFQUFFQyxZQUFZLEVBQUVDLFFBQVEsRUFBR0MsUUFBUSxFQUFFUyxTQUFTLENBQUM7UUFBQTtVQUFBLGlDQUM1R04sR0FBRyxDQUFDVyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFQyxPQUFPLEVBQUU7VUFBK0IsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBO1VBR3ZGUCxPQUFPLENBQUNDLEdBQUcsQ0FBQyxPQUFPLGNBQVE7VUFDM0JQLElBQUksQ0FBQyxJQUFJYyxZQUFZLENBQUMscURBQXFELENBQUMsQ0FBQztRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUVwRjtFQUFBLGdCQWJLakIsVUFBVTtJQUFBO0VBQUE7QUFBQSxHQWFmO0FBRUQsSUFBTWtCLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDLElBQUFDLDBCQUFZLEdBQUUsRUFBRUMscUJBQVcsRUFBRSxJQUFBQyxzQkFBVSxFQUFDLFVBQVUsRUFBQyxPQUFPLENBQUMsRUFBQyxJQUFBQyx1QkFBWSxFQUFDdEMsU0FBUyxDQUFDLEVBQUNZLFVBQVUsQ0FBQztBQUFDLGVBQzNHa0IsU0FBUztBQUFBIn0=