"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  tsatUrl: _joi["default"].string(),
  status: _joi["default"]["boolean"]()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, tsatUrl, status, companyId, response;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, tsatUrl = _req$body.tsatUrl, status = _req$body.status;
          companyId = req.user.companyId;
          if (!(status !== undefined)) {
            _context.next = 6;
            break;
          }
          _context.next = 6;
          return db.MetaData.updateOne({
            companyId: companyId,
            name: 'isTsat'
          }, {
            value: status
          });
        case 6:
          if (!(tsatUrl !== undefined)) {
            _context.next = 9;
            break;
          }
          _context.next = 9;
          return db.MetaData.updateOne({
            companyId: companyId,
            name: 'tsatUrl'
          }, {
            value: tsatUrl
          });
        case 9:
          response = {
            Success: true,
            message: 'Tsat Configuration updated successfully'
          };
          if (tsatUrl) response.tsatUrl = tsatUrl;else response.status = status;
          return _context.abrupt("return", res.status(200).send(response));
        case 14:
          _context.prev = 14;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 14]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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