"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  broadcastEnabled: _joi["default"]["boolean"]().required(),
  broadcastThreshold: _joi["default"].number().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$body, broadcastEnabled, broadcastThreshold, company;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _req$body = req.body, broadcastEnabled = _req$body.broadcastEnabled, broadcastThreshold = _req$body.broadcastThreshold;
          _context.next = 5;
          return db.Company.findById(companyId);
        case 5:
          company = _context.sent;
          if (company) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Invalid companyId received!');
        case 8:
          _context.next = 10;
          return db.Company.updateOne({
            _id: companyId
          }, {
            broadcastThreshold: broadcastEnabled == false ? 0 : broadcastThreshold
          });
        case 10:
          if (!broadcastEnabled) {
            _context.next = 14;
            break;
          }
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Broadcast email threshold updated successfully!"
          }));
        case 14:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Broadcast disabled successfully!"
          }));
        case 15:
          _context.next = 21;
          break;
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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