"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  messengerEnabled: _joi["default"]["boolean"]().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, messengerEnabled, company, metadata;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          messengerEnabled = req.body.messengerEnabled;
          _context.next = 5;
          return db.Company.findById(companyId);
        case 5:
          company = _context.sent;
          if (company) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Invalid companyId received!');
        case 8:
          _context.next = 10;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'isMessengerEnabled'
          });
        case 10:
          metadata = _context.sent;
          if (!metadata) {
            _context.next = 16;
            break;
          }
          _context.next = 14;
          return db.MetaData.updateOne({
            _id: metadata._id
          }, {
            value: messengerEnabled
          });
        case 14:
          _context.next = 18;
          break;
        case 16:
          _context.next = 18;
          return db.MetaData.create({
            companyId: companyId,
            name: 'isMessengerEnabled',
            value: messengerEnabled
          });
        case 18:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Messenger configuration updated successfully!"
          }));
        case 21:
          _context.prev = 21;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 25:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 21]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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