"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  defaultReportingMethod: _joi["default"]["boolean"]().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, defaultReportingMethod, company;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          defaultReportingMethod = req.body.defaultReportingMethod;
          _context.next = 5;
          return db.Company.findOne({
            _id: companyId,
            deletedAt: null
          });
        case 5:
          company = _context.sent;
          if (company) {
            _context.next = 8;
            break;
          }
          throw new RequestError("Company not found!");
        case 8:
          if (!defaultReportingMethod) {
            _context.next = 15;
            break;
          }
          _context.next = 11;
          return db.Company.updateOne({
            _id: companyId,
            deletedAt: null
          }, {
            reportingMethod: "Default"
          });
        case 11:
          _context.next = 13;
          return db.Domain.updateMany({
            companyId: companyId,
            domainTypeForOutlook: "OFFICE365",
            deletedAt: null
          }, {
            webhookEmail: null
          });
        case 13:
          _context.next = 17;
          break;
        case 15:
          _context.next = 17;
          return db.Company.updateOne({
            _id: companyId,
            deletedAt: null
          }, {
            reportingMethod: "Email Client"
          });
        case 17:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Reporting method updated successfully!"
          }));
        case 20:
          _context.prev = 20;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 20]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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