"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  timeZone: _joi["default"].string().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, timeZone, timeZoneOfCompany;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          timeZone = req.body.timeZone;
          _context.next = 5;
          return db.MetaData.findOne({
            name: "timeZone",
            companyId: companyId
          });
        case 5:
          timeZoneOfCompany = _context.sent;
          console.log({
            timeZoneOfCompany: timeZoneOfCompany
          });
          if (!timeZoneOfCompany) {
            _context.next = 12;
            break;
          }
          _context.next = 10;
          return db.MetaData.updateOne({
            name: "timeZone",
            companyId: companyId
          }, {
            value: timeZone
          });
        case 10:
          _context.next = 14;
          break;
        case 12:
          _context.next = 14;
          return db.MetaData.create({
            name: "timeZone",
            companyId: companyId,
            value: timeZone
          });
        case 14:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'Timezone updated successfully!'
          }));
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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